/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos.utilities;

import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrix.ecos.EcosListener;
import jmri.jmrix.ecos.EcosLocoAddress;
import jmri.jmrix.ecos.EcosLocoAddressManager;
import jmri.jmrix.ecos.EcosMessage;
import jmri.jmrix.ecos.EcosPreferences;
import jmri.jmrix.ecos.EcosReply;
import jmri.jmrix.ecos.EcosSystemConnectionMemo;
import jmri.jmrix.ecos.EcosTrafficController;

public class RosterToEcos
implements EcosListener {
    private EcosLocoAddress objEcosLoco = null;
    private EcosLocoAddressManager objEcosLocoManager;
    protected RosterEntry _re = null;
    private EcosPreferences ep;
    EcosTrafficController tc;
    private boolean createloco;
    EcosSystemConnectionMemo adaptermemo;

    public RosterToEcos(EcosSystemConnectionMemo memo) {
        this.adaptermemo = memo;
        this.tc = this.adaptermemo.getTrafficController();
        this.ep = this.adaptermemo.getPreferenceManager();
        this.objEcosLocoManager = this.adaptermemo.getLocoAddressManager();
    }

    public void createEcosLoco(RosterEntry re) {
        String protocol;
        if (this.createloco) {
            return;
        }
        this.createloco = true;
        this._re = re;
        switch (re.getProtocol()) {
            case MOTOROLA: {
                protocol = "MM28";
                break;
            }
            case SELECTRIX: {
                protocol = "SX28";
                break;
            }
            case MFX: {
                protocol = "MMFKT";
                break;
            }
            default: {
                protocol = "DCC128";
            }
        }
        String message = "create(10, addr[" + this._re.getDccAddress() + "], name[\"" + this.description() + "\"], protocol[" + protocol + "], append)";
        EcosMessage m = new EcosMessage(message);
        this.tc.sendEcosMessage(m, this);
    }

    private String description() {
        String result = "";
        String str = this.ep.getEcosLocoDescription();
        if (str == null || str.isEmpty()) {
            return this._re.getId();
        }
        char comp = '%';
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == comp) {
                switch (str.charAt(i + 1)) {
                    case 'i': {
                        result = String.valueOf(result) + this._re.getId();
                        break;
                    }
                    case 'r': {
                        result = String.valueOf(result) + this._re.getRoadName();
                        break;
                    }
                    case 'n': {
                        result = String.valueOf(result) + this._re.getRoadNumber();
                        break;
                    }
                    case 'm': {
                        result = String.valueOf(result) + this._re.getMfg();
                        break;
                    }
                    case 'o': {
                        result = String.valueOf(result) + this._re.getOwner();
                        break;
                    }
                    case 'l': {
                        result = String.valueOf(result) + this._re.getModel();
                        break;
                    }
                    case 'c': {
                        result = String.valueOf(result) + this._re.getComment();
                        break;
                    }
                }
                ++i;
            } else {
                result = String.valueOf(result) + str.charAt(i);
            }
            ++i;
        }
        return result;
    }

    @Override
    public void reply(EcosReply m) {
        String msg = m.toString();
        String[] lines = msg.split("\n");
        if (m.getResultCode() == 0 && lines[0].startsWith("<REPLY create(10, addr")) {
            int i = 1;
            while (i < lines.length - 1) {
                if (lines[i].contains("10 id[")) {
                    int start = lines[i].indexOf(91) + 1;
                    int end = lines[i].indexOf(93);
                    String EcosAddr = lines[i].substring(start, end);
                    this.objEcosLoco = this.objEcosLocoManager.provideByEcosObject(EcosAddr);
                    this.objEcosLoco.setEcosTempEntry(false);
                    this._re.putAttribute(this.ep.getRosterAttribute(), EcosAddr);
                    this.objEcosLoco.setRosterId(this._re.getId());
                    this.objEcosLoco.setEcosDescription(this.description());
                    this.objEcosLoco.setLocoAddress(Integer.parseInt(this._re.getDccAddress()));
                    switch (this._re.getProtocol()) {
                        case MOTOROLA: {
                            this.objEcosLoco.setProtocol("MM28");
                            break;
                        }
                        case SELECTRIX: {
                            this.objEcosLoco.setProtocol("SX28");
                            break;
                        }
                        case MFX: {
                            this.objEcosLoco.setProtocol("MMFKT");
                            break;
                        }
                        default: {
                            this.objEcosLoco.setProtocol("DCC128");
                        }
                    }
                    this._re.writeFile(null, null);
                    Roster.getDefault().writeRoster();
                    this.objEcosLocoManager.register(this.objEcosLoco);
                    this.createloco = false;
                    this.dispose();
                }
                ++i;
            }
        }
    }

    @Override
    public void message(EcosMessage m) {
    }

    void dispose() {
        this.objEcosLoco = null;
        this.objEcosLocoManager = null;
        this._re = null;
        this.createloco = false;
    }
}

