/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos.utilities;

import javax.swing.JOptionPane;
import jmri.jmrix.ecos.EcosListener;
import jmri.jmrix.ecos.EcosMessage;
import jmri.jmrix.ecos.EcosReply;
import jmri.jmrix.ecos.EcosTrafficController;
import jmri.jmrix.ecos.utilities.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveObjectFromEcos
implements EcosListener {
    private String _ecosObject;
    private int ecosretry;
    private EcosTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(RemoveObjectFromEcos.class);

    public void removeObjectFromEcos(String ecosObject, EcosTrafficController etc) {
        this.tc = etc;
        this._ecosObject = ecosObject;
        log.debug("Call to delete Object {} from the Ecos", (Object)ecosObject);
        this.tc = etc;
        String message = "request(" + this._ecosObject + ", control, view)";
        EcosMessage m = new EcosMessage(message);
        this.tc.sendEcosMessage(m, this);
    }

    @Override
    public void reply(EcosReply m) {
        String msg = m.toString();
        String[] lines = msg.split("\n");
        if (m.getResultCode() == 0) {
            if (lines[0].startsWith("<REPLY request(" + this._ecosObject + ",")) {
                this.deleteObject();
            }
        } else if (m.getResultCode() == 25) {
            log.info("We have no control over the ecos object {}Retry Counter = {}", (Object)this._ecosObject, (Object)this.ecosretry);
            this.retryControl();
        }
    }

    private void retryControl() {
        if (this.ecosretry < 3) {
            ++this.ecosretry;
            String message = "request(" + this._ecosObject + ", control)";
            EcosMessage ms = new EcosMessage(message);
            this.tc.sendEcosMessage(ms, this);
            log.error("JMRI has no control over the ecos object {}. Retrying Attempt {}", (Object)this._ecosObject, (Object)this.ecosretry);
        } else {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("DeleteFromEcosWarning"), Bundle.getMessage("WarningTitle"), 2);
            this.ecosretry = 0;
        }
    }

    private void deleteObject() {
        String message = "delete(" + this._ecosObject + ")";
        EcosMessage m = new EcosMessage(message);
        this.tc.sendEcosMessage(m, this);
    }

    @Override
    public void message(EcosMessage m) {
    }
}

