/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos.utilities;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.Programmer;
import jmri.jmrit.XmlFile;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterConfigManager;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.ResetTableModel;
import jmri.jmrit.symbolicprog.VariableTableModel;
import jmri.jmrix.ecos.EcosListener;
import jmri.jmrix.ecos.EcosLocoAddress;
import jmri.jmrix.ecos.EcosLocoAddressManager;
import jmri.jmrix.ecos.EcosMessage;
import jmri.jmrix.ecos.EcosPreferences;
import jmri.jmrix.ecos.EcosReply;
import jmri.jmrix.ecos.EcosSystemConnectionMemo;
import jmri.jmrix.ecos.utilities.Bundle;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcosLocoToRoster
implements EcosListener {
    EcosLocoAddressManager ecosManager;
    EcosLocoAddress ecosLoco;
    RosterEntry re;
    String filename = null;
    DecoderFile pDecoderFile = null;
    String _ecosObject;
    int _ecosObjectInt;
    Label _statusLabel = null;
    CvTableModel cvModel = null;
    Programmer mProgrammer;
    JLabel progStatus;
    protected JComboBox<?> locoBox = null;
    protected JToggleButton iddecoder;
    JFrame frame;
    EcosSystemConnectionMemo adaptermemo;
    EcosPreferences p;
    boolean suppressFurtherAdditions = false;
    boolean waitingForComplete = false;
    boolean inProcess = false;
    ArrayList<EcosLocoAddress> locoList = new ArrayList();
    JTree dTree;
    DefaultTreeModel dModel;
    DefaultMutableTreeNode dRoot;
    TreeSelectionListener dListener;
    Element modelElem = null;
    Element decoderRoot = null;
    VariableTableModel variableModel;
    Element programmerRoot = null;
    ResetTableModel resetModel = null;
    boolean getFunctionSupported = true;
    private static final Logger log = LoggerFactory.getLogger(EcosLocoToRoster.class);

    public EcosLocoToRoster(EcosSystemConnectionMemo memo) {
        this.adaptermemo = memo;
        this.p = this.adaptermemo.getPreferenceManager();
    }

    public void addToQueue(EcosLocoAddress ecosObject) {
        this.locoList.add(ecosObject);
    }

    public void processQueue() {
        if (this.inProcess) {
            return;
        }
        this.suppressFurtherAdditions = false;
        this.inProcess = true;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                while (EcosLocoToRoster.this.locoList.size() != 0) {
                    EcosLocoAddress tmploco = EcosLocoToRoster.this.locoList.get(0);
                    EcosLocoToRoster.this.waitingForComplete = false;
                    if (EcosLocoToRoster.this.p.getAddLocoToJMRI() == 2) {
                        EcosLocoToRoster.this.adaptermemo.getLocoAddressManager().setLocoToRoster();
                        EcosLocoToRoster.this.ecosLocoToRoster(tmploco.getEcosObject());
                    } else if (!EcosLocoToRoster.this.suppressFurtherAdditions && tmploco.addToRoster() && tmploco.getRosterId() == null) {
                        try {
                            class WindowMaker
                            implements Runnable {
                                EcosLocoAddress ecosObject;

                                WindowMaker(EcosLocoAddress o) {
                                    this.ecosObject = o;
                                }

                                @Override
                                public void run() {
                                    final JDialog dialog = new JDialog();
                                    dialog.setTitle(Bundle.getMessage("AddRosterEntryQuestion"));
                                    dialog.setDefaultCloseOperation(2);
                                    JPanel container = new JPanel();
                                    container.setLayout(new BoxLayout(container, 1));
                                    container.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                                    JLabel question = new JLabel(Bundle.getMessage("LocoAddedJMessage", this.ecosObject.getEcosDescription(), (this).EcosLocoToRoster.this.adaptermemo.getUserName()));
                                    question.setAlignmentX(0.5f);
                                    container.add(question);
                                    question = new JLabel(Bundle.getMessage("AddToJMRIQuestion"));
                                    question.setAlignmentX(0.5f);
                                    container.add(question);
                                    final JCheckBox remember = new JCheckBox(Bundle.getMessage("MessageRememberSetting"));
                                    remember.setFont(remember.getFont().deriveFont(10.0f));
                                    remember.setAlignmentX(0.5f);
                                    remember.setVisible(true);
                                    JButton yesButton = new JButton(Bundle.getMessage("ButtonYes"));
                                    JButton noButton = new JButton(Bundle.getMessage("ButtonNo"));
                                    JPanel button = new JPanel();
                                    button.setAlignmentX(0.5f);
                                    button.add(yesButton);
                                    button.add(noButton);
                                    container.add(button);
                                    noButton.addActionListener(new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent e) {
                                            ecosObject.doNotAddToRoster();
                                            (((WindowMaker)this).this).EcosLocoToRoster.this.waitingForComplete = true;
                                            if (remember.isSelected()) {
                                                (((WindowMaker)this).this).EcosLocoToRoster.this.suppressFurtherAdditions = true;
                                                (((WindowMaker)this).this).EcosLocoToRoster.this.p.setAddLocoToJMRI(1);
                                            }
                                            dialog.dispose();
                                        }
                                    });
                                    yesButton.addActionListener(new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent e) {
                                            if (remember.isSelected()) {
                                                (((WindowMaker)this).this).EcosLocoToRoster.this.p.setAddLocoToJMRI(2);
                                            }
                                            EcosLocoToRoster.this.ecosLocoToRoster(ecosObject.getEcosObject());
                                            dialog.dispose();
                                        }
                                    });
                                    container.add(remember);
                                    container.setAlignmentX(0.5f);
                                    container.setAlignmentY(0.5f);
                                    dialog.getContentPane().add(container);
                                    dialog.pack();
                                    Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                                    int w = dialog.getSize().width;
                                    int h = dialog.getSize().height;
                                    int x = (dim.width - w) / 2;
                                    int y = (dim.height - h) / 2;
                                    dialog.setLocation(x, y);
                                    dialog.setModal(true);
                                    dialog.setVisible(true);
                                }
                            }
                            WindowMaker t = new WindowMaker(tmploco);
                            SwingUtilities.invokeAndWait(t);
                        }
                        catch (InterruptedException | InvocationTargetException ex) {
                            log.warn("Exception, ending", (Throwable)ex);
                            return;
                        }
                    } else {
                        EcosLocoToRoster.this.waitingForComplete = true;
                    }
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                while (!(this).EcosLocoToRoster.this.waitingForComplete) {
                                    Thread.sleep(500L);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    };
                    Thread thr = new Thread(r);
                    thr.start();
                    thr.setName("Ecos Loco To Roster Inner thread");
                    try {
                        thr.join();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    EcosLocoToRoster.this.locoList.remove(0);
                }
                EcosLocoToRoster.this.inProcess = false;
            }
        };
        Thread thread = new Thread(run);
        thread.setName("Ecos Loco To Roster");
        thread.start();
    }

    public void ecosLocoToRoster(String ecosObject) {
        this.frame = new JFrame();
        this._ecosObject = ecosObject;
        this._ecosObjectInt = Integer.parseInt(this._ecosObject);
        this.ecosManager = this.adaptermemo.getLocoAddressManager();
        this.ecosLoco = this.ecosManager.getByEcosObject(ecosObject);
        String rosterId = this.ecosLoco.getEcosDescription();
        if (this.checkDuplicate(rosterId)) {
            int count = 0;
            String oldrosterId = rosterId;
            while (this.checkDuplicate(rosterId)) {
                rosterId = String.valueOf(oldrosterId) + "_" + count;
                ++count;
            }
        }
        this.re = new RosterEntry();
        this.re.setId(rosterId);
        List<DecoderFile> decoder = InstanceManager.getDefault(DecoderIndexFile.class).matchingDecoderList(null, null, this.ecosLoco.getCVAsString(8), this.ecosLoco.getCVAsString(7), null, null);
        if (decoder.size() == 1) {
            this.pDecoderFile = decoder.get(0);
            this.selectedDecoder(this.pDecoderFile);
        } else {
            class WindowMaker
            implements Runnable {
                WindowMaker() {
                }

                @Override
                public void run() {
                    EcosLocoToRoster.this.comboPanel();
                }
            }
            WindowMaker t = new WindowMaker();
            SwingUtilities.invokeLater(t);
        }
    }

    @Override
    @SuppressFBWarnings(value={"CF_USELESS_CONTROL_FLOW"}, justification="TODO fill out the actions in these clauses")
    public void reply(EcosReply m) {
        String msg = m.toString();
        String[] lines = msg.split("\n");
        if (m.getResultCode() == 0 && lines[0].startsWith("<REPLY get(" + this._ecosObject + ", funcdesc")) {
            int functNo = 0;
            try {
                int startval = lines[1].indexOf("[") + 1;
                int endval = lines[1].substring(startval).indexOf(",") + startval;
                boolean moment = true;
                functNo = Integer.parseInt(lines[1].substring(startval, endval));
                startval = endval + 1;
                endval = lines[1].substring(startval).indexOf(",");
                if (endval == -1) {
                    endval = lines[1].substring(startval).indexOf("]");
                    moment = false;
                }
                endval += startval;
                if (lines[1].contains("moment")) {
                    moment = true;
                }
                int functDesc = Integer.parseInt(lines[1].substring(startval, endval));
                String functionLabel = "";
                switch (functDesc) {
                    case 2: {
                        functionLabel = "function";
                        break;
                    }
                    case 3: {
                        functionLabel = "light";
                        break;
                    }
                    case 4: {
                        functionLabel = "light_0";
                        break;
                    }
                    case 5: {
                        functionLabel = "light_1";
                        break;
                    }
                    case 7: {
                        functionLabel = "sound";
                        break;
                    }
                    case 8: {
                        functionLabel = "music";
                        break;
                    }
                    case 9: {
                        functionLabel = "announce";
                        break;
                    }
                    case 10: {
                        functionLabel = "routing_speed";
                        break;
                    }
                    case 11: {
                        functionLabel = "abv";
                        break;
                    }
                    case 32: {
                        functionLabel = "coupler";
                        break;
                    }
                    case 33: {
                        functionLabel = "steam";
                        break;
                    }
                    case 34: {
                        functionLabel = "panto";
                        break;
                    }
                    case 35: {
                        functionLabel = "highbeam";
                        break;
                    }
                    case 36: {
                        functionLabel = "bell";
                        break;
                    }
                    case 37: {
                        functionLabel = "horn";
                        break;
                    }
                    case 38: {
                        functionLabel = "whistle";
                        break;
                    }
                    case 39: {
                        functionLabel = "door_sound";
                        break;
                    }
                    case 40: {
                        functionLabel = "fan";
                        break;
                    }
                    case 42: {
                        functionLabel = "shovel_work_sound";
                        break;
                    }
                    case 44: {
                        functionLabel = "shift";
                        break;
                    }
                    case 260: {
                        functionLabel = "interior_lighting";
                        break;
                    }
                    case 261: {
                        functionLabel = "plate_light";
                        break;
                    }
                    case 263: {
                        functionLabel = "brakesound";
                        break;
                    }
                    case 299: {
                        functionLabel = "crane_raise_lower";
                        break;
                    }
                    case 555: {
                        functionLabel = "hook_up_down";
                        break;
                    }
                    case 773: {
                        functionLabel = "wheel_light";
                        break;
                    }
                    case 811: {
                        functionLabel = "turn";
                        break;
                    }
                    case 1031: {
                        functionLabel = "steam-blow";
                        break;
                    }
                    case 1033: {
                        functionLabel = "radio_sound";
                        break;
                    }
                    case 1287: {
                        functionLabel = "coupler_sound";
                        break;
                    }
                    case 1543: {
                        functionLabel = "track_sound";
                        break;
                    }
                    case 1607: {
                        functionLabel = "notch_up";
                        break;
                    }
                    case 1608: {
                        functionLabel = "notch_down";
                        break;
                    }
                    case 2055: {
                        functionLabel = "thunderer_whistle";
                        break;
                    }
                    case 3847: {
                        functionLabel = "buffer_sound";
                        break;
                    }
                }
                this.re.setFunctionLabel(functNo, functionLabel);
                this.re.setFunctionLockable(functNo, !moment);
            }
            catch (RuntimeException e) {
                log.error("Error occurred while getting the function information : {}", (Object)e.toString());
            }
            this.getFunctionDetails(functNo + 1);
        }
    }

    @Override
    public void message(EcosMessage m) {
    }

    void storeloco() {
        Roster.getDefault().addEntry(this.re);
        this.ecosLoco.setRosterId(this.re.getId());
        this.re.ensureFilenameExists();
        this.re.writeFile(null, null);
        Roster.getDefault().writeRoster();
        this.ecosManager.clearLocoToRoster();
    }

    public void comboPanel() {
        this.frame.setTitle(Bundle.getMessage("DecoderSelectionXTitle", this.ecosLoco.getEcosDescription()));
        this.frame.getContentPane().setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        JPanel p1 = new JPanel();
        JPanel p2 = new JPanel();
        JPanel p3 = this.layoutDecoderSelection();
        topPanel.setLayout(new BorderLayout());
        JLabel jLabel1 = new JLabel(Bundle.getMessage("DecoderNoIDWarning"));
        JButton okayButton = new JButton(Bundle.getMessage("ButtonOK"));
        p1.add(jLabel1);
        p2.add(okayButton);
        topPanel.add(p1);
        topPanel.add(p3);
        topPanel.add(p2);
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        this.frame.getContentPane().add(topPanel);
        this.frame.pack();
        this.frame.setVisible(true);
        this.frame.toFront();
        this.frame.setFocusable(true);
        this.frame.setFocusableWindowState(true);
        this.frame.requestFocus();
        this.frame.setAlwaysOnTop(true);
        this.frame.setAlwaysOnTop(false);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = this.frame.getSize().width;
        int h = this.frame.getSize().height;
        int x = (dim.width - w) / 2;
        int y = (dim.height - h) / 2;
        this.frame.setLocation(x, y);
        this.frame.setVisible(true);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent winEvt) {
                EcosLocoToRoster.this.ecosManager.clearLocoToRoster();
            }
        });
        ActionListener okayButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EcosLocoToRoster.this.okayButton();
            }
        };
        okayButton.addActionListener(okayButtonAction);
    }

    String selectedDecoderType() {
        if (!this.isDecoderSelected()) {
            return null;
        }
        return ((DecoderTreeNode)this.dTree.getLastSelectedPathComponent()).getTitle();
    }

    boolean isDecoderSelected() {
        return !this.dTree.isSelectionEmpty();
    }

    private void okayButton() {
        this.pDecoderFile = InstanceManager.getDefault(DecoderIndexFile.class).fileFromTitle(this.selectedDecoderType());
        this.selectedDecoder(this.pDecoderFile);
        this.frame.dispose();
    }

    private void selectedDecoder(DecoderFile pDecoderFile) {
        this.re.setDecoderModel(pDecoderFile.getModel());
        this.re.setDecoderFamily(pDecoderFile.getFamily());
        if (this.ecosLoco.getNumber() == 0) {
            this.re.setDccAddress(Integer.toString(EcosLocoAddress.MFX_DCCAddressOffset + this.ecosLoco.getEcosObjectAsInt()));
        } else {
            this.re.setDccAddress(Integer.toString(this.ecosLoco.getNumber()));
        }
        this.re.setRoadName("");
        this.re.setRoadNumber("");
        this.re.setMfg("");
        this.re.setModel("");
        this.re.setOwner(InstanceManager.getDefault(RosterConfigManager.class).getDefaultOwner());
        this.re.setComment(Bundle.getMessage("LocoAutoAdded"));
        this.re.setDecoderComment("");
        this.re.putAttribute(this.adaptermemo.getPreferenceManager().getRosterAttribute(), this._ecosObject);
        this.re.ensureFilenameExists();
        if (this.ecosLoco.getECOSProtocol().startsWith("DCC")) {
            if (this.ecosLoco.getNumber() <= 127) {
                this.re.setProtocol(LocoAddress.Protocol.DCC_SHORT);
            } else {
                this.re.setProtocol(LocoAddress.Protocol.DCC_LONG);
            }
        } else if (this.ecosLoco.getECOSProtocol().equals("MMFKT") || this.ecosLoco.getECOSProtocol().equals("MFX")) {
            this.re.setProtocol(LocoAddress.Protocol.MFX);
        } else if (this.ecosLoco.getECOSProtocol().startsWith("MM")) {
            this.re.setProtocol(LocoAddress.Protocol.MOTOROLA);
        } else if (this.ecosLoco.getECOSProtocol().equals("SX32")) {
            this.re.setProtocol(LocoAddress.Protocol.SELECTRIX);
        }
        this.mProgrammer = null;
        this.cvModel = new CvTableModel(this.progStatus, this.mProgrammer);
        this.variableModel = new VariableTableModel(this.progStatus, new String[]{"CV", "Value"}, this.cvModel);
        this.resetModel = new ResetTableModel(this.progStatus, this.mProgrammer);
        this.storeloco();
        this.filename = "programmers" + File.separator + "Basic.xml";
        this.loadProgrammerFile(this.re);
        this.loadDecoderFile(pDecoderFile, this.re);
        this.variableModel.findVar("Speed Step Mode").setIntValue(0);
        if (this.ecosLoco.getECOSProtocol().equals("DCC128")) {
            this.variableModel.findVar("Speed Step Mode").setIntValue(1);
        }
        this.re.writeFile(this.cvModel, this.variableModel);
        this.getFunctionDetails(0);
        JOptionPane.showMessageDialog(this.frame, Bundle.getMessage("LocoAddedJDialog"));
        this.waitingForComplete = true;
    }

    public boolean checkDuplicate(String id) {
        List<RosterEntry> l = Roster.getDefault().matchingList(null, null, null, null, null, null, id);
        boolean oops = false;
        int i = 0;
        while (i < l.size()) {
            if (this.re != l.get(i)) {
                oops = true;
            }
            ++i;
        }
        return oops;
    }

    protected JPanel layoutDecoderSelection() {
        JPanel pane1a = new JPanel();
        pane1a.setLayout(new BoxLayout(pane1a, 0));
        this.dRoot = new DefaultMutableTreeNode("Root");
        this.dModel = new DefaultTreeModel(this.dRoot);
        this.dTree = new JTree(this.dModel){

            @Override
            public String getToolTipText(MouseEvent evt) {
                if (this.getRowForLocation(evt.getX(), evt.getY()) == -1) {
                    return null;
                }
                TreePath curPath = this.getPathForLocation(evt.getX(), evt.getY());
                return ((DecoderTreeNode)curPath.getLastPathComponent()).getToolTipText();
            }
        };
        this.dTree.setToolTipText("");
        List<DecoderFile> decoders = InstanceManager.getDefault(DecoderIndexFile.class).matchingDecoderList(null, null, null, null, null, null);
        int len = decoders.size();
        DefaultMutableTreeNode mfgElement = null;
        DefaultMutableTreeNode familyElement = null;
        int i = 0;
        while (i < len) {
            DecoderFile decoder = decoders.get(i);
            String mfg = decoder.getMfg();
            String family = decoder.getFamily();
            String model = decoder.getModel();
            log.debug(" process {}/{}/{} on nodes {}/{}", new Object[]{mfg, family, model, mfgElement == null ? "<null>" : String.valueOf(mfgElement.toString()) + "(" + mfgElement.getChildCount() + ")", familyElement == null ? "<null>" : String.valueOf(familyElement.toString()) + "(" + familyElement.getChildCount() + ")"});
            if (mfgElement == null || !mfg.equals(mfgElement.toString())) {
                mfgElement = new DecoderTreeNode(mfg, "CV8 = " + InstanceManager.getDefault(DecoderIndexFile.class).mfgIdFromName(mfg), "");
                this.dModel.insertNodeInto(mfgElement, this.dRoot, this.dRoot.getChildCount());
                familyElement = null;
            }
            String famComment = decoders.get(i).getFamilyComment();
            String verString = decoders.get(i).getVersionsAsString();
            String hoverText = "";
            if (famComment == null || famComment.isEmpty()) {
                if (!verString.isEmpty()) {
                    hoverText = "CV7=" + verString;
                }
            } else {
                hoverText = verString.isEmpty() ? famComment : String.valueOf(famComment) + "  CV7=" + verString;
            }
            if (familyElement == null || !family.equals(familyElement.toString())) {
                if (i + 2 >= len || decoders.get(i + 2).getFamily().equals(family) || !decoders.get(i + 1).getModel().equals(family)) {
                    log.debug("normal family update case: {}", (Object)family);
                    familyElement = new DecoderTreeNode(family, hoverText, decoders.get(i).titleString());
                    this.dModel.insertNodeInto(familyElement, mfgElement, mfgElement.getChildCount());
                } else {
                    log.debug("short case, i={} family={} next {}", new Object[]{i, family, decoders.get(i + 1).getModel()});
                    if (i + 1 > len) {
                        log.error("Unexpected single entry for family: {}", (Object)family);
                    }
                    family = decoders.get(i + 1).getModel();
                    familyElement = new DecoderTreeNode(family, hoverText, decoders.get(i).titleString());
                    this.dModel.insertNodeInto(familyElement, mfgElement, mfgElement.getChildCount());
                    ++i;
                }
            } else if (!family.equals(model)) {
                this.dModel.insertNodeInto(new DecoderTreeNode(model, hoverText, decoders.get(i).titleString()), familyElement, familyElement.getChildCount());
            }
            ++i;
        }
        pane1a.add(new JScrollPane(this.dTree));
        this.dTree.expandPath(new TreePath(this.dRoot));
        this.dTree.setRootVisible(false);
        this.dTree.setShowsRootHandles(true);
        this.dTree.setScrollsOnExpand(true);
        this.dTree.setExpandsSelectedPaths(true);
        this.dTree.getSelectionModel().setSelectionMode(1);
        this.dListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (!EcosLocoToRoster.this.dTree.isSelectionEmpty() && EcosLocoToRoster.this.dTree.getSelectionPath() != null && EcosLocoToRoster.this.dTree.getSelectionPath().getPathCount() > 2 && EcosLocoToRoster.this.dTree.getSelectionCount() < 2) {
                    log.debug("Selection event with {}", (Object)EcosLocoToRoster.this.dTree.getSelectionPath().toString());
                    if (EcosLocoToRoster.this.locoBox != null) {
                        EcosLocoToRoster.this.locoBox.setSelectedIndex(0);
                    }
                }
            }
        };
        this.dTree.addTreeSelectionListener(this.dListener);
        this.dTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                EcosLocoToRoster.this.dTree.getSelectionModel().setSelectionMode(1);
                if (me.getClickCount() == 2 && ((TreeNode)EcosLocoToRoster.this.dTree.getSelectionPath().getLastPathComponent()).isLeaf()) {
                    EcosLocoToRoster.this.okayButton();
                }
            }
        });
        this.selectDecoder(this.ecosLoco.getCVAsString(8), this.ecosLoco.getCVAsString(7));
        return pane1a;
    }

    protected void selectDecoder(String mfgID, String modelID) {
        List<DecoderFile> temp = InstanceManager.getDefault(DecoderIndexFile.class).matchingDecoderList(null, null, mfgID, modelID, null, null);
        if (log.isDebugEnabled()) {
            log.debug("selectDecoder found {} matches", (Object)temp.size());
        }
        if (temp.size() > 0) {
            this.updateForDecoderTypeID(temp);
        } else {
            String mfg = InstanceManager.getDefault(DecoderIndexFile.class).mfgNameFromID(mfgID);
            int intMfgID = Integer.parseInt(mfgID);
            int intModelID = Integer.parseInt(modelID);
            if (mfg == null) {
                this.updateForDecoderNotID(intMfgID, intModelID);
            } else {
                this.updateForDecoderMfgID(mfg, intMfgID, intModelID);
            }
        }
    }

    void updateForDecoderNotID(int pMfgID, int pModelID) {
        String msg = "Found mfg " + pMfgID + " version " + pModelID + "; no such manufacterer defined";
        log.warn(msg);
        this.dTree.clearSelection();
    }

    void updateForDecoderMfgID(String pMfg, int pMfgID, int pModelID) {
        String msg = "Found mfg " + pMfgID + " (" + pMfg + ") version " + pModelID + "; no such decoder defined";
        log.warn(msg);
        this.dTree.clearSelection();
        Enumeration<TreeNode> e = this.dRoot.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!node.toString().equals(pMfg)) continue;
            TreePath path = new TreePath(node.getPath());
            this.dTree.expandPath(path);
            this.dTree.addSelectionPath(path);
            this.dTree.scrollPathToVisible(path);
            break;
        }
    }

    void updateForDecoderTypeID(List<DecoderFile> pList) {
        if (log.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Identified ");
            buf.append(pList.size());
            buf.append(" matches: ");
            int i = 0;
            while (i < pList.size()) {
                buf.append(pList.get(i).getModel());
                buf.append(":");
                ++i;
            }
            log.debug(buf.toString());
        }
        if (pList.size() <= 0) {
            log.error("Found empty list in updateForDecoderTypeID, should not happen");
            return;
        }
        this.dTree.clearSelection();
        if (pList.size() > 1) {
            this.dTree.getSelectionModel().setSelectionMode(4);
        } else {
            this.dTree.getSelectionModel().setSelectionMode(1);
        }
        int i = 0;
        while (i < pList.size()) {
            DecoderFile f = pList.get(i);
            String findMfg = f.getMfg();
            String findFamily = f.getFamily();
            String findModel = f.getModel();
            Enumeration<TreeNode> e = this.dRoot.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                TreePath path;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                TreeNode[] list = node.getPath();
                if (list.length == 3) {
                    if (!list[1].toString().equals(findMfg) || !list[2].toString().equals(findModel)) continue;
                    path = new TreePath(node.getPath());
                    this.dTree.expandPath(path);
                    this.dTree.addSelectionPath(path);
                    this.dTree.scrollPathToVisible(path);
                    break;
                }
                if (list.length != 4 || !list[1].toString().equals(findMfg) || !list[2].toString().equals(findFamily) || !list[3].toString().equals(findModel)) continue;
                path = new TreePath(node.getPath());
                this.dTree.expandPath(path);
                this.dTree.addSelectionPath(path);
                this.dTree.scrollPathToVisible(path);
                break;
            }
            ++i;
        }
    }

    protected void loadDecoderFile(DecoderFile df, RosterEntry re) {
        if (df == null) {
            log.error("loadDecoder file invoked with null object");
            return;
        }
        log.debug("loadDecoderFile from {} {}", (Object)DecoderFile.fileLocation, (Object)df.getFileName());
        try {
            this.decoderRoot = df.rootFromName(String.valueOf(DecoderFile.fileLocation) + df.getFileName());
        }
        catch (JDOMException jDOMException) {
            log.error("JDOM Exception while loading decoder XML file: {}", (Object)df.getFileName());
        }
        catch (IOException iOException) {
            log.error("IO Exception while loading decoder XML file: {}", (Object)df.getFileName());
        }
        df.getProductID();
        df.loadVariableModel(this.decoderRoot.getChild("decoder"), this.variableModel);
        df.loadResetModel(this.decoderRoot.getChild("decoder"), this.resetModel);
        re.loadFunctions(this.decoderRoot.getChild("decoder").getChild("family").getChild("functionlabels"));
        if (this.decoderRoot.getAttribute("showEmptyPanes") != null) {
            log.debug("Found in decoder {}", (Object)this.decoderRoot.getAttribute("showEmptyPanes").getValue());
        }
        this.modelElem = df.getModelElement();
    }

    protected void loadProgrammerFile(RosterEntry r) {
        XmlFile pf = new XmlFile(){};
        try {
            this.programmerRoot = pf.rootFromName(this.filename);
            this.readConfig(this.programmerRoot, r);
        }
        catch (IOException | JDOMException e) {
            log.error("exception reading programmer file: {}", (Object)this.filename, (Object)e);
        }
    }

    void readConfig(Element root, RosterEntry r) {
        if (root.getChild("programmer") == null) {
            log.error("xml file top element is not programmer");
            return;
        }
    }

    void getFunctionDetails(int func) {
        if (func >= 29) {
            return;
        }
        String message = "get(" + this._ecosObject + ", funcdesc[" + func + "])";
        EcosMessage m = new EcosMessage(message);
        this.adaptermemo.getTrafficController().sendEcosMessage(m, this);
    }

    static class DecoderTreeNode
    extends DefaultMutableTreeNode {
        private String toolTipText;
        private String title;

        public DecoderTreeNode(String str, String toolTipText, String title) {
            super(str);
            this.toolTipText = toolTipText;
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public String getToolTipText() {
            return this.toolTipText;
        }
    }
}

