/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos.utilities;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import jmri.LocoAddress;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrix.ecos.EcosLocoAddress;
import jmri.jmrix.ecos.EcosLocoAddressManager;
import jmri.jmrix.ecos.EcosSystemConnectionMemo;
import jmri.jmrix.ecos.utilities.Bundle;
import jmri.jmrix.ecos.utilities.RosterToEcos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddRosterEntryToEcos
extends AbstractAction {
    private EcosLocoAddressManager objEcosLocoManager;
    EcosSystemConnectionMemo adaptermemo;
    JComboBox<String> rosterEntry = new JComboBox();
    JComboBox<String> selections;
    Roster roster;
    private static final Logger log = LoggerFactory.getLogger(AddRosterEntryToEcos.class);

    public AddRosterEntryToEcos(String s, EcosSystemConnectionMemo memo) {
        super(s);
        this.adaptermemo = memo;
        this.objEcosLocoManager = this.adaptermemo.getLocoAddressManager();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.roster = Roster.getDefault();
        this.rosterEntryUpdate();
        int retval = JOptionPane.showOptionDialog(null, Bundle.getMessage("AddToEcosDialog"), Bundle.getMessage("AddToEcosTitle"), 0, 1, null, new Object[]{Bundle.getMessage("ButtonCancel"), Bundle.getMessage("ButtonOK"), this.rosterEntry}, null);
        log.debug("Dialog value {} selected, {}:{}", new Object[]{retval, this.rosterEntry.getSelectedIndex(), this.rosterEntry.getSelectedItem()});
        if (retval != 1 || this.rosterEntry.getItemCount() == 0) {
            return;
        }
        String selEntry = (String)this.rosterEntry.getSelectedItem();
        RosterEntry re = this.roster.entryFromTitle(selEntry);
        log.debug("Add {} to ECoS", (Object)re.getId());
        RosterToEcos rosterToEcos = new RosterToEcos(this.adaptermemo);
        rosterToEcos.createEcosLoco(re);
    }

    void rosterEntryUpdate() {
        if (this.rosterEntry != null) {
            this.rosterEntry.removeAllItems();
        }
        for (RosterEntry r : this.roster.getAllEntries()) {
            String DccAddress = r.getDccAddress();
            EcosLocoAddress EcosAddress = null;
            if (DccAddress != null) {
                log.debug("DccAddress={}", (Object)DccAddress);
                try {
                    EcosAddress = this.objEcosLocoManager.getByDccAddress(Integer.parseInt(DccAddress));
                }
                catch (NullPointerException nullPointerException) {
                    log.warn("Could not connect to ECoS roster via objEcosLocoManager to loop up Loco {}", (Object)DccAddress);
                    return;
                }
            }
            if (EcosAddress != null || r.getProtocol() == LocoAddress.Protocol.MFX) continue;
            this.rosterEntry.addItem(r.titleString());
        }
    }
}

