/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos.swing.preferences;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.jmrix.ecos.EcosPreferences;
import jmri.jmrix.ecos.swing.preferences.Bundle;
import jmri.swing.PreferencesPanel;

public class PreferencesPane
extends JPanel
implements PropertyChangeListener,
PreferencesPanel {
    JPanel throttletabpanel = new JPanel();
    JPanel rostertabpanel = new JPanel();
    JPanel turnouttabpanel = new JPanel();
    JComboBox<String> _addTurnoutsEcos;
    JComboBox<String> _removeTurnoutsEcos;
    JComboBox<String> _addTurnoutsJmri;
    JComboBox<String> _removeTurnoutsJmri;
    JComboBox<String> _masterControl;
    JComboBox<String> _addLocoEcos;
    JComboBox<String> _removeLocosEcos;
    JComboBox<String> _addLocoJmri;
    JComboBox<String> _removeLocosJmri;
    JTextField _ecosAttSufText;
    JTextField _ecosDescription;
    JRadioButton _adhocLocoEcosAsk;
    JRadioButton _adhocLocoEcosLeave;
    JRadioButton _adhocLocoEcosRemove;
    JRadioButton _forceControlLocoEcosAsk;
    JRadioButton _forceControlLocoEcosNever;
    JRadioButton _forceControlLocoEcosAlways;
    JRadioButton _locoControlNormal;
    JRadioButton _locoControlForce;
    ButtonGroup _adhocLocoEcos;
    ButtonGroup _locoEcosControl;
    ButtonGroup _locoControl;
    JCheckBox _rememberAdhocLocosEcos;
    EcosPreferences ep;
    boolean updateButtonPressed = false;
    String[] masterControlTypes = new String[]{Bundle.getMessage("NOSYNC"), Bundle.getMessage("WARNING"), "JMRI", "ECoS"};
    int[] masterControlCode;
    int numTypes;
    String[] choiceTypes;
    int[] masterChoiceCode;
    int numChoiceTypes;

    public PreferencesPane(EcosPreferences epref) {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        this.masterControlCode = nArray;
        this.numTypes = 4;
        this.choiceTypes = new String[]{Bundle.getMessage("DeleteAsk"), Bundle.getMessage("ButtonNo"), Bundle.getMessage("ButtonYes")};
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArray2[2] = 2;
        this.masterChoiceCode = nArray2;
        this.numChoiceTypes = 3;
        this.ep = epref;
        this.setLayout(new BoxLayout(this, 1));
        JPanel buttonPanel = new JPanel();
        JButton updateButton = new JButton(Bundle.getMessage("ButtonUpdate"));
        updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesPane.this.updateButtonPressed();
            }
        });
        updateButton.setToolTipText(Bundle.getMessage("UpdateEcosPrefsToolTip"));
        buttonPanel.add(updateButton);
        JTabbedPane tab = new JTabbedPane();
        tab.add((Component)this.rosterTab(), Bundle.getMessage("RosterTitle"));
        tab.add((Component)this.throttleTab(), Bundle.getMessage("ThrottleTitle"));
        tab.add((Component)this.turnoutTab(), Bundle.getMessage("Turnouts"));
        this.add(tab);
        this.add(buttonPanel);
        this.ep.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this.updateButtonPressed) {
            return;
        }
        if (e.getPropertyName().equals("update")) {
            this.updateValues();
        }
    }

    void updateValues() {
        this.setChoiceType(this._removeTurnoutsEcos, this.ep.getRemoveTurnoutsFromEcos());
        this.setChoiceType(this._addTurnoutsJmri, this.ep.getAddTurnoutsToJMRI());
        this.setChoiceType(this._removeTurnoutsJmri, this.ep.getRemoveTurnoutsFromJMRI());
        this.setChoiceType(this._addLocoEcos, this.ep.getAddLocoToEcos());
        this.setChoiceType(this._removeLocosEcos, this.ep.getRemoveLocoFromEcos());
        this.setChoiceType(this._addLocoJmri, this.ep.getAddLocoToJMRI());
        this.setChoiceType(this._removeLocosJmri, this.ep.getRemoveLocoFromJMRI());
        switch (this.ep.getAdhocLocoFromEcos()) {
            case 1: {
                this._adhocLocoEcosLeave.setSelected(true);
                break;
            }
            case 2: {
                this._adhocLocoEcosRemove.setSelected(true);
                break;
            }
            default: {
                this._adhocLocoEcosAsk.setSelected(true);
            }
        }
        this._ecosAttSufText.setText(this.ep.getRosterAttributeSuffix());
        this._ecosDescription.setText(this.ep.getEcosLocoDescription());
        switch (this.ep.getForceControlFromEcos()) {
            case 1: {
                this._forceControlLocoEcosNever.setSelected(true);
                break;
            }
            case 2: {
                this._forceControlLocoEcosAlways.setSelected(true);
                break;
            }
            default: {
                this._forceControlLocoEcosAsk.setSelected(true);
            }
        }
        if (this.ep.getLocoControl()) {
            this._locoControlForce.setSelected(true);
        } else {
            this._locoControlNormal.setSelected(true);
        }
    }

    private JPanel turnoutTab() {
        this.turnouttabpanel.setLayout(new BoxLayout(this.turnouttabpanel, 1));
        JPanel _removeTurnoutsEcosPanel = new JPanel();
        JLabel _removeTurnoutsEcosLabel = new JLabel(Bundle.getMessage("RemoveTurnoutsEPref"));
        this._removeTurnoutsEcos = new JComboBox();
        _removeTurnoutsEcosPanel.add(_removeTurnoutsEcosLabel);
        this.initializeChoiceCombo(this._removeTurnoutsEcos);
        if (this.ep.getRemoveTurnoutsFromEcos() != 0) {
            this.setChoiceType(this._removeTurnoutsEcos, this.ep.getRemoveTurnoutsFromEcos());
        }
        _removeTurnoutsEcosPanel.add(this._removeTurnoutsEcos);
        this.turnouttabpanel.add(_removeTurnoutsEcosPanel);
        JPanel _addTurnoutsJMRIPanel = new JPanel();
        JLabel _addTurnoutsJMRILabel = new JLabel(Bundle.getMessage("AddTurnoutsJPref"));
        this._addTurnoutsJmri = new JComboBox();
        _addTurnoutsJMRIPanel.add(_addTurnoutsJMRILabel);
        this.initializeChoiceCombo(this._addTurnoutsJmri);
        if (this.ep.getAddTurnoutsToJMRI() != 0) {
            this.setChoiceType(this._addTurnoutsJmri, this.ep.getAddTurnoutsToJMRI());
        }
        _addTurnoutsJMRIPanel.add(this._addTurnoutsJmri);
        this.turnouttabpanel.add(_addTurnoutsJMRIPanel);
        JPanel _removeTurnoutsJMRIPanel = new JPanel();
        JLabel _removeTurnoutsJMRILabel = new JLabel(Bundle.getMessage("RemoveTurnoutsJPref"));
        this._removeTurnoutsJmri = new JComboBox();
        _removeTurnoutsJMRIPanel.add(_removeTurnoutsJMRILabel);
        this.initializeChoiceCombo(this._removeTurnoutsJmri);
        if (this.ep.getRemoveTurnoutsFromJMRI() != 0) {
            this.setChoiceType(this._removeTurnoutsJmri, this.ep.getRemoveTurnoutsFromJMRI());
        }
        _removeTurnoutsJMRIPanel.add(this._removeTurnoutsJmri);
        this.turnouttabpanel.add(_removeTurnoutsJMRIPanel);
        return this.turnouttabpanel;
    }

    private JPanel rosterTab() {
        this.rostertabpanel.setLayout(new BoxLayout(this.rostertabpanel, 1));
        JLabel _rosterLabel = new JLabel(Bundle.getMessage("RosterPrefToolTip"));
        _rosterLabel.setAlignmentX(0.5f);
        this.rostertabpanel.add(_rosterLabel);
        JPanel _locomaster = new JPanel();
        JLabel _masterLocoLabel = new JLabel(Bundle.getMessage("RosterPrefLabel"));
        _masterLocoLabel.setAlignmentX(0.5f);
        _locomaster.add(_masterLocoLabel);
        this._masterControl = new JComboBox();
        this.initializeMasterControlCombo(this._masterControl);
        if (this.ep.getLocoMaster() != 0) {
            this.setMasterControlType(this._masterControl, this.ep.getLocoMaster());
        }
        _locomaster.add(this._masterControl);
        this.rostertabpanel.add(_locomaster);
        JPanel _addlocoecospanel = new JPanel();
        JLabel _addLocosEcosLabel = new JLabel(Bundle.getMessage("AddLocosEPref"));
        this._addLocoEcos = new JComboBox();
        _addlocoecospanel.add(_addLocosEcosLabel);
        this.initializeChoiceCombo(this._addLocoEcos);
        if (this.ep.getAddLocoToEcos() != 0) {
            this.setChoiceType(this._addLocoEcos, this.ep.getAddLocoToEcos());
        }
        _addlocoecospanel.add(this._addLocoEcos);
        this.rostertabpanel.add(_addlocoecospanel);
        JPanel _removelocosecospanel = new JPanel();
        JLabel _removeLocosEcosLabel = new JLabel(Bundle.getMessage("RemoveLocosEPref"));
        this._removeLocosEcos = new JComboBox();
        _removelocosecospanel.add(_removeLocosEcosLabel);
        this.initializeChoiceCombo(this._removeLocosEcos);
        if (this.ep.getRemoveLocoFromEcos() != 0) {
            this.setChoiceType(this._removeLocosEcos, this.ep.getRemoveLocoFromEcos());
        }
        _removelocosecospanel.add(this._removeLocosEcos);
        this.rostertabpanel.add(_removelocosecospanel);
        JPanel _addlocosjmripanel = new JPanel();
        JLabel _addLocoJmriLabel = new JLabel(Bundle.getMessage("AddLocosJPref"));
        this._addLocoJmri = new JComboBox();
        _addlocosjmripanel.add(_addLocoJmriLabel);
        this.initializeChoiceCombo(this._addLocoJmri);
        if (this.ep.getAddLocoToJMRI() != 0) {
            this.setChoiceType(this._addLocoJmri, this.ep.getAddLocoToJMRI());
        }
        _addlocosjmripanel.add(this._addLocoJmri);
        this.rostertabpanel.add(_addlocosjmripanel);
        JPanel _removelocosjmripanel = new JPanel();
        JLabel _removeLocosJmriLabel = new JLabel(Bundle.getMessage("RemoveLocosJPref"));
        this._removeLocosJmri = new JComboBox();
        _removelocosjmripanel.add(_removeLocosJmriLabel);
        this.initializeChoiceCombo(this._removeLocosJmri);
        if (this.ep.getRemoveLocoFromJMRI() != 0) {
            this.setChoiceType(this._removeLocosJmri, this.ep.getRemoveLocoFromJMRI());
        }
        _removelocosjmripanel.add(this._removeLocosJmri);
        this.rostertabpanel.add(_removelocosjmripanel);
        JPanel ecosAttributeSuffix = new JPanel();
        JLabel _ecosAttSufLabel = new JLabel(Bundle.getMessage("EcosRosterSuffixLabel"));
        ecosAttributeSuffix.add(_ecosAttSufLabel);
        this._ecosAttSufText = new JTextField(10);
        this._ecosAttSufText.setToolTipText(Bundle.getMessage("EcosRosterSuffixToolTip"));
        this._ecosAttSufText.setText(this.ep.getRosterAttributeSuffix());
        ecosAttributeSuffix.add(this._ecosAttSufText);
        this.rostertabpanel.add(ecosAttributeSuffix);
        JPanel ecosDescriptionPanel = new JPanel();
        JLabel _ecosDesLabel = new JLabel(Bundle.getMessage("EcosLocoDescrLabel"));
        ecosDescriptionPanel.add(_ecosDesLabel);
        this._ecosDescription = new JTextField(20);
        this._ecosDescription.setText(this.ep.getEcosLocoDescription());
        this._ecosDescription.setToolTipText(Bundle.getMessage("EcosLocoDescrToolTip"));
        ecosDescriptionPanel.add(this._ecosDescription);
        this.rostertabpanel.add(ecosDescriptionPanel);
        JLabel _descriptionformat = new JLabel(Bundle.getMessage("EcosTagsHelp1"));
        this.rostertabpanel.add(_descriptionformat);
        JLabel _descriptionformat2 = new JLabel(Bundle.getMessage("EcosTagsHelp2"));
        this.rostertabpanel.add(_descriptionformat2);
        return this.rostertabpanel;
    }

    private JPanel throttleTab() {
        this.throttletabpanel.setLayout(new BoxLayout(this.throttletabpanel, 1));
        JLabel _throttleLabel = new JLabel(Bundle.getMessage("EcosTempLocoHelp"));
        _throttleLabel.setAlignmentX(0.5f);
        this.throttletabpanel.add(_throttleLabel);
        _throttleLabel.setAlignmentX(0.5f);
        this._adhocLocoEcosAsk = new JRadioButton(Bundle.getMessage("ButtonAlwaysAsk"));
        this._adhocLocoEcosLeave = new JRadioButton(Bundle.getMessage("ButtonAlwaysLeave"));
        this._adhocLocoEcosRemove = new JRadioButton(Bundle.getMessage("ButtonAlwaysRemove"));
        switch (this.ep.getAdhocLocoFromEcos()) {
            case 1: {
                this._adhocLocoEcosLeave.setSelected(true);
                break;
            }
            case 2: {
                this._adhocLocoEcosRemove.setSelected(true);
                break;
            }
            default: {
                this._adhocLocoEcosAsk.setSelected(true);
            }
        }
        this._adhocLocoEcos = new ButtonGroup();
        this._adhocLocoEcos.add(this._adhocLocoEcosAsk);
        this._adhocLocoEcos.add(this._adhocLocoEcosLeave);
        this._adhocLocoEcos.add(this._adhocLocoEcosRemove);
        JPanel adhocEcosGroup = new JPanel();
        adhocEcosGroup.setLayout(new BoxLayout(adhocEcosGroup, 1));
        adhocEcosGroup.add(this._adhocLocoEcosAsk);
        adhocEcosGroup.add(this._adhocLocoEcosLeave);
        adhocEcosGroup.add(this._adhocLocoEcosRemove);
        adhocEcosGroup.setAlignmentX(0.5f);
        this.throttletabpanel.add(adhocEcosGroup);
        this.throttletabpanel.add(new JSeparator(0));
        _throttleLabel = new JLabel(Bundle.getMessage("EcosControlLocoHelp"));
        _throttleLabel.setAlignmentX(0.5f);
        this.throttletabpanel.add(_throttleLabel);
        this._forceControlLocoEcosAsk = new JRadioButton(Bundle.getMessage("ButtonControlAlwaysAsk"));
        this._forceControlLocoEcosNever = new JRadioButton(Bundle.getMessage("ButtonControlNeverForce"));
        this._forceControlLocoEcosAlways = new JRadioButton(Bundle.getMessage("ButtonControlAlwaysForce"));
        switch (this.ep.getForceControlFromEcos()) {
            case 1: {
                this._forceControlLocoEcosNever.setSelected(true);
                break;
            }
            case 2: {
                this._forceControlLocoEcosAlways.setSelected(true);
                break;
            }
            default: {
                this._forceControlLocoEcosAsk.setSelected(true);
            }
        }
        this._locoEcosControl = new ButtonGroup();
        this._locoEcosControl.add(this._forceControlLocoEcosAsk);
        this._locoEcosControl.add(this._forceControlLocoEcosNever);
        this._locoEcosControl.add(this._forceControlLocoEcosAlways);
        JPanel locoEcosControlGroup = new JPanel();
        locoEcosControlGroup.setLayout(new BoxLayout(locoEcosControlGroup, 1));
        locoEcosControlGroup.add(this._forceControlLocoEcosAsk);
        locoEcosControlGroup.add(this._forceControlLocoEcosNever);
        locoEcosControlGroup.add(this._forceControlLocoEcosAlways);
        locoEcosControlGroup.setAlignmentX(0.5f);
        this.throttletabpanel.add(locoEcosControlGroup);
        this.throttletabpanel.add(new JSeparator(0));
        this._locoControl = new ButtonGroup();
        this._locoControlNormal = new JRadioButton(Bundle.getMessage("ButtonControlAlwaysGain"));
        this._locoControlForce = new JRadioButton(Bundle.getMessage("ButtonControlAlwaysForce"));
        this._locoControl.add(this._locoControlNormal);
        this._locoControl.add(this._locoControlForce);
        if (this.ep.getLocoControl()) {
            this._locoControlForce.setSelected(true);
        } else {
            this._locoControlNormal.setSelected(true);
        }
        JLabel _locoControlLabel = new JLabel(Bundle.getMessage("EcosTakeControlHelp"));
        JPanel locoControlGroup = new JPanel();
        locoControlGroup.add(_locoControlLabel);
        locoControlGroup.setLayout(new BoxLayout(locoControlGroup, 1));
        locoControlGroup.add(this._locoControlNormal);
        locoControlGroup.add(this._locoControlForce);
        locoControlGroup.setAlignmentX(0.5f);
        this.throttletabpanel.add(locoControlGroup);
        return this.throttletabpanel;
    }

    private void updateButtonPressed() {
        this.updateButtonPressed = true;
        this.ep.setRemoveLocoFromJMRI(this.getChoiceType(this._removeLocosJmri));
        this.ep.setAddLocoToJMRI(this.getChoiceType(this._addLocoJmri));
        this.ep.setRemoveLocoFromEcos(this.getChoiceType(this._removeLocosEcos));
        this.ep.setAddLocoToEcos(this.getChoiceType(this._addLocoEcos));
        this.ep.setRemoveTurnoutsFromJMRI(this.getChoiceType(this._removeTurnoutsJmri));
        this.ep.setAddTurnoutsToJMRI(this.getChoiceType(this._addTurnoutsJmri));
        this.ep.setRemoveTurnoutsFromEcos(this.getChoiceType(this._removeTurnoutsEcos));
        this.ep.setLocoMaster(this.getMasterControlType(this._masterControl));
        this.ep.setEcosLocoDescription(this._ecosDescription.getText());
        this.ep.setRosterAttribute(this._ecosAttSufText.getText());
        if (this._adhocLocoEcosAsk.isSelected()) {
            this.ep.setAdhocLocoFromEcos(0);
        } else if (this._adhocLocoEcosLeave.isSelected()) {
            this.ep.setAdhocLocoFromEcos(1);
        } else if (this._adhocLocoEcosRemove.isSelected()) {
            this.ep.setAdhocLocoFromEcos(2);
        } else {
            this.ep.setAdhocLocoFromEcos(0);
        }
        if (this._locoControlForce.isSelected()) {
            this.ep.setLocoControl(true);
        } else {
            this.ep.setLocoControl(false);
        }
        ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
        if (cm != null) {
            cm.storePrefs();
        }
        this.updateButtonPressed = false;
    }

    private void initializeMasterControlCombo(JComboBox<String> masterCombo) {
        masterCombo.removeAllItems();
        int i = 0;
        while (i < this.numTypes) {
            masterCombo.addItem(this.masterControlTypes[i]);
            ++i;
        }
    }

    private void setMasterControlType(JComboBox<String> masterBox, int master) {
        int i = 0;
        while (i < this.numTypes) {
            if (master == this.masterControlCode[i]) {
                masterBox.setSelectedIndex(i);
                return;
            }
            ++i;
        }
    }

    private int getMasterControlType(JComboBox<String> masterBox) {
        return this.masterControlCode[masterBox.getSelectedIndex()];
    }

    private void initializeChoiceCombo(JComboBox<String> masterCombo) {
        masterCombo.removeAllItems();
        int i = 0;
        while (i < this.numChoiceTypes) {
            masterCombo.addItem(this.choiceTypes[i]);
            ++i;
        }
    }

    private void setChoiceType(JComboBox<String> masterBox, int master) {
        int i = 0;
        while (i < this.numChoiceTypes) {
            if (master == this.masterChoiceCode[i]) {
                masterBox.setSelectedIndex(i);
                return;
            }
            ++i;
        }
    }

    private int getChoiceType(JComboBox<String> masterBox) {
        return this.masterChoiceCode[masterBox.getSelectedIndex()];
    }

    @Override
    public String getPreferencesItem() {
        return "ECoS";
    }

    @Override
    public String getPreferencesItemText() {
        return Bundle.getMessage("MenuItemECoSPrefs");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return this.ep.getAdaptermemo().getUserName();
    }

    @Override
    public String getLabelKey() {
        return null;
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return false;
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
        this.updateButtonPressed();
    }

    @Override
    public boolean isDirty() {
        return this.ep.getChangeMade();
    }

    @Override
    public boolean isRestartRequired() {
        return false;
    }

    @Override
    public boolean isPreferencesValid() {
        return true;
    }
}

