/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos.swing;

import javax.swing.JMenu;
import javax.swing.JSeparator;
import jmri.InstanceManager;
import jmri.jmrit.beantable.ListedTableAction;
import jmri.jmrit.beantable.ListedTableFrame;
import jmri.jmrix.ecos.EcosSystemConnectionMemo;
import jmri.jmrix.ecos.swing.Bundle;
import jmri.jmrix.ecos.swing.EcosNamedPaneAction;
import jmri.jmrix.ecos.utilities.AddRosterEntryToEcos;
import jmri.util.prefs.JmriPreferencesActionFactory;
import jmri.util.swing.WindowInterface;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcosMenu
extends JMenu {
    Item[] panelItems = new Item[]{new Item("MenuItemEcosMonitor", "jmri.jmrix.ecos.swing.monitor.EcosMonPane"), new Item("MenuItemSendPacket", "jmri.jmrix.ecos.swing.packetgen.PacketGenPanel"), new Item("MenuItemInfo", "jmri.jmrix.ecos.swing.statusframe.StatusPanel")};
    private static final Logger log = LoggerFactory.getLogger(EcosMenu.class);

    public EcosMenu(EcosSystemConnectionMemo memo) {
        String title = memo != null ? memo.getUserName() : Bundle.getMessage("MenuEcos");
        this.setText(title);
        JmriJFrameInterface wi = new JmriJFrameInterface();
        Item[] itemArray = this.panelItems;
        int n = this.panelItems.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            if (item == null) {
                this.add(new JSeparator());
            } else {
                this.add(new EcosNamedPaneAction(Bundle.getMessage(item.name), (WindowInterface)wi, item.load, memo));
            }
            ++n2;
        }
        if (InstanceManager.getNullableDefault(ListedTableFrame.class) == null) {
            try {
                new ListedTableFrame();
            }
            catch (NullPointerException nullPointerException) {
                log.error("Unable to register ECoS table");
            }
        }
        this.add(new ListedTableAction(Bundle.getMessage("MenuItemDatabase"), "jmri.jmrix.ecos.swing.locodatabase.EcosLocoTableTabAction"));
        this.add(InstanceManager.getDefault(JmriPreferencesActionFactory.class).getCategorizedAction(Bundle.getMessage("MenuItemECoSPrefs"), "ECoS", title));
        if (memo != null) {
            this.add(new AddRosterEntryToEcos(Bundle.getMessage("MenuItemAddLocoToEcos"), memo));
        }
    }

    static class Item {
        String name;
        String load;

        Item(String name, String load) {
            this.name = name;
            this.load = load;
        }
    }
}

