/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos.networkdriver.configurexml;

import java.util.List;
import jmri.jmrix.configurexml.AbstractNetworkConnectionConfigXml;
import jmri.jmrix.ecos.EcosPreferences;
import jmri.jmrix.ecos.EcosSystemConnectionMemo;
import jmri.jmrix.ecos.networkdriver.ConnectionConfig;
import jmri.jmrix.ecos.networkdriver.NetworkDriverAdapter;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionConfigXml
extends AbstractNetworkConnectionConfigXml {
    private static final Logger log = LoggerFactory.getLogger(ConnectionConfigXml.class);

    @Override
    protected void getInstance() {
        this.adapter = new NetworkDriverAdapter();
    }

    @Override
    protected void getInstance(Object object) {
        this.adapter = ((ConnectionConfig)object).getAdapter();
    }

    @Override
    protected void extendElement(Element e) {
        Element ecosPrefElem = new Element("commandStationPreferences");
        EcosPreferences p = ((EcosSystemConnectionMemo)this.adapter.getSystemConnectionMemo()).getPreferenceManager();
        if (p == null) {
            log.warn("Null EcosPrefManager");
            return;
        }
        if (p.getAddTurnoutsToEcos() == 1) {
            ecosPrefElem.setAttribute("addTurnoutToCS", "no");
        } else if (p.getAddTurnoutsToEcos() == 2) {
            ecosPrefElem.setAttribute("addTurnoutToCS", "yes");
        }
        if (p.getRemoveTurnoutsFromEcos() == 1) {
            ecosPrefElem.setAttribute("removeTurnoutFromCS", "no");
        } else if (p.getRemoveTurnoutsFromEcos() == 2) {
            ecosPrefElem.setAttribute("removeTurnoutFromCS", "yes");
        }
        if (p.getAddTurnoutsToJMRI() == 1) {
            ecosPrefElem.setAttribute("addTurnoutToJMRI", "no");
        } else if (p.getAddTurnoutsToJMRI() == 2) {
            ecosPrefElem.setAttribute("addTurnoutToJMRI", "yes");
        }
        if (p.getRemoveTurnoutsFromJMRI() == 1) {
            ecosPrefElem.setAttribute("removeTurnoutFromJMRI", "no");
        } else if (p.getRemoveTurnoutsFromJMRI() == 2) {
            ecosPrefElem.setAttribute("removeTurnoutFromJMRI", "yes");
        }
        if (p.getLocoMaster() > 0) {
            ecosPrefElem.setAttribute("locoMaster", p.getLocoMasterAsString());
        }
        if (p.getAddLocoToEcos() == 1) {
            ecosPrefElem.setAttribute("addLocoToCS", "no");
        }
        if (p.getAddLocoToEcos() == 2) {
            ecosPrefElem.setAttribute("addLocoToCS", "yes");
        }
        if (p.getRemoveLocoFromEcos() == 1) {
            ecosPrefElem.setAttribute("removeLocoFromCS", "no");
        } else if (p.getRemoveLocoFromEcos() == 2) {
            ecosPrefElem.setAttribute("removeLocoFromCS", "yes");
        }
        if (p.getAddLocoToJMRI() == 1) {
            ecosPrefElem.setAttribute("addLocoToJMRI", "no");
        } else if (p.getAddLocoToJMRI() == 2) {
            ecosPrefElem.setAttribute("addLocoToJMRI", "yes");
        }
        if (p.getRemoveLocoFromJMRI() == 1) {
            ecosPrefElem.setAttribute("removeLocoFromJMRI", "no");
        } else if (p.getRemoveLocoFromJMRI() == 1) {
            ecosPrefElem.setAttribute("removeLocoFromJMRI", "yes");
        }
        if (p.getAdhocLocoFromEcos() == 1) {
            ecosPrefElem.setAttribute("removeAdhocLocoFromCS", "no");
        } else if (p.getAdhocLocoFromEcos() == 2) {
            ecosPrefElem.setAttribute("removeAdhocLocoFromCS", "yes");
        }
        if (p.getForceControlFromEcos() == 1) {
            ecosPrefElem.setAttribute("forceControlFromCS", "no");
        } else if (p.getForceControlFromEcos() == 2) {
            ecosPrefElem.setAttribute("forceControlCS", "yes");
        }
        if (p.getEcosLocoDescription() != null && !p.getEcosLocoDescription().equals("")) {
            ecosPrefElem.setAttribute("defaultCSLocoDescription", p.getEcosLocoDescription());
        }
        if (p.getLocoControl()) {
            ecosPrefElem.setAttribute("locoControl", "force");
        }
        ecosPrefElem.setAttribute("ecosRosterAttribute", p.getRosterAttribute());
        e.addContent((Content)ecosPrefElem);
    }

    @Override
    protected void unpackElement(Element shared, Element perNode) {
        List ecosPref = shared.getChildren("commandStationPreferences");
        EcosPreferences p = ((EcosSystemConnectionMemo)this.adapter.getSystemConnectionMemo()).getPreferenceManager();
        if (p == null) {
            log.warn("Null EcosPrefManager");
            return;
        }
        for (Element element : ecosPref) {
            String yesno;
            if (element.getAttribute("addTurnoutToCS") != null && (yesno = element.getAttribute("addTurnoutToCS").getValue()) != null && !yesno.equals("")) {
                if (yesno.equals("yes")) {
                    p.setAddTurnoutsToEcos(2);
                } else if (yesno.equals("no")) {
                    p.setAddTurnoutsToEcos(1);
                }
            }
            if (element.getAttribute("removeTurnoutFromCS") != null && (yesno = element.getAttribute("removeTurnoutFromCS").getValue()) != null && !yesno.equals("")) {
                if (yesno.equals("yes")) {
                    p.setRemoveTurnoutsFromEcos(2);
                } else if (yesno.equals("no")) {
                    p.setRemoveTurnoutsFromEcos(1);
                }
            }
            if (element.getAttribute("addTurnoutToJMRI") != null && (yesno = element.getAttribute("addTurnoutToJMRI").getValue()) != null && !yesno.equals("")) {
                if (yesno.equals("yes")) {
                    p.setAddTurnoutsToJMRI(2);
                } else if (yesno.equals("no")) {
                    p.setAddTurnoutsToJMRI(1);
                }
            }
            if (element.getAttribute("removeTurnoutFromJMRI") != null && (yesno = element.getAttribute("removeTurnoutFromJMRI").getValue()) != null && !yesno.equals("")) {
                if (yesno.equals("yes")) {
                    p.setRemoveTurnoutsFromJMRI(2);
                } else if (yesno.equals("no")) {
                    p.setRemoveTurnoutsFromJMRI(1);
                }
            }
            if (element.getAttribute("addLocoToCS") != null && (yesno = element.getAttribute("addLocoToCS").getValue()) != null && !yesno.equals("")) {
                if (yesno.equals("yes")) {
                    p.setAddLocoToEcos(2);
                } else if (yesno.equals("no")) {
                    p.setAddLocoToEcos(1);
                }
            }
            if (element.getAttribute("removeLocoFromCS") != null && (yesno = element.getAttribute("removeLocoFromCS").getValue()) != null && !yesno.equals("")) {
                if (yesno.equals("yes")) {
                    p.setRemoveLocoFromEcos(2);
                } else if (yesno.equals("no")) {
                    p.setRemoveLocoFromEcos(1);
                }
            }
            if (element.getAttribute("addLocoToJMRI") != null && (yesno = element.getAttribute("addLocoToJMRI").getValue()) != null && !yesno.equals("")) {
                if (yesno.equals("yes")) {
                    p.setAddLocoToJMRI(2);
                } else if (yesno.equals("no")) {
                    p.setAddLocoToJMRI(1);
                }
            }
            if (element.getAttribute("removeLocoFromJMRI") != null && (yesno = element.getAttribute("removeLocoFromJMRI").getValue()) != null && !yesno.equals("")) {
                if (yesno.equals("yes")) {
                    p.setRemoveLocoFromJMRI(2);
                } else if (yesno.equals("no")) {
                    p.setRemoveLocoFromJMRI(1);
                }
            }
            if (element.getAttribute("removeLocoFromJMRI") != null && (yesno = element.getAttribute("removeLocoFromJMRI").getValue()) != null && !yesno.equals("")) {
                if (yesno.equals("yes")) {
                    p.setRemoveLocoFromJMRI(2);
                } else if (yesno.equals("no")) {
                    p.setRemoveLocoFromJMRI(1);
                }
            }
            if (element.getAttribute("locoMaster") != null) {
                p.setLocoMaster(element.getAttribute("locoMaster").getValue());
            }
            if (element.getAttribute("removeAdhocLocoFromCS") != null && (yesno = element.getAttribute("removeAdhocLocoFromCS").getValue()) != null && !yesno.equals("")) {
                if (yesno.equals("yes")) {
                    p.setAdhocLocoFromEcos(2);
                } else if (yesno.equals("no")) {
                    p.setAdhocLocoFromEcos(1);
                }
            }
            if (element.getAttribute("defaultCSLocoDescription") != null) {
                p.setEcosLocoDescription(element.getAttribute("defaultCSLocoDescription").getValue());
            }
            if (element.getAttribute("ecosRosterAttribute") != null) {
                p.setRosterAttribute(element.getAttribute("ecosRosterAttribute").getValue());
            }
            if (element.getAttribute("locoControl") != null) {
                p.setLocoControl(true);
            }
            p.resetChangeMade();
        }
        p.setPreferencesLoaded();
    }

    @Override
    protected void register() {
        this.register(new ConnectionConfig(this.adapter));
    }
}

