/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.Turnout;
import jmri.TurnoutOperationManager;
import jmri.jmrix.ecos.Bundle;
import jmri.jmrix.ecos.EcosListener;
import jmri.jmrix.ecos.EcosMessage;
import jmri.jmrix.ecos.EcosPreferences;
import jmri.jmrix.ecos.EcosReply;
import jmri.jmrix.ecos.EcosSystemConnectionMemo;
import jmri.jmrix.ecos.EcosTrafficController;
import jmri.jmrix.ecos.EcosTurnout;
import jmri.jmrix.ecos.utilities.GetEcosObjectNumber;
import jmri.jmrix.ecos.utilities.RemoveObjectFromEcos;
import jmri.managers.AbstractTurnoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcosTurnoutManager
extends AbstractTurnoutManager
implements EcosListener {
    EcosTrafficController tc;
    private Hashtable<Integer, EcosTurnout> _tecos = new Hashtable();
    protected boolean addingTurnouts = false;
    private boolean noWarnDelete = false;
    private static final Logger log = LoggerFactory.getLogger(EcosTurnoutManager.class);

    public EcosTurnoutManager(EcosSystemConnectionMemo memo) {
        super(memo);
        this.tc = this.getMemo().getTrafficController();
        this.tc.addEcosListener(this);
        EcosMessage m = new EcosMessage("request(11, view)");
        this.tc.sendEcosMessage(m, this);
        m = new EcosMessage("queryObjects(11, addrext)");
        this.tc.sendEcosMessage(m, this);
        this.addPropertyChangeListener(this);
    }

    @Override
    @Nonnull
    public EcosSystemConnectionMemo getMemo() {
        return (EcosSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int addr;
        try {
            addr = Integer.parseInt(systemName.substring(this.getSystemNamePrefix().length()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("failed to convert systemName '" + systemName + "' to an Ecos turnout address");
        }
        EcosTurnout t = new EcosTurnout(addr, this.getSystemPrefix(), this.tc, this);
        t.setUserName(userName);
        t.setFeedbackMode("MONITORING");
        return t;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    public void reply(EcosReply m) {
        log.debug("reply {}", (Object)m);
        if (m.getResultCode() == 0) {
            int ecosObjectId = m.getEcosObjectId();
            if (ecosObjectId != 11 && (ecosObjectId < 20000 || ecosObjectId > 30000)) {
                log.debug("message received that is not within the valid turnout object range");
                return;
            }
            List<String> headerDetails = m.getReplyHeaderDetails();
            String[] msgContents = m.getContents();
            if (m.isUnsolicited()) {
                if (ecosObjectId == 11) {
                    if (msgContents[0].contains("msg[LIST_CHANGED]")) {
                        log.debug("We have received notification of a change in the Turnout list");
                        EcosMessage mout = new EcosMessage("queryObjects(11)");
                        this.tc.sendEcosMessage(mout, this);
                    }
                } else {
                    log.debug("Forwarding on State change for {}", (Object)ecosObjectId);
                    EcosTurnout et = this._tecos.get(ecosObjectId);
                    if (et != null) {
                        et.reply(m);
                        if (et.getExtended() != 0) {
                            log.debug("This is also an extended turnout so forwarding on change to {}", (Object)et.getSlaveAddress());
                            EcosTurnout etx = (EcosTurnout)this.provideTurnout(et.getSlaveAddress());
                            etx.reply(m);
                        }
                    }
                }
            } else {
                String replyType = m.getReplyType();
                if (replyType.equals("queryObjects")) {
                    if (ecosObjectId == 11 && headerDetails.size() == 0) {
                        log.debug("No sub details");
                        this.checkTurnoutList(msgContents);
                    } else if (headerDetails.contains("addr")) {
                        String[] stringArray = m.getContents();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String item = stringArray[n2];
                            log.debug("header {}", (Object)item);
                            if (item.contains("addr")) {
                                EcosTurnout et;
                                int object = GetEcosObjectNumber.getEcosObjectNumber(item, null, " ");
                                if (20000 <= object && object < 30000) {
                                    Turnout t;
                                    int addr = GetEcosObjectNumber.getEcosObjectNumber(item, "[", "]");
                                    log.debug("Found turnout object {} addr {}", (Object)object, (Object)addr);
                                    if (addr > 0 && (t = this.getTurnout(String.valueOf(this.getSystemNamePrefix()) + addr)) == null) {
                                        et = (EcosTurnout)this.provideTurnout(String.valueOf(this.getSystemNamePrefix()) + addr);
                                        et.setObjectNumber(object);
                                        this._tecos.put(object, et);
                                    }
                                } else if (30000 <= object && object < 40000) {
                                    log.debug("Found route object {}", (Object)object);
                                    Turnout t = this.getTurnout(String.valueOf(this.getSystemNamePrefix()) + object);
                                    if (t == null) {
                                        et = (EcosTurnout)this.provideTurnout(String.valueOf(this.getSystemNamePrefix()) + object);
                                        et.setObjectNumber(object);
                                        this._tecos.put(object, et);
                                    }
                                }
                                if (20000 <= object && object < 40000) {
                                    EcosMessage em = new EcosMessage("request(" + object + ",view)");
                                    this.tc.sendEcosMessage(em, this);
                                    em = new EcosMessage("get(" + object + ",state)");
                                    this.tc.sendEcosMessage(em, this);
                                }
                            }
                            ++n2;
                        }
                    } else if (headerDetails.contains("addrext")) {
                        String[] stringArray = m.getContents();
                        int n = stringArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            String item = stringArray[n3];
                            if (item.contains("addrext")) {
                                this.turnoutAddressDetails(item);
                            }
                            ++n3;
                        }
                    }
                } else if (replyType.equals("get")) {
                    EcosTurnout et = (EcosTurnout)this.getByEcosObject(ecosObjectId);
                    if (headerDetails.contains("state")) {
                        et.reply(m);
                        if (et.getExtended() != 0) {
                            EcosTurnout etx = (EcosTurnout)this.provideTurnout(et.getSlaveAddress());
                            etx.reply(m);
                        }
                    } else if (headerDetails.contains("symbol")) {
                        int symbol = GetEcosObjectNumber.getEcosObjectNumber(msgContents[0], "[", "]");
                        et.setExtended(symbol);
                        et.setTurnoutOperation(InstanceManager.getDefault(TurnoutOperationManager.class).getOperation("NoFeedback"));
                        if (symbol == 2 || symbol == 4) {
                            EcosTurnout etx = (EcosTurnout)this.provideTurnout(et.getSlaveAddress());
                            etx.setExtended(symbol);
                            etx.setTurnoutOperation(InstanceManager.getDefault(TurnoutOperationManager.class).getOperation("NoFeedback"));
                            switch (symbol) {
                                case 2: {
                                    et.setComment("Three Way Point with " + et.getSlaveAddress());
                                    break;
                                }
                                case 4: {
                                    et.setComment("Double Slip with " + et.getSlaveAddress());
                                    break;
                                }
                            }
                        }
                        EcosMessage em = new EcosMessage("get(" + ecosObjectId + ",state)");
                        this.tc.sendEcosMessage(em, this);
                    } else if (headerDetails.contains("addrext")) {
                        this.turnoutAddressDetails(msgContents[0]);
                    } else {
                        String name = null;
                        String[] stringArray = msgContents;
                        int n = msgContents.length;
                        int n4 = 0;
                        while (n4 < n) {
                            String li = stringArray[n4];
                            if (li.contains("name")) {
                                name = name != null ? String.valueOf(name) + EcosReply.getContentDetail(li) : EcosReply.getContentDetail(li);
                            }
                            ++n4;
                        }
                        if (name != null) {
                            et.setUserName(name);
                        }
                    }
                } else if (ecosObjectId >= 20000) {
                    log.debug("Reply for specific turnout");
                    EcosTurnout et = this._tecos.get(ecosObjectId);
                    if (et != null) {
                        et.reply(m);
                        if (et.getExtended() != 0) {
                            log.debug("This is also an extended turnout so forwarding on change to {}", (Object)et.getSlaveAddress());
                            EcosTurnout etx = (EcosTurnout)this.provideTurnout(et.getSlaveAddress());
                            etx.reply(m);
                        }
                    }
                }
            }
        } else {
            log.debug("Message received from Ecos is in error");
        }
    }

    private void turnoutAddressDetails(String lines) {
        this.addingTurnouts = true;
        int object = GetEcosObjectNumber.getEcosObjectNumber(lines, null, " ");
        if (20000 <= object && object < 30000) {
            int start = lines.indexOf(91) + 1;
            int end = lines.indexOf(93);
            String turnoutadd = this.stripChar(lines.substring(start, end));
            String[] straddr = turnoutadd.split(",");
            log.debug("Number of Address for this device is {}", (Object)straddr.length);
            if (straddr.length <= 2) {
                Turnout t;
                int addr;
                if (straddr.length == 2 && !straddr[0].equals(straddr[1])) {
                    log.debug("Addresses are not the same, we shall use the first address listed.");
                }
                if ((addr = Integer.parseInt(straddr[0])) > 0 && (t = this.getTurnout(String.valueOf(this.getSystemNamePrefix()) + addr)) == null) {
                    EcosTurnout et = (EcosTurnout)this.provideTurnout(String.valueOf(this.getSystemNamePrefix()) + addr);
                    et.setObjectNumber(object);
                    this._tecos.put(object, et);
                    EcosMessage em = new EcosMessage("request(" + object + ",view)");
                    this.tc.sendEcosMessage(em, this);
                    em = new EcosMessage("get(" + object + ",state)");
                    this.tc.sendEcosMessage(em, this);
                    em = new EcosMessage("get(" + object + ", name1, name2, name3)");
                    this.tc.sendEcosMessage(em, this);
                }
            } else if (straddr.length == 4) {
                EcosTurnout et;
                Turnout t;
                log.debug("We have a two address object.");
                if (!straddr[0].equals(straddr[1])) {
                    log.debug("First Pair of Addresses are not the same, we shall use the first address");
                }
                if (!straddr[2].equals(straddr[3])) {
                    log.debug("Second Pair of Addresses are not the same, we shall use the first address");
                }
                int addr = Integer.parseInt(straddr[0]);
                int addr2 = Integer.parseInt(straddr[2]);
                if (addr > 0 && (t = this.getTurnout(String.valueOf(this.getSystemNamePrefix()) + addr)) == null) {
                    et = (EcosTurnout)this.provideTurnout(String.valueOf(this.getSystemNamePrefix()) + addr);
                    et.setObjectNumber(object);
                    et.setSlaveAddress(addr2);
                    this._tecos.put(object, et);
                    EcosMessage em = new EcosMessage("get(" + object + ",symbol)");
                    this.tc.sendEcosMessage(em, this);
                    em = new EcosMessage("request(" + object + ",view)");
                    this.tc.sendEcosMessage(em, this);
                    em = new EcosMessage("get(" + object + ", name1, name2, name3)");
                    this.tc.sendEcosMessage(em, this);
                }
                if (addr2 > 0 && (t = this.getTurnout(String.valueOf(this.getSystemNamePrefix()) + addr2)) == null) {
                    et = (EcosTurnout)this.provideTurnout(String.valueOf(this.getSystemNamePrefix()) + addr2);
                    et.setMasterObjectNumber(false);
                    et.setObjectNumber(object);
                    et.setComment("Extended address linked with turnout " + this.getSystemPrefix() + "T" + straddr[0]);
                }
            }
        } else if (30000 <= object && object < 40000) {
            log.debug("Found route object {}", (Object)object);
            Turnout t = this.getTurnout(String.valueOf(this.getSystemNamePrefix()) + object);
            if (t == null) {
                EcosTurnout et = (EcosTurnout)this.provideTurnout(String.valueOf(this.getSystemNamePrefix()) + object);
                et.setObjectNumber(object);
                this._tecos.put(object, et);
                EcosMessage em = new EcosMessage("get(" + object + ",state)");
                this.tc.sendEcosMessage(em, this);
                em = new EcosMessage("get(" + object + ", name1, name2, name3)");
                this.tc.sendEcosMessage(em, this);
            }
        }
        this.addingTurnouts = false;
    }

    void checkTurnoutList(String[] ecoslines) {
        final EcosPreferences p = this.getMemo().getPreferenceManager();
        String[] jmrilist = this.getEcosObjectArray();
        boolean nomatch = true;
        int intTurnout = 0;
        String strECOSTurnout = null;
        int i = 0;
        while (i < jmrilist.length) {
            nomatch = true;
            String strJMRITurnout = jmrilist[i];
            intTurnout = Integer.parseInt(strJMRITurnout);
            String[] stringArray = ecoslines;
            int n = ecoslines.length;
            int n2 = 0;
            while (n2 < n) {
                String li = stringArray[n2];
                strECOSTurnout = li.replaceAll("[\\n\\r]", "");
                if (strECOSTurnout.equals(strJMRITurnout)) {
                    nomatch = false;
                    break;
                }
                ++n2;
            }
            if (nomatch) {
                final EcosTurnout et = (EcosTurnout)this.getByEcosObject(intTurnout);
                this._tecos.remove(intTurnout);
                if (p.getRemoveTurnoutsFromJMRI() == 2) {
                    this._tecos.remove(et.getObject());
                    this.deregister(et);
                } else if (p.getRemoveTurnoutsFromJMRI() == 0) {
                    final JDialog dialog = new JDialog();
                    dialog.setTitle(Bundle.getMessage("DeleteTurnoutTitle"));
                    dialog.setLocationRelativeTo(null);
                    dialog.setDefaultCloseOperation(2);
                    JPanel container = new JPanel();
                    container.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                    container.setLayout(new BoxLayout(container, 1));
                    JLabel question = new JLabel(Bundle.getMessage("RemoveTurnoutLine1", et.getDisplayName()));
                    question.setAlignmentX(0.5f);
                    container.add(question);
                    question = new JLabel(Bundle.getMessage("RemoveTurnoutLine2"));
                    question.setAlignmentX(0.5f);
                    container.add(question);
                    final JCheckBox remember = new JCheckBox(Bundle.getMessage("MessageRememberSetting"));
                    remember.setFont(remember.getFont().deriveFont(10.0f));
                    remember.setAlignmentX(0.5f);
                    JButton yesButton = new JButton(Bundle.getMessage("ButtonYes"));
                    JButton noButton = new JButton(Bundle.getMessage("ButtonNo"));
                    JPanel button = new JPanel();
                    button.setAlignmentX(0.5f);
                    button.add(yesButton);
                    button.add(noButton);
                    container.add(button);
                    noButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (remember.isSelected()) {
                                p.setRemoveTurnoutsFromJMRI(1);
                            }
                            dialog.dispose();
                        }
                    });
                    yesButton.addActionListener(new ActionListener(){
                        final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrit.beantable.BeanTableBundle");

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (remember.isSelected()) {
                                p.setRemoveTurnoutsFromJMRI(2);
                            }
                            int count = et.getNumPropertyChangeListeners() - 1;
                            if (log.isDebugEnabled()) {
                                log.debug("Delete with {}", (Object)count);
                            }
                            if (!EcosTurnoutManager.this.noWarnDelete && count > 0) {
                                String msg = MessageFormat.format(String.valueOf(this.rb.getString("DeletePrompt")) + "\n" + this.rb.getString("ReminderInUse"), et.getSystemName(), "" + count);
                                int val = JOptionPane.showOptionDialog(null, msg, Bundle.getMessage("WarningTitle"), 1, 3, null, new Object[]{Bundle.getMessage("ButtonYes"), this.rb.getString("ButtonYesPlus"), Bundle.getMessage("ButtonNo")}, Bundle.getMessage("ButtonNo"));
                                if (val == 2) {
                                    EcosTurnoutManager.this._tecos.remove(et.getObject());
                                    EcosTurnoutManager.this.deregister(et);
                                    dialog.dispose();
                                    return;
                                }
                                if (val == 1) {
                                    EcosTurnoutManager.this.noWarnDelete = true;
                                }
                            }
                            EcosTurnoutManager.this.deleteEcosTurnout(et);
                            dialog.dispose();
                        }
                    });
                    container.add(remember);
                    container.setAlignmentX(0.5f);
                    container.setAlignmentY(0.5f);
                    dialog.getContentPane().add(container);
                    dialog.pack();
                    dialog.setModal(true);
                    dialog.setVisible(true);
                } else {
                    this._tecos.remove(et.getObject());
                }
            }
            ++i;
        }
        String[] stringArray = ecoslines;
        int n = ecoslines.length;
        int n3 = 0;
        while (n3 < n) {
            String li = stringArray[n3];
            String tmpturn = li.replaceAll("[\\n\\r]", "");
            int turnout = Integer.parseInt(tmpturn);
            if (this.getByEcosObject(turnout) == null) {
                EcosMessage mout = new EcosMessage("get(" + turnout + ", addrext)");
                this.tc.sendEcosMessage(mout, this);
            }
            ++n3;
        }
    }

    public String stripChar(String s) {
        String allowed = ",0123456789";
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            if (allowed.indexOf(s.charAt(i)) >= 0) {
                result.append(s.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }

    @Override
    public void message(EcosMessage m) {
    }

    @Override
    @SuppressFBWarnings(value={"UCF_USELESS_CONTROL_FLOW"}, justification="OK to compare floats, as even tiny differences should trigger update")
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("length") && !this.addingTurnouts) {
            EcosTurnout et;
            final EcosPreferences p = this.getMemo().getPreferenceManager();
            String[] ecoslist = this.getEcosObjectArray();
            for (Turnout turnout : this.getNamedBeanSet()) {
                if (!turnout.getSystemName().startsWith(this.getSystemNamePrefix())) continue;
                et = (EcosTurnout)turnout;
                et.getObject();
            }
            int i = 0;
            while (i < ecoslist.length) {
                et = (EcosTurnout)this.getByEcosObject(Integer.parseInt(ecoslist[i]));
                int address = et.getNumber();
                if (this.getBySystemName(String.valueOf(this.getSystemNamePrefix()) + address) == null) {
                    if (p.getRemoveTurnoutsFromEcos() == 2) {
                        RemoveObjectFromEcos removeObjectFromEcos = new RemoveObjectFromEcos();
                        removeObjectFromEcos.removeObjectFromEcos("" + et.getObject(), this.tc);
                        this.deleteEcosTurnout(et);
                    } else {
                        final EcosTurnout etd = et;
                        final JDialog dialog = new JDialog();
                        dialog.setTitle(Bundle.getMessage("RemoveTurnoutTitle"));
                        dialog.setLocation(300, 200);
                        dialog.setDefaultCloseOperation(2);
                        JPanel container = new JPanel();
                        container.setLayout(new BoxLayout(container, 1));
                        container.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                        JLabel question = new JLabel(Bundle.getMessage("RemoveTurnoutX", etd.getSystemName()));
                        question.setAlignmentX(0.5f);
                        container.add(question);
                        final JCheckBox remember = new JCheckBox(Bundle.getMessage("MessageRememberSetting"));
                        remember.setFont(remember.getFont().deriveFont(10.0f));
                        remember.setAlignmentX(0.5f);
                        remember.setVisible(true);
                        JButton yesButton = new JButton(Bundle.getMessage("ButtonYes"));
                        JButton noButton = new JButton(Bundle.getMessage("ButtonNo"));
                        JPanel button = new JPanel();
                        button.setAlignmentX(0.5f);
                        button.add(yesButton);
                        button.add(noButton);
                        container.add(button);
                        noButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (remember.isSelected()) {
                                    p.setRemoveTurnoutsFromEcos(1);
                                }
                                dialog.dispose();
                            }
                        });
                        yesButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (remember.isSelected()) {
                                    p.setRemoveTurnoutsFromEcos(2);
                                }
                                RemoveObjectFromEcos removeObjectFromEcos = new RemoveObjectFromEcos();
                                removeObjectFromEcos.removeObjectFromEcos("" + etd.getObject(), EcosTurnoutManager.this.tc);
                                EcosTurnoutManager.this.deleteEcosTurnout(etd);
                                dialog.dispose();
                            }
                        });
                        container.add(remember);
                        container.setAlignmentX(0.5f);
                        container.setAlignmentY(0.5f);
                        dialog.getContentPane().add(container);
                        dialog.pack();
                        dialog.setModal(true);
                        dialog.setVisible(true);
                    }
                }
                ++i;
            }
        }
        super.propertyChange(e);
    }

    public void deleteEcosTurnout(EcosTurnout et) {
        this.addingTurnouts = true;
        this.deregister(et);
        et.dispose();
        EcosMessage em = new EcosMessage("release(" + et.getObject() + ",view)");
        this.tc.sendEcosMessage(em, this);
        this._tecos.remove(et.getObject());
        this.addingTurnouts = false;
    }

    @Override
    public void dispose() {
        Enumeration<Integer> en = this._tecos.keys();
        while (en.hasMoreElements()) {
            int ecosObject = en.nextElement();
            EcosMessage em = new EcosMessage("release(" + ecosObject + ",view)");
            this.tc.sendEcosMessage(em, this);
        }
        if (InstanceManager.getNullableDefault(ConfigureManager.class) != null) {
            InstanceManager.getDefault(ConfigureManager.class).deregister(this);
        }
        this._tecos.clear();
    }

    public List<String> getEcosObjectList() {
        Object[] arr = new String[this._tecos.size()];
        ArrayList<String> out = new ArrayList<String>();
        Enumeration<Integer> en = this._tecos.keys();
        int i = 0;
        while (en.hasMoreElements()) {
            arr[i] = "" + en.nextElement();
            ++i;
        }
        Arrays.sort(arr);
        i = 0;
        while (i < arr.length) {
            out.add((String)arr[i]);
            ++i;
        }
        return out;
    }

    public String[] getEcosObjectArray() {
        Object[] arr = new String[this._tecos.size()];
        Enumeration<Integer> en = this._tecos.keys();
        int i = 0;
        while (en.hasMoreElements()) {
            arr[i] = "" + en.nextElement();
            ++i;
        }
        Arrays.sort(arr);
        return arr;
    }

    public Turnout getByEcosObject(int ecosObject) {
        return this._tecos.get(ecosObject);
    }

    public void refreshItems() {
        EcosMessage m = new EcosMessage("request(11, view)");
        this.tc.sendEcosMessage(m, this);
        for (Integer ecosObjectId : this._tecos.keySet()) {
            EcosMessage em = new EcosMessage("release(" + ecosObjectId + ",view)");
            this.tc.sendEcosMessage(em, this);
            em = new EcosMessage("get(" + ecosObjectId + ",state)");
            this.tc.sendEcosMessage(em, this);
            em = new EcosMessage("request(" + ecosObjectId + ",view)");
            this.tc.sendEcosMessage(em, this);
        }
    }

    @Override
    @Nonnull
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        int iName;
        try {
            iName = Integer.parseInt(curAddress);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JmriException("Hardware Address passed " + curAddress + " should be a number.");
        }
        return String.valueOf(prefix) + this.typeLetter() + iName;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        return this.validateSystemNameFormatOnlyNumeric(name, locale);
    }
}

