/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.Turnout;
import jmri.implementation.AbstractTurnout;
import jmri.jmrix.ecos.EcosListener;
import jmri.jmrix.ecos.EcosMessage;
import jmri.jmrix.ecos.EcosReply;
import jmri.jmrix.ecos.EcosTrafficController;
import jmri.jmrix.ecos.EcosTurnoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcosTurnout
extends AbstractTurnout
implements EcosListener {
    String prefix;
    int objectNumber = 0;
    boolean masterObjectNumber = true;
    String slaveAddress;
    int extended = 0;
    static String[] modeNames = null;
    static int[] modeValues = null;
    EcosTrafficController tc;
    EcosTurnoutManager tm;
    public static final int THREEWAY = 2;
    public static final int DOUBLESLIP = 4;
    int _number;
    int newstate = 1;
    int newstateext = 1;
    private static final Logger log = LoggerFactory.getLogger(EcosTurnout.class);

    public EcosTurnout(int number, String prefix, EcosTrafficController etc, EcosTurnoutManager etm) {
        super(String.valueOf(prefix) + "T" + number);
        this._number = number;
        this.prefix = prefix;
        this.tc = etc;
        this.tm = etm;
        this._validFeedbackTypes |= 0xE;
        this._activeFeedbackType = 8;
        if (modeNames == null) {
            this.initFeedbackModes();
        }
        this._validFeedbackNames = modeNames;
        this._validFeedbackModes = modeValues;
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Only used during creation of 1st turnout")
    private void initFeedbackModes() {
        if (this._validFeedbackNames.length != this._validFeedbackModes.length) {
            log.error("int and string feedback arrays different length");
        }
        String[] tempModeNames = new String[this._validFeedbackNames.length + 3];
        int[] tempModeValues = new int[this._validFeedbackNames.length + 3];
        int i = 0;
        while (i < this._validFeedbackNames.length) {
            tempModeNames[i] = this._validFeedbackNames[i];
            tempModeValues[i] = this._validFeedbackModes[i];
            ++i;
        }
        tempModeNames[this._validFeedbackNames.length] = "MONITORING";
        tempModeValues[this._validFeedbackNames.length] = 8;
        tempModeNames[this._validFeedbackNames.length + 1] = "INDIRECT";
        tempModeValues[this._validFeedbackNames.length + 1] = 4;
        tempModeNames[this._validFeedbackNames.length + 2] = "EXACT";
        tempModeValues[this._validFeedbackNames.length + 2] = 2;
        modeNames = tempModeNames;
        modeValues = tempModeValues;
    }

    void setExtended(int e) {
        this.extended = e;
    }

    void setObjectNumber(int o) {
        this.objectNumber = o;
    }

    void setSlaveAddress(int o) {
        this.slaveAddress = String.valueOf(this.prefix) + "T" + o;
    }

    void setMasterObjectNumber(boolean o) {
        this.masterObjectNumber = o;
    }

    public int getNumber() {
        return this._number;
    }

    public int getObject() {
        return this.objectNumber;
    }

    public int getExtended() {
        return this.extended;
    }

    public String getSlaveAddress() {
        return this.slaveAddress;
    }

    @Override
    protected void forwardCommandChangeToLayout(int newState) {
        if ((newState & 2) != 0) {
            if ((newState & 4) != 0) {
                log.error("Cannot command both CLOSED and THROWN {}", (Object)newState);
                return;
            }
            this.sendMessage(true ^ this.getInverted());
        } else {
            this.sendMessage(this.getInverted());
        }
    }

    synchronized void setCommandedStateFromCS(int state) {
        if (this.getFeedbackMode() != 8) {
            return;
        }
        this.newCommandedState(state);
    }

    synchronized void setKnownStateFromCS(int state) {
        if (this.getFeedbackMode() != 8) {
            return;
        }
        this.newKnownState(state);
    }

    @Override
    public void turnoutPushbuttonLockout(boolean b) {
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    protected void sendMessage(boolean closed) {
        this.newKnownState(1);
        if (this.getInverted()) {
            boolean bl = closed = !closed;
        }
        if (this.masterObjectNumber && this.extended == 0) {
            EcosMessage m = new EcosMessage("request(" + this.objectNumber + ", control)");
            this.tc.sendEcosMessage(m, null);
            m = new EcosMessage("set(" + this.objectNumber + ", state[" + (closed ? "0" : "1") + "])");
            this.tc.sendEcosMessage(m, null);
            m = new EcosMessage("release(" + this.objectNumber + ", control)");
            this.tc.sendEcosMessage(m, null);
        } else {
            boolean firststate;
            boolean secondstate;
            if (!this.masterObjectNumber) {
                int turnaddr = this._number - 1;
                Turnout t = this.tm.getTurnout(String.valueOf(this.prefix) + "T" + turnaddr);
                secondstate = closed;
                if (t == null) {
                    log.error("Unable to locate second Turnout address {}", (Object)turnaddr);
                    return;
                }
                firststate = t.getKnownState() == 2;
            } else {
                Turnout t = this.tm.getTurnout(this.slaveAddress);
                firststate = closed;
                if (t == null) {
                    log.error("Unable to locate slave Turnout address {}", (Object)this.slaveAddress);
                    return;
                }
                secondstate = t.getKnownState() == 2;
            }
            int setState = 0;
            if (this.extended == 2) {
                setState = firststate && secondstate ? 0 : (firststate && !secondstate ? 1 : 2);
            } else if (this.extended == 4) {
                setState = firststate && secondstate ? 0 : (!firststate && !secondstate ? 1 : (!firststate && secondstate ? 2 : 3));
            }
            if (setState == 99) {
                if (closed) {
                    this.setCommandedState(4);
                } else {
                    this.setCommandedState(2);
                }
            } else {
                EcosMessage m = new EcosMessage("request(" + this.objectNumber + ", control)");
                this.tc.sendEcosMessage(m, this);
                m = new EcosMessage("set(" + this.objectNumber + ", state[" + setState + "])");
                this.tc.sendEcosMessage(m, this);
                m = new EcosMessage("release(" + this.objectNumber + ", control)");
                this.tc.sendEcosMessage(m, this);
            }
        }
    }

    @Override
    public void reply(EcosReply m) {
        String msg = m.toString();
        if (m.getResultCode() != 0) {
            return;
        }
        if (m.getEcosObjectId() != this.objectNumber) {
            return;
        }
        if (msg.contains("switching[0]")) {
            log.debug("Turnout switched - new state={}", (Object)this.newstate);
            if (this.extended == 0) {
                this.newKnownState(this.newstate);
            } else if (this.masterObjectNumber) {
                this.newKnownState(this.newstate);
            } else {
                this.newKnownState(this.newstateext);
            }
        }
        if (m.isUnsolicited() || m.getReplyType().equals("get") || m.getReplyType().equals("set")) {
            int start = msg.indexOf("state[");
            int end = msg.indexOf("]");
            if (start > 0 && end > 0) {
                String val = msg.substring(start + 6, end);
                if (this.extended == 0) {
                    if (val.equals("0")) {
                        this.newstate = 2;
                    } else if (val.equals("1")) {
                        this.newstate = 4;
                    } else {
                        log.warn("val |{}| from {}", (Object)val, (Object)msg);
                    }
                    log.debug("newstate found: {}", (Object)this.newstate);
                    if (!m.getReplyType().equals("set")) {
                        this.newKnownState(this.newstate);
                    }
                } else {
                    if (this.extended == 2) {
                        if (val.equals("0")) {
                            this.newstate = 2;
                            this.newstateext = 2;
                        } else if (val.equals("1")) {
                            this.newstate = 2;
                            this.newstateext = 4;
                        } else if (val.equals("2")) {
                            this.newstate = 4;
                            this.newstateext = 2;
                        }
                    } else if (this.extended == 4) {
                        if (val.equals("0")) {
                            this.newstate = 2;
                            this.newstateext = 2;
                        } else if (val.equals("1")) {
                            this.newstate = 4;
                            this.newstateext = 4;
                        } else if (val.equals("2")) {
                            this.newstate = 4;
                            this.newstateext = 2;
                        } else if (val.equals("3")) {
                            this.newstate = 2;
                            this.newstateext = 4;
                        }
                    }
                    if (!m.getReplyType().equals("set")) {
                        if (this.masterObjectNumber) {
                            this.newKnownState(this.newstate);
                        } else {
                            this.newKnownState(this.newstateext);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void message(EcosMessage m) {
    }
}

