/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.AbstractMRTrafficController;
import jmri.jmrix.ecos.EcosInterface;
import jmri.jmrix.ecos.EcosListener;
import jmri.jmrix.ecos.EcosLocoAddressManager;
import jmri.jmrix.ecos.EcosMessage;
import jmri.jmrix.ecos.EcosPreferences;
import jmri.jmrix.ecos.EcosReply;
import jmri.jmrix.ecos.EcosSystemConnectionMemo;
import jmri.jmrix.ecos.EcosTurnoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcosTrafficController
extends AbstractMRTrafficController
implements EcosInterface {
    EcosSystemConnectionMemo adaptermemo;
    protected boolean unsolicitedSensorMessageSeen = false;
    @SuppressFBWarnings(value={"MS_PKGPROTECT"})
    protected static final EcosTrafficController self = null;
    private static final Logger log = LoggerFactory.getLogger(EcosTrafficController.class);

    public EcosTrafficController() {
        log.debug("creating a new EcosTrafficController object");
        this.setAllowUnexpectedReply(true);
        this.setSynchronizeRx(false);
    }

    public void setAdapterMemo(EcosSystemConnectionMemo memo) {
        this.adaptermemo = memo;
    }

    @Override
    public synchronized void addEcosListener(EcosListener l) {
        this.addListener(l);
    }

    @Override
    public synchronized void removeEcosListener(EcosListener l) {
        this.removeListener(l);
    }

    @Override
    protected int enterProgModeDelayTime() {
        return 1000;
    }

    @Override
    protected void forwardMessage(AbstractMRListener client, AbstractMRMessage m) {
        ((EcosListener)client).message((EcosMessage)m);
    }

    @Override
    protected void forwardReply(AbstractMRListener client, AbstractMRReply r) {
        ((EcosListener)client).reply((EcosReply)r);
    }

    @Override
    protected AbstractMRMessage pollMessage() {
        return null;
    }

    @Override
    protected AbstractMRListener pollReplyHandler() {
        return null;
    }

    @Override
    public void sendEcosMessage(EcosMessage m, EcosListener reply) {
        this.sendMessage(m, reply);
    }

    @Override
    protected void forwardToPort(AbstractMRMessage m, AbstractMRListener reply) {
        super.forwardToPort(m, reply);
    }

    @Override
    protected AbstractMRMessage enterProgMode() {
        return EcosMessage.getProgMode();
    }

    @Override
    protected AbstractMRMessage enterNormalMode() {
        return EcosMessage.getExitProgMode();
    }

    @Override
    protected AbstractMRReply newReply() {
        EcosReply reply = new EcosReply();
        return reply;
    }

    @Override
    protected boolean canReceive() {
        return true;
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply msg) {
        int num = msg.getNumDataElements();
        int ptr = num - 1;
        if (num >= 2 && msg.getElement(ptr) == 10 && msg.getElement(ptr - 1) == 13 && msg.getElement(ptr - 2) == 62) {
            return ((EcosReply)msg).containsEnd();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendWaitMessage(EcosMessage m, AbstractMRListener reply) {
        if (log.isDebugEnabled()) {
            log.debug("Send a message and wait for the response");
        }
        if (this.ostream == null) {
            return false;
        }
        m.setTimeout(500);
        m.setRetries(10);
        EcosTrafficController ecosTrafficController = this;
        synchronized (ecosTrafficController) {
            block11: {
                this.forwardToPort(m, reply);
                try {
                    if (this.xmtRunnable == null) break block11;
                    Runnable runnable = this.xmtRunnable;
                    synchronized (runnable) {
                        this.xmtRunnable.wait(m.getTimeout());
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    log.error("transmit interrupted");
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void terminate() {
        String ecosObject;
        if (log.isDebugEnabled()) {
            log.debug("Cleanup Starts");
        }
        if (this.ostream == null) {
            return;
        }
        EcosPreferences p = this.adaptermemo.getPreferenceManager();
        if (p.getAdhocLocoFromEcos() == 1) {
            return;
        }
        EcosMessage modeMsg = new EcosMessage("release(10, view)");
        modeMsg.setTimeout(50);
        modeMsg.setRetries(10);
        EcosTrafficController ecosTrafficController = this;
        synchronized (ecosTrafficController) {
            block35: {
                this.forwardToPort(modeMsg, null);
                try {
                    if (this.xmtRunnable == null) break block35;
                    Runnable runnable = this.xmtRunnable;
                    synchronized (runnable) {
                        this.xmtRunnable.wait(modeMsg.getTimeout());
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    log.error("transmit interrupted");
                }
            }
        }
        EcosTurnoutManager objEcosTurnManager = this.adaptermemo.getTurnoutManager();
        List<String> en = objEcosTurnManager.getEcosObjectList();
        int i = 0;
        while (i < en.size()) {
            ecosObject = en.get(i);
            modeMsg = new EcosMessage("release(" + ecosObject + ", view)");
            modeMsg.setTimeout(50);
            modeMsg.setRetries(10);
            EcosTrafficController ecosTrafficController2 = this;
            synchronized (ecosTrafficController2) {
                block36: {
                    this.forwardToPort(modeMsg, null);
                    try {
                        if (this.xmtRunnable == null) break block36;
                        Runnable runnable = this.xmtRunnable;
                        synchronized (runnable) {
                            this.xmtRunnable.wait(modeMsg.getTimeout());
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        log.error("transmit interrupted");
                    }
                }
            }
            ++i;
        }
        EcosLocoAddressManager objEcosLocoManager = this.adaptermemo.getLocoAddressManager();
        en = objEcosLocoManager.getEcosObjectList();
        int i2 = 0;
        while (i2 < en.size()) {
            ecosObject = en.get(i2);
            if (objEcosLocoManager.getByEcosObject(ecosObject).getEcosTempEntry()) {
                int x = 0;
                while (x < 4) {
                    switch (x) {
                        case 3: {
                            modeMsg = new EcosMessage("delete(" + ecosObject + ")");
                            break;
                        }
                        case 2: {
                            modeMsg = new EcosMessage("set(" + ecosObject + ", stop)");
                            break;
                        }
                        default: {
                            modeMsg = new EcosMessage("request(" + ecosObject + ", control)");
                        }
                    }
                    modeMsg.setTimeout(50);
                    modeMsg.setRetries(10);
                    EcosTrafficController ecosTrafficController3 = this;
                    synchronized (ecosTrafficController3) {
                        block37: {
                            this.forwardToPort(modeMsg, null);
                            try {
                                if (this.xmtRunnable == null) break block37;
                                Runnable runnable = this.xmtRunnable;
                                synchronized (runnable) {
                                    this.xmtRunnable.wait(modeMsg.getTimeout());
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                                log.error("transmit interrupted");
                            }
                        }
                    }
                    ++x;
                }
            }
            ++i2;
        }
    }
}

