/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos;

import java.util.Hashtable;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.jmrix.ecos.EcosListener;
import jmri.jmrix.ecos.EcosMessage;
import jmri.jmrix.ecos.EcosReply;
import jmri.jmrix.ecos.EcosReporter;
import jmri.jmrix.ecos.EcosSensor;
import jmri.jmrix.ecos.EcosSystemConnectionMemo;
import jmri.jmrix.ecos.EcosTrafficController;
import jmri.managers.AbstractSensorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcosSensorManager
extends AbstractSensorManager
implements EcosListener {
    private EcosTrafficController tc;
    private Hashtable<Integer, EcosSensor> _tecos = new Hashtable();
    private Hashtable<Integer, Integer> _sport = new Hashtable();
    private static final Logger log = LoggerFactory.getLogger(EcosSensorManager.class);

    public EcosSensorManager(EcosSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getTrafficController();
        this.tc.addEcosListener(this);
        EcosMessage m = new EcosMessage("queryObjects(26, ports)");
        this.tc.sendEcosMessage(m, this);
    }

    @Override
    @Nonnull
    public EcosSystemConnectionMemo getMemo() {
        return (EcosSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        return new EcosSensor(systemName, userName);
    }

    @Override
    public void reply(EcosReply m) {
        block18: {
            int ecosObjectId;
            block19: {
                if (m.getResultCode() != 0) break block18;
                ecosObjectId = m.getEcosObjectId();
                if (ecosObjectId != 26 && (ecosObjectId < 100 || ecosObjectId > 300)) {
                    log.debug("message receieved that is not within the valid Sensor object range");
                    return;
                }
                if (!m.isUnsolicited() && !m.getReplyType().equals("get")) break block19;
                String[] lines = m.getContents();
                int i = 0;
                while (i < lines.length) {
                    String val;
                    int start = lines[i].indexOf("[") + 1;
                    int end = lines[i].indexOf("]");
                    if (lines[i].contains("state") && (start += 2) > 0 && end > 0) {
                        val = lines[i].substring(start, end);
                        int intState = Integer.parseInt(val, 16);
                        this.decodeSensorState(ecosObjectId, intState);
                    }
                    if (lines[i].contains("railcom") && start > 0 && end > 0) {
                        val = lines[i].substring(start, lines[i].indexOf(",")).trim();
                        int j = Integer.parseInt(val);
                        ++j;
                        StringBuilder sb = new StringBuilder();
                        sb.append(this.getSystemPrefix());
                        sb.append("R");
                        sb.append(ecosObjectId);
                        sb.append(":");
                        if (j < 10) {
                            sb.append("0");
                        }
                        sb.append(j);
                        try {
                            EcosReporter rp = (EcosReporter)this.getMemo().getReporterManager().provideReporter(sb.toString());
                            rp.decodeDetails(lines[i]);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            log.warn("Failed to provide Reporter \"{}\" in reply", (Object)sb.toString());
                        }
                    }
                    ++i;
                }
                break block18;
            }
            if (!m.getReplyType().equals("queryObjects") || ecosObjectId != 26) break block18;
            String[] lines = m.getContents();
            int i = 0;
            while (i < lines.length) {
                int end;
                int start;
                int object;
                if (lines[i].contains("ports[") && 100 <= (object = Integer.parseInt(lines[i].substring(start = 0, end = lines[i].indexOf(32)))) && object < 300) {
                    start = lines[i].indexOf(91) + 1;
                    end = lines[i].indexOf(93);
                    int ports = Integer.parseInt(lines[i].substring(start, end));
                    log.debug("Found sensor object {} ports {}", (Object)object, (Object)ports);
                    if (ports == 8 || ports == 16) {
                        String sensorprefix = String.valueOf(this.getSystemPrefix()) + "S" + object + ":";
                        this._sport.put(object, ports);
                        int j = 1;
                        while (j <= ports) {
                            StringBuilder sb = new StringBuilder();
                            sb.append(sensorprefix);
                            if (j < 10) {
                                sb.append("0");
                            }
                            sb.append(j);
                            Sensor s = this.getSensor(sb.toString());
                            if (s == null) {
                                EcosSensor es = (EcosSensor)this.provideSensor(sb.toString());
                                es.setObjectNumber(object);
                                this._tecos.put(object, es);
                                if (object >= 200 && (j == 1 || j == 5 || j == 9 || j == 13)) {
                                    sb = new StringBuilder();
                                    sb.append(this.getSystemPrefix());
                                    sb.append("R");
                                    sb.append(object);
                                    sb.append(":");
                                    if (j < 10) {
                                        sb.append("0");
                                    }
                                    sb.append(j);
                                    try {
                                        EcosReporter rp = (EcosReporter)this.getMemo().getReporterManager().provideReporter(sb.toString());
                                        rp.setObjectPort(object, j - 1);
                                        es.setReporter(rp);
                                        EcosMessage em = new EcosMessage("get(" + object + ", railcom[" + (j - 1) + "])");
                                        this.tc.sendEcosMessage(em, this);
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        log.warn("Failed to provide Reporter \"{}\"", (Object)sb.toString());
                                    }
                                }
                            }
                            ++j;
                        }
                        EcosMessage em = new EcosMessage("request(" + object + ", view)");
                        this.tc.sendEcosMessage(em, this);
                        em = new EcosMessage("get(" + object + ",state)");
                        this.tc.sendEcosMessage(em, this);
                    } else {
                        log.debug("Invalid number of ports returned for Module {}", (Object)object);
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void message(EcosMessage m) {
    }

    private void decodeSensorState(int object, int intState) {
        int k = 1;
        String sensorprefix = String.valueOf(this.getSystemPrefix()) + "S" + object + ":";
        int port = 1;
        while (port <= this._sport.get(object)) {
            int result = intState & k;
            StringBuilder sb = new StringBuilder();
            sb.append(sensorprefix);
            if (port < 10) {
                sb.append("0");
            }
            sb.append(port);
            EcosSensor es = (EcosSensor)this.provideSensor(sb.toString());
            if (result == 0) {
                es.setOwnState(4);
            } else {
                es.setOwnState(2);
            }
            k *= 2;
            ++port;
        }
    }

    public void refreshItems() {
        EcosMessage m = new EcosMessage("queryObjects(26, ports)");
        this.tc.sendEcosMessage(m, this);
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        return this.validateTrimmedMin1NumberSystemNameFormat(name, locale);
    }
}

