/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos;

import java.util.Arrays;
import java.util.List;
import jmri.jmrix.AbstractMRReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcosReply
extends AbstractMRReply {
    int endAtElement = -1;
    String replyType = null;
    List<String> headerDetails = null;
    int objectId = -1;
    private static final Logger log = LoggerFactory.getLogger(EcosReply.class);

    public EcosReply() {
    }

    public EcosReply(String s) {
        super(s);
    }

    public EcosReply(EcosReply l) {
        super(l);
    }

    @Override
    public int maxSize() {
        return 10000;
    }

    @Override
    protected int skipPrefix(int index) {
        return index;
    }

    @Override
    public int value() {
        if (this.isBinary()) {
            return this.getElement(0) & 0xFF;
        }
        return super.value();
    }

    public boolean containsEnd() {
        int i = 0;
        while (i < this.getNumDataElements() - 6) {
            if (this.getElement(i) == 10 && this.getElement(i + 1) == 60 && this.getElement(i + 2) == 69 && this.getElement(i + 3) == 78 && this.getElement(i + 4) == 68 && this.getElement(i + 5) == 32) {
                this.endAtElement = i;
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getResultCode() {
        if (!this.containsEnd()) {
            log.error("Trying to get message end code before message is complete");
            return -1;
        }
        if (this.endAtElement == -1) {
            return -1;
        }
        String resultCode = Character.toString((char)this.getElement(this.endAtElement + 6));
        resultCode = String.valueOf(resultCode) + (char)this.getElement(this.endAtElement + 7);
        resultCode = resultCode.trim();
        try {
            return Integer.parseInt(resultCode);
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Unable to convert result code to a number {}", (Object)resultCode);
            return -1;
        }
    }

    boolean isEvent() {
        if (this.getNumDataElements() < 8) {
            return false;
        }
        if (this.getElement(0) != 60) {
            return false;
        }
        if (this.getElement(1) != 69) {
            return false;
        }
        if (this.getElement(2) != 86) {
            return false;
        }
        if (this.getElement(3) != 69) {
            return false;
        }
        if (this.getElement(4) != 78) {
            return false;
        }
        if (this.getElement(5) != 84) {
            return false;
        }
        return this.getElement(6) == 32;
    }

    @Override
    public boolean isUnsolicited() {
        if (this.isEvent()) {
            this.setUnsolicited();
            return true;
        }
        return false;
    }

    public boolean isReply() {
        if (this.getNumDataElements() < 8) {
            return false;
        }
        if (this.getElement(0) != 60) {
            return false;
        }
        if (this.getElement(1) != 82) {
            return false;
        }
        if (this.getElement(2) != 69) {
            return false;
        }
        if (this.getElement(3) != 80) {
            return false;
        }
        if (this.getElement(4) != 76) {
            return false;
        }
        if (this.getElement(5) != 89) {
            return false;
        }
        return this.getElement(6) == 32;
    }

    public String getReplyType() {
        if (!this.isReply()) {
            return "";
        }
        if (this.replyType != null) {
            return this.replyType;
        }
        StringBuilder sb = new StringBuilder();
        int i = 7;
        while (i < this.getNumDataElements()) {
            if (this.getElement(i) == 40) break;
            sb.append((char)this.getElement(i));
            ++i;
        }
        this.replyType = sb.toString();
        return sb.toString();
    }

    public List<String> getReplyHeaderDetails() {
        if (!this.isReply()) {
            return Arrays.asList(new String[0]);
        }
        if (this.headerDetails != null) {
            return this.headerDetails;
        }
        StringBuilder sb = new StringBuilder();
        int iOffSet = 8 + this.getReplyType().length() + ("" + this.getEcosObjectId()).length();
        if (this.getElement(iOffSet) == 44) {
            ++iOffSet;
        }
        if (this.getElement(iOffSet) == 32) {
            ++iOffSet;
        }
        int i = iOffSet;
        while (i < this.getNumDataElements()) {
            if (this.getElement(i) == 41) break;
            sb.append((char)this.getElement(i));
            ++i;
        }
        this.headerDetails = Arrays.asList(sb.toString().split(","));
        return this.headerDetails;
    }

    public int getEcosObjectId() {
        if (this.objectId != -1) {
            return this.objectId;
        }
        StringBuilder sb = new StringBuilder();
        int iOffSet = 7 + this.getReplyType().length();
        if (!this.isEvent()) {
            ++iOffSet;
        }
        int i = iOffSet;
        while (i < this.getNumDataElements()) {
            if (this.getElement(i) == 62 || this.getElement(i) == 44 || this.getElement(i) == 41) break;
            sb.append((char)this.getElement(i));
            ++i;
        }
        this.objectId = Integer.parseInt(sb.toString());
        return this.objectId;
    }

    public String[] getContents() {
        String[] lines = this.toString().split("\n");
        int length = lines.length - 2;
        String[] returnval = new String[length];
        int i = 1;
        while (i <= length) {
            returnval[i - 1] = lines[i];
            ++i;
        }
        return returnval;
    }

    public static String getContentDetail(String str) {
        int start = str.indexOf("[") + 1;
        int end = str.indexOf("]");
        return str.substring(start, end);
    }

    public static String getContentDetails(String line, String item) {
        int startval = line.indexOf(item) + item.length() + 1;
        int endval = line.substring(startval).indexOf("]") + startval;
        return line.substring(startval, endval);
    }
}

