/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.AbstractProgrammer;
import jmri.jmrix.ecos.EcosListener;
import jmri.jmrix.ecos.EcosMessage;
import jmri.jmrix.ecos.EcosReply;
import jmri.jmrix.ecos.EcosTrafficController;
import jmri.jmrix.ecos.utilities.GetEcosObjectNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcosProgrammer
extends AbstractProgrammer
implements EcosListener {
    EcosTrafficController tc;
    int ecosObject = 5;
    String readCommand = "mode[readdccdirect]";
    String writeCommand = "mode[writedccdirect]";
    int progState = 0;
    static final int NOTPROGRAMMING = 0;
    static final int MODESENT = 1;
    static final int COMMANDSENT = 2;
    boolean _progRead = false;
    int _val;
    int _cv;
    private ProgListener _usingProgrammer = null;
    private static final Logger log = LoggerFactory.getLogger(EcosProgrammer.class);

    public EcosProgrammer(EcosTrafficController etc) {
        this.tc = etc;
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(ProgrammingMode.DIRECTBYTEMODE);
        return ret;
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        if (log.isDebugEnabled()) {
            log.debug("writeCV {} listens {}", (Object)CV, (Object)p);
        }
        this.useProgrammer(p);
        this._progRead = false;
        this.progState = 1;
        this._val = val;
        this._cv = CV;
        this.startShortTimer();
        EcosMessage m = new EcosMessage("request(" + this.ecosObject + ",view)");
        this.tc.sendEcosMessage(m, this);
    }

    @Override
    public synchronized void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        this.readCV(CV, p);
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        if (log.isDebugEnabled()) {
            log.debug("readCV {} listens {}", (Object)CV, (Object)p);
        }
        this.useProgrammer(p);
        this._progRead = true;
        this.progState = 1;
        this._cv = CV;
        this.startShortTimer();
        EcosMessage m = new EcosMessage("request(" + this.ecosObject + ",view)");
        this.tc.sendEcosMessage(m, this);
    }

    protected void useProgrammer(ProgListener p) throws ProgrammerException {
        if (this._usingProgrammer != null && this._usingProgrammer != p) {
            if (log.isInfoEnabled()) {
                log.info("programmer already in use by {}", (Object)this._usingProgrammer);
            }
            throw new ProgrammerException("programmer in use");
        }
        this._usingProgrammer = p;
    }

    @Override
    public void message(EcosMessage m) {
        log.info("message: {}", (Object)m);
    }

    @Override
    public synchronized void reply(EcosReply reply) {
        log.info("reply: {}", (Object)reply);
        if (this.progState == 0) {
            if (log.isDebugEnabled()) {
                log.debug("reply in NOTPROGRAMMING state");
            }
            return;
        }
        if (this.progState == 1) {
            log.debug("reply in MODESENT state");
            if (reply.match("<REPLY request(" + this.ecosObject + ",view)>") == -1) {
                return;
            }
            if (reply.match("<END 0 (OK)>") == -1) {
                return;
            }
            this.progState = 2;
            try {
                this.startLongTimer();
                EcosMessage m = this._progRead ? new EcosMessage("set(" + this.ecosObject + "," + this.readCommand + ",cv[" + this._cv + "])") : new EcosMessage("set(" + this.ecosObject + "," + this.writeCommand + ",cv[" + this._cv + "," + this._val + "])");
                this.tc.sendEcosMessage(m, this);
            }
            catch (Exception e) {
                log.error("program operation failed, exception {}", (Throwable)e);
                this.progState = 0;
                EcosMessage m = new EcosMessage("release(" + this.ecosObject + ",view)");
                this.tc.sendEcosMessage(m, this);
                this.notifyProgListenerEnd(-1, 2);
                return;
            }
        } else if (this.progState == 2) {
            if (log.isDebugEnabled()) {
                log.debug("reply in COMMANDSENT state");
            }
            if (reply.match("<EVENT " + this.ecosObject + ">") == -1) {
                return;
            }
            this.progState = 0;
            this.stopTimer();
            EcosMessage m = new EcosMessage("release(" + this.ecosObject + ",view)");
            this.tc.sendEcosMessage(m, this);
            if (reply.match("error") >= 0 || reply.match(",ok]") == -1) {
                log.debug("ERROR during programming {}", (Object)reply);
                this.notifyProgListenerEnd(-1, 2);
                return;
            }
            if (this._progRead) {
                this._val = GetEcosObjectNumber.getEcosObjectNumber(reply.toString(), ",", ",ok]");
                log.debug("read CV {} value: ", (Object)this._cv, (Object)this._val);
            }
            this.notifyProgListenerEnd(this._val, 0);
        } else {
            log.debug("reply in un-decoded state");
        }
    }

    @Override
    protected synchronized void timeout() {
        if (this.progState != 0) {
            if (log.isDebugEnabled()) {
                log.debug("timeout!");
            }
            this.progState = 0;
            EcosMessage m = new EcosMessage("release(" + this.ecosObject + ",view)");
            this.tc.sendEcosMessage(m, this);
            this.notifyProgListenerEnd(this._val, 128);
        }
    }

    protected void notifyProgListenerEnd(int value, int status) {
        if (log.isDebugEnabled()) {
            log.debug("notifyProgListenerEnd value {} status {}", (Object)value, (Object)status);
        }
        ProgListener temp = this._usingProgrammer;
        this._usingProgrammer = null;
        this.notifyProgListenerEnd(temp, value, status);
    }
}

