/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos;

import jmri.JmriException;
import jmri.jmrix.ecos.EcosListener;
import jmri.jmrix.ecos.EcosMessage;
import jmri.jmrix.ecos.EcosReply;
import jmri.jmrix.ecos.EcosSystemConnectionMemo;
import jmri.jmrix.ecos.EcosTrafficController;
import jmri.managers.AbstractPowerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcosPowerManager
extends AbstractPowerManager<EcosSystemConnectionMemo>
implements EcosListener {
    EcosTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(EcosPowerManager.class);

    public EcosPowerManager(EcosTrafficController etc) {
        super(etc.adaptermemo);
        this.tc = etc;
        this.tc.addEcosListener(this);
        EcosMessage m = new EcosMessage("request(1, view)");
        this.tc.sendEcosMessage(m, this);
        m = new EcosMessage("get(1, status)");
        this.tc.sendEcosMessage(m, this);
    }

    @Override
    public void setPower(int v) throws JmriException {
        int old = this.power;
        this.power = 1;
        this.checkTC();
        if (v == 2) {
            EcosMessage l = new EcosMessage("set(1, go)");
            this.tc.sendEcosMessage(l, this);
        } else if (v == 4) {
            EcosMessage l = new EcosMessage("set(1, stop)");
            this.tc.sendEcosMessage(l, this);
        }
        this.firePowerPropertyChange(old, this.power);
    }

    @Override
    public void dispose() throws JmriException {
        this.tc.removeEcosListener(this);
        this.tc = null;
    }

    private void checkTC() throws JmriException {
        if (this.tc == null) {
            throw new JmriException("attempt to use EcosPowerManager after dispose");
        }
    }

    @Override
    public void reply(EcosReply m) {
        String msg = m.toString();
        if (msg.contains("<EVENT 1>") || msg.contains("REPLY get(1,") || msg.contains("REPLY set(1,")) {
            int old = this.power;
            if (msg.contains("status[GO]") || msg.contains("et(1, go)")) {
                log.debug("POWER ON DETECTED");
                this.power = 2;
            } else if (msg.contains("status[STOP]") || msg.contains("et(1, stop)")) {
                log.debug("POWER OFF DETECTED");
                this.power = 4;
            }
            this.firePowerPropertyChange(old, this.power);
        }
    }

    @Override
    public void message(EcosMessage m) {
    }
}

