/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammer;
import jmri.ProgrammingMode;
import jmri.jmrix.ecos.EcosProgrammer;
import jmri.jmrix.ecos.EcosTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcosOpsModeProgrammer
extends EcosProgrammer
implements AddressedProgrammer {
    int mAddress;
    boolean mLongAddr;
    private static final Logger log = LoggerFactory.getLogger(EcosOpsModeProgrammer.class);

    public EcosOpsModeProgrammer(EcosTrafficController tc, int pAddress, boolean pLongAddr) {
        super(tc);
        log.debug("ECoS ops mode programmer {} {}", (Object)pAddress, (Object)pLongAddr);
        this.mAddress = pAddress;
        this.mLongAddr = pLongAddr;
        this.ecosObject = 7;
        this.readCommand = "mode[readdccpomloco],addr[" + pAddress + "]";
        this.writeCommand = "mode[writedccpomloco],addr[" + pAddress + "]";
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(ProgrammingMode.OPSBYTEMODE);
        return ret;
    }

    @Override
    public boolean getCanRead() {
        return true;
    }

    @Override
    public boolean getLongAddress() {
        return this.mLongAddr;
    }

    @Override
    public int getAddressNumber() {
        return this.mAddress;
    }

    @Override
    public String getAddress() {
        return this.getAddressNumber() + " " + this.getLongAddress();
    }
}

