/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ecos;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.HeadlessException;
import javax.swing.JOptionPane;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.ThrottleManager;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.ecos.Bundle;
import jmri.jmrix.ecos.EcosDccThrottleManager;
import jmri.jmrix.ecos.EcosListener;
import jmri.jmrix.ecos.EcosLocoAddress;
import jmri.jmrix.ecos.EcosLocoAddressManager;
import jmri.jmrix.ecos.EcosMessage;
import jmri.jmrix.ecos.EcosPreferences;
import jmri.jmrix.ecos.EcosReply;
import jmri.jmrix.ecos.EcosSystemConnectionMemo;
import jmri.jmrix.ecos.EcosTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcosDccThrottle
extends AbstractThrottle
implements EcosListener {
    String objectNumber;
    int ecosretry = 0;
    private EcosLocoAddress objEcosLoco;
    private EcosLocoAddressManager objEcosLocoManager;
    final EcosPreferences p;
    private boolean _haveControl = false;
    private boolean _hadControl = false;
    private boolean _control = true;
    long lastSpeedMessageTime = 0L;
    EcosTrafficController tc;
    int speedMessageSent = 0;
    private DccLocoAddress address;
    private static final Logger log = LoggerFactory.getLogger(EcosDccThrottle.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EcosDccThrottle(DccLocoAddress address, EcosSystemConnectionMemo memo, boolean control) {
        super(memo, 32);
        this.speedStepMode = SpeedStepMode.NMRA_DCC_128;
        this.p = memo.getPreferenceManager();
        this.tc = memo.getTrafficController();
        this.objEcosLocoManager = memo.getLocoAddressManager();
        EcosDccThrottle ecosDccThrottle = this;
        synchronized (ecosDccThrottle) {
            this.speedSetting = 0.0f;
        }
        this.address = address;
        this.isForward = true;
        this._control = control;
        this.ecosretry = 0;
        log.debug("EcosDccThrottle constructor {}", (Object)address);
        if (address.getNumber() < EcosLocoAddress.MFX_DCCAddressOffset) {
            this.objEcosLoco = this.objEcosLocoManager.provideByDccAddress(address.getNumber());
        } else {
            int ecosID = address.getNumber() - EcosLocoAddress.MFX_DCCAddressOffset;
            this.objEcosLoco = this.objEcosLocoManager.provideByEcosObject(String.valueOf(ecosID));
        }
        this.objectNumber = this.objEcosLoco.getEcosObject();
        if (this.objectNumber == null) {
            this.createEcosLoco();
        } else {
            this.getControl();
        }
    }

    private void getControl() {
        this.setSpeedStepMode(this.objEcosLoco.getSpeedStepMode());
        String message = "get(" + this.objectNumber + ", speed)";
        EcosMessage m = new EcosMessage(message);
        this.tc.sendEcosMessage(m, this);
        message = "get(" + this.objectNumber + ", dir)";
        m = new EcosMessage(message);
        this.tc.sendEcosMessage(m, this);
        message = this._control ? (this.p.getLocoControl() ? "request(" + this.objectNumber + ", view, control, force)" : "request(" + this.objectNumber + ", view, control)") : "request(" + this.objectNumber + ", view)";
        m = new EcosMessage(message);
        this.tc.sendEcosMessage(m, this);
    }

    protected float floatSpeed(int lSpeed) {
        if (lSpeed == 0) {
            return 0.0f;
        }
        if (this.getSpeedStepMode() == SpeedStepMode.NMRA_DCC_28) {
            int step = (int)Math.ceil((double)lSpeed / 4.65);
            return (float)step * this.getSpeedIncrement();
        }
        return (float)lSpeed / 126.0f;
    }

    @Override
    public void setFunction(int functionNum, boolean newState) {
        this.updateFunction(functionNum, newState);
        if (this._haveControl) {
            EcosMessage m = new EcosMessage("set(" + this.objectNumber + ", func[" + String.valueOf(functionNum) + ", " + (newState ? 1 : 0) + "])");
            this.tc.sendEcosMessage(m, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    public void setSpeedSetting(float speed) {
        if (!this._haveControl) {
            return;
        }
        EcosDccThrottle ecosDccThrottle = this;
        synchronized (ecosDccThrottle) {
            if (speed == this.speedSetting && this.speedMessageSent <= 0) {
                return;
            }
        }
        int value = (int)(126.0f * speed);
        if (value > 128) {
            value = 126;
        }
        if (value > 0 || (double)value == 0.0) {
            String message = "set(" + this.objectNumber + ", speed[" + value + "])";
            EcosMessage m = new EcosMessage(message);
            this.tc.sendEcosMessage(m, this);
            if (this.speedMessageSent != 0 && (System.currentTimeMillis() - this.lastSpeedMessageTime > 500L || this.speedMessageSent < 0)) {
                this.speedMessageSent = 0;
            }
            this.lastSpeedMessageTime = System.currentTimeMillis();
            ++this.speedMessageSent;
        } else {
            String message = "set(" + this.objectNumber + ", stop)";
            Object m = this;
            synchronized (m) {
                this.speedSetting = 0.0f;
            }
            m = new EcosMessage(message);
            this.tc.sendEcosMessage((EcosMessage)m, this);
        }
        this.record(speed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIsForward(boolean forward) {
        String message;
        if (!this._haveControl) {
            return;
        }
        EcosDccThrottle ecosDccThrottle = this;
        synchronized (ecosDccThrottle) {
            if (this.speedSetting > 0.0f) {
                int speedValue = (int)(126.0f * this.speedSetting);
                if (speedValue > 128) {
                    speedValue = 126;
                }
                message = "set(" + this.objectNumber + ", dir[" + (forward ? 0 : 1) + "], speed[" + speedValue + "])";
            } else {
                message = "set(" + this.objectNumber + ", dir[" + (forward ? 0 : 1) + "])";
            }
        }
        EcosMessage m = new EcosMessage(message);
        this.tc.sendEcosMessage(m, this);
    }

    @Override
    public LocoAddress getLocoAddress() {
        return this.address;
    }

    @Override
    public void throttleDispose() {
        String message = "release(" + this.objectNumber + ", control)";
        EcosMessage m = new EcosMessage(message);
        this.tc.sendEcosMessage(m, this);
        this._haveControl = false;
        this._hadControl = false;
        this.finishRecord();
    }

    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    public void reply(EcosReply m) {
        int resultCode = m.getResultCode();
        if (resultCode == 0) {
            String replyType = m.getReplyType();
            if (replyType.equals("create")) {
                String[] msgDetails;
                String[] stringArray = msgDetails = m.getContents();
                int n = msgDetails.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    if (line.startsWith("10 id[")) {
                        String EcosAddr = EcosReply.getContentDetail(line);
                        this.objEcosLoco.setEcosObject(EcosAddr);
                        this.objEcosLocoManager.deregister(this.objEcosLoco);
                        this.objEcosLocoManager.register(this.objEcosLoco);
                        this.objEcosLoco.setEcosTempEntry(true);
                        this.objEcosLoco.doNotAddToRoster();
                        this.objectNumber = EcosAddr;
                        this.getControl();
                    }
                    ++n2;
                }
                return;
            }
            if (m.getEcosObjectId() != this.objEcosLoco.getEcosObjectAsInt()) {
                log.debug("message is not for us");
                return;
            }
            if (replyType.equals("set")) {
                String[] msgDetails;
                String[] stringArray = msgDetails = m.getContents();
                int n = msgDetails.length;
                int n3 = 0;
                while (n3 < n) {
                    String line = stringArray[n3];
                    if (line.contains("speed") && !line.contains("speedstep")) {
                        --this.speedMessageSent;
                        if (this.speedMessageSent <= 0) {
                            Float newSpeed = Float.valueOf(this.floatSpeed(Integer.parseInt(EcosReply.getContentDetails(line, "speed"))));
                            super.setSpeedSetting(newSpeed.floatValue());
                        }
                    }
                    if (line.contains("dir")) {
                        boolean newDirection = false;
                        if (EcosReply.getContentDetails(line, "dir").equals("0")) {
                            newDirection = true;
                        }
                        super.setIsForward(newDirection);
                    }
                    ++n3;
                }
                if (msgDetails.length == 0) {
                    if (m.toString().contains("speed") && !m.toString().contains("speedstep")) {
                        --this.speedMessageSent;
                        if (this.speedMessageSent <= 0) {
                            Float newSpeed = Float.valueOf(this.floatSpeed(Integer.parseInt(EcosReply.getContentDetails(m.toString(), "speed"))));
                            super.setSpeedSetting(newSpeed.floatValue());
                        }
                    }
                    if (m.toString().contains("dir")) {
                        boolean newDirection = false;
                        if (EcosReply.getContentDetails(m.toString(), "dir").equals("0")) {
                            newDirection = true;
                        }
                        super.setIsForward(newDirection);
                    }
                }
            } else if (replyType.equals("get") || m.isUnsolicited()) {
                String[] msgDetails;
                String[] stringArray = msgDetails = m.getContents();
                int n = msgDetails.length;
                int n4 = 0;
                while (n4 < n) {
                    String line = stringArray[n4];
                    if (this.speedMessageSent <= 0 || !m.isUnsolicited() || !line.contains("speed")) {
                        if (this.speedMessageSent <= 0 && line.contains("speed") && !line.contains("speedstep")) {
                            Float newSpeed = Float.valueOf(this.floatSpeed(Integer.parseInt(EcosReply.getContentDetails(line, "speed"))));
                            super.setSpeedSetting(newSpeed.floatValue());
                        } else if (line.contains("dir")) {
                            boolean newDirection = false;
                            if (EcosReply.getContentDetails(line, "dir").equals("0")) {
                                newDirection = true;
                            }
                            super.setIsForward(newDirection);
                        } else if (line.contains("protocol")) {
                            String pro = EcosReply.getContentDetails(line, "protocol");
                            if (pro.equals("DCC128")) {
                                this.setSpeedStepMode(SpeedStepMode.NMRA_DCC_128);
                            } else if (pro.equals("DCC28")) {
                                this.setSpeedStepMode(SpeedStepMode.NMRA_DCC_28);
                            } else if (pro.equals("DCC14")) {
                                this.setSpeedStepMode(SpeedStepMode.NMRA_DCC_14);
                            }
                        } else if (line.contains("func[")) {
                            String funcStr = EcosReply.getContentDetails(line, "func");
                            int function = Integer.parseInt(funcStr.substring(0, funcStr.indexOf(",")).trim());
                            int functionValue = Integer.parseInt(funcStr.substring(funcStr.indexOf(",") + 1, funcStr.length()).trim());
                            this.updateFunction(function, functionValue == 1);
                        } else if (line.contains("msg") && line.contains("CONTROL_LOST")) {
                            this.retryControl();
                            log.debug("We have no control over the ecos object, but will retry.");
                        }
                    }
                    ++n4;
                }
            } else if (replyType.equals("release")) {
                log.debug("Released {} from the Ecos", (Object)this.objectNumber);
                this._haveControl = false;
            } else if (replyType.equals("request")) {
                log.debug("We have control over {} from the Ecos", (Object)this.objectNumber);
                this.ecosretry = 0;
                if (this._control) {
                    this._haveControl = true;
                }
                if (!this._hadControl) {
                    ((EcosDccThrottleManager)this.adapterMemo.get(ThrottleManager.class)).throttleSetup(this, this.address, true);
                    this.getInitialStates();
                }
            }
        } else if (resultCode == 35) {
            log.info("Another loco create operation is already taking place unable to create another.");
        } else if (resultCode == 25) {
            this.retryControl();
        } else if (resultCode == 15) {
            log.info("Loco can not be accessed via the Ecos Object Id {}", (Object)this.objectNumber);
            try {
                JOptionPane.showMessageDialog(null, Bundle.getMessage("UnknownLocoDialog", this.address), Bundle.getMessage("WarningTitle"), 2);
            }
            catch (HeadlessException headlessException) {}
            InstanceManager.throttleManagerInstance().releaseThrottle(this, null);
        } else {
            log.debug("Last Message resulted in an END code we do not understand {}", (Object)resultCode);
        }
    }

    @Override
    public void message(EcosMessage m) {
    }

    public void forceControl() {
        String message = "request(" + this.objectNumber + ", control, force)";
        EcosMessage ms = new EcosMessage(message);
        this.tc.sendEcosMessage(ms, this);
    }

    private String protocol(LocoAddress.Protocol protocol) {
        switch (protocol) {
            case MOTOROLA: {
                return "MM28";
            }
            case SELECTRIX: {
                return "SX28";
            }
            case MFX: {
                return "MMFKT";
            }
            case LGB: {
                return "LGB";
            }
        }
        return "DCC128";
    }

    private void createEcosLoco() {
        this.objEcosLoco.setEcosDescription(Bundle.getMessage("CreatedByJMRI"));
        this.objEcosLoco.setProtocol(this.protocol(this.address.getProtocol()));
        String message = "create(10, addr[" + this.objEcosLoco.getNumber() + "], name[\"Created By JMRI\"], protocol[" + this.objEcosLoco.getECOSProtocol() + "], append)";
        EcosMessage m = new EcosMessage(message);
        this.tc.sendEcosMessage(m, this);
    }

    private void retryControl() {
        if (this._haveControl) {
            this._hadControl = true;
        }
        this._haveControl = false;
        if (this.ecosretry < 3) {
            ++this.ecosretry;
            String message = "request(" + this.objectNumber + ", view, control)";
            EcosMessage ms = new EcosMessage(message);
            this.tc.sendEcosMessage(ms, this);
            log.error("We have no control over the ecos object {} Retrying Attempt {}", (Object)this.objectNumber, (Object)this.ecosretry);
        } else if (this.ecosretry == 3) {
            ++this.ecosretry;
            int val = 0;
            if (this.p.getForceControlFromEcos() == 0) {
                try {
                    val = JOptionPane.showConfirmDialog(null, "UnableToGainDialog", Bundle.getMessage("WarningTitle"), 0, 3);
                }
                catch (HeadlessException headlessException) {
                    val = 1;
                }
            } else if (this.p.getForceControlFromEcos() == 1) {
                val = 1;
            }
            if (val == 0) {
                String message = "request(" + this.objectNumber + ", view, control, force)";
                EcosMessage ms = new EcosMessage(message);
                this.tc.sendEcosMessage(ms, this);
                log.error("We have no control over the ecos object {}Trying a forced control", (Object)this.objectNumber);
            } else if (this._hadControl) {
                this.firePropertyChange("LostControl", 0, 0);
                this._hadControl = false;
                this.ecosretry = 0;
            } else {
                ((EcosDccThrottleManager)this.adapterMemo.get(ThrottleManager.class)).throttleSetup(this, this.address, false);
            }
        } else {
            this.ecosretry = 0;
            if (this._hadControl) {
                this.firePropertyChange("LostControl", 0, 0);
            } else {
                ((EcosDccThrottleManager)this.adapterMemo.get(ThrottleManager.class)).throttleSetup(this, this.address, false);
            }
            ((EcosDccThrottleManager)this.adapterMemo.get(ThrottleManager.class)).releaseThrottle(this, null);
        }
    }

    void getInitialStates() {
        String message = "get(" + this.objectNumber + ", speed)";
        EcosMessage m = new EcosMessage(message);
        this.tc.sendEcosMessage(m, this);
        message = "get(" + this.objectNumber + ", dir)";
        m = new EcosMessage(message);
        this.tc.sendEcosMessage(m, this);
        int i = 0;
        while (i <= 28) {
            message = "get(" + this.objectNumber + ", func[" + i + "])";
            m = new EcosMessage(message);
            this.tc.sendEcosMessage(m, this);
            ++i;
        }
    }
}

