/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.easydcc.simulator;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import jmri.jmrix.easydcc.EasyDccMessage;
import jmri.jmrix.easydcc.EasyDccPortController;
import jmri.jmrix.easydcc.EasyDccReply;
import jmri.jmrix.easydcc.EasyDccSystemConnectionMemo;
import jmri.util.ImmediatePipedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulatorAdapter
extends EasyDccPortController
implements Runnable {
    private boolean opened = false;
    private Thread sourceThread;
    static final int SENSOR_MSG_RATE = 10;
    private boolean outputBufferEmpty = true;
    private final boolean checkBuffer = true;
    char EDC_OPS = (char)79;
    char EDC_PROG = (char)80;
    private DataOutputStream pout = null;
    private DataInputStream pin = null;
    private DataOutputStream outpipe = null;
    private DataInputStream inpipe = null;
    private static final Logger log = LoggerFactory.getLogger(SimulatorAdapter.class);

    public SimulatorAdapter() {
        super(new EasyDccSystemConnectionMemo("E", "EasyDCC Simulator"));
        this.setManufacturer("Easy DCC");
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            ImmediatePipedOutputStream tempPipeI = new ImmediatePipedOutputStream();
            this.pout = new DataOutputStream(tempPipeI);
            this.inpipe = new DataInputStream(new PipedInputStream(tempPipeI));
            ImmediatePipedOutputStream tempPipeO = new ImmediatePipedOutputStream();
            this.outpipe = new DataOutputStream(tempPipeO);
            this.pin = new DataInputStream(new PipedInputStream(tempPipeO));
        }
        catch (IOException e) {
            log.error("init (pipe): Exception: {}", (Object)e.toString());
        }
        this.opened = true;
        return null;
    }

    public synchronized void setOutputBufferEmpty(boolean s) {
        this.outputBufferEmpty = s;
    }

    public boolean okToSend() {
        log.debug("Buffer Empty: {}", (Object)this.outputBufferEmpty);
        return this.outputBufferEmpty;
    }

    @Override
    public void configure() {
        log.debug("set tc for memo {}", (Object)this.getSystemConnectionMemo().getUserName());
        this.getSystemConnectionMemo().getTrafficController().connectPort(this);
        this.getSystemConnectionMemo().configureManagers();
        this.sourceThread = new Thread(this);
        this.sourceThread.setName("EasyDCC Simulator");
        this.sourceThread.setPriority(1);
        this.sourceThread.start();
    }

    @Override
    public void connect() throws IOException {
        log.debug("connect called");
        super.connect();
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened || this.pin == null) {
            log.error("getInputStream called before load(), stream not available");
        }
        log.debug("DataInputStream pin returned");
        return this.pin;
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened || this.pout == null) {
            log.error("getOutputStream called before load(), stream not available");
        }
        log.debug("DataOutputStream pout returned");
        return this.pout;
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        log.debug("validBaudRates should not have been invoked");
        return new String[0];
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[0];
    }

    @Override
    public String getCurrentBaudRate() {
        return "";
    }

    @Override
    public String getCurrentPortName() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.info("EasyDCC Simulator Started");
        while (true) {
            int i;
            StringBuilder buf;
            try {
                SimulatorAdapter simulatorAdapter = this;
                synchronized (simulatorAdapter) {
                    this.wait(50L);
                }
            }
            catch (InterruptedException interruptedException) {
                log.debug("interrupted, ending");
                return;
            }
            EasyDccMessage m = this.readMessage();
            if (log.isDebugEnabled()) {
                buf = new StringBuilder();
                buf.append("EasyDCC Simulator Thread received message: ");
                if (m != null) {
                    i = 0;
                    while (i < m.getNumDataElements()) {
                        buf.append(Integer.toHexString(0xFF & m.getElement(i))).append(" ");
                        ++i;
                    }
                } else {
                    buf.append("null message buffer");
                }
                log.trace(buf.toString());
            }
            if (m == null) continue;
            EasyDccReply r = this.generateReply(m);
            this.writeReply(r);
            if (!log.isDebugEnabled()) continue;
            buf = new StringBuilder();
            buf.append("EasyDCC Simulator Thread sent reply: ");
            i = 0;
            while (i < r.getNumDataElements()) {
                buf.append(Integer.toHexString(0xFF & r.getElement(i))).append(" ");
                ++i;
            }
            log.debug(buf.toString());
        }
    }

    private EasyDccMessage readMessage() {
        EasyDccMessage msg = null;
        try {
            if (this.inpipe != null && this.inpipe.available() > 0) {
                msg = this.loadChars();
            }
        }
        catch (IOException iOException) {}
        this.setOutputBufferEmpty(true);
        return msg;
    }

    private EasyDccReply generateReply(EasyDccMessage msg) {
        log.debug("Generate Reply to message type {} (string = {})", (Object)Character.valueOf(msg.toString().charAt(0)), (Object)msg.toString());
        EasyDccReply reply = new EasyDccReply();
        int i = 0;
        char command = msg.toString().charAt(0);
        log.debug("Message type = {}", (Object)Character.valueOf(command));
        switch (command) {
            case 'C': 
            case 'D': 
            case 'F': 
            case 'Q': 
            case 'S': 
            case 'X': {
                reply.setElement(i++, this.EDC_OPS);
                break;
            }
            case 'M': 
            case 'P': {
                reply.setElement(i++, this.EDC_PROG);
                break;
            }
            case 'E': {
                log.debug("TRACK_POWER_ON detected");
                reply.setElement(i++, this.EDC_OPS);
                break;
            }
            case 'K': {
                log.debug("TRACK_POWER_OFF detected");
                reply.setElement(i++, this.EDC_OPS);
                break;
            }
            case 'V': {
                log.debug("Read_CS_Version detected");
                String replyString = "V999 01 01 1999";
                reply = new EasyDccReply(replyString);
                i = replyString.length();
                break;
            }
            case 'G': {
                log.debug("Consist detected");
                if (msg.toString().charAt(0) == 'D') {
                    String replyString = "G" + msg.getElement(2) + msg.getElement(3) + "0000";
                    reply = new EasyDccReply(replyString);
                    i = replyString.length();
                    break;
                }
                reply.setElement(i++, this.EDC_OPS);
                break;
            }
            case 'L': {
                log.debug("Read Loco detected");
                String replyString = "L" + msg.getElement(1) + msg.getElement(2) + msg.getElement(3) + msg.getElement(4) + "000000";
                reply = new EasyDccReply(replyString);
                i = replyString.length();
                break;
            }
            case 'R': {
                log.debug("Read_CV detected");
                String replyString = "--";
                reply = new EasyDccReply(replyString);
                i = replyString.length();
                break;
            }
            default: {
                log.debug("non-reply message detected");
                reply.setElement(i++, 63);
            }
        }
        log.debug("Reply generated = {}", (Object)reply.toString());
        reply.setElement(i++, 13);
        return reply;
    }

    private void writeReply(EasyDccReply r) {
        if (r == null) {
            return;
        }
        int i = 0;
        while (i < r.getNumDataElements()) {
            try {
                this.outpipe.writeByte((byte)r.getElement(i));
            }
            catch (IOException iOException) {}
            ++i;
        }
        try {
            this.outpipe.flush();
        }
        catch (IOException iOException) {}
    }

    private EasyDccMessage loadChars() throws IOException {
        byte[] rcvBuffer = new byte[32];
        int nchars = this.inpipe.read(rcvBuffer, 0, 32);
        EasyDccMessage msg = new EasyDccMessage(nchars);
        int i = 0;
        while (i < nchars) {
            msg.setElement(i, rcvBuffer[i] & 0xFF);
            ++i;
        }
        return msg;
    }
}

