/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.easydcc;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Manager;
import jmri.Turnout;
import jmri.jmrix.easydcc.Bundle;
import jmri.jmrix.easydcc.EasyDccListener;
import jmri.jmrix.easydcc.EasyDccMessage;
import jmri.jmrix.easydcc.EasyDccReply;
import jmri.jmrix.easydcc.EasyDccSystemConnectionMemo;
import jmri.jmrix.easydcc.EasyDccTrafficController;
import jmri.jmrix.easydcc.EasyDccTurnout;
import jmri.managers.AbstractTurnoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyDccTurnoutManager
extends AbstractTurnoutManager
implements EasyDccListener {
    private EasyDccTrafficController trafficController = null;
    public static final int MAX_ACC_DECODER_ADDRESS = 511;
    private static final Logger log = LoggerFactory.getLogger(EasyDccTurnoutManager.class);

    public EasyDccTurnoutManager(EasyDccSystemConnectionMemo memo) {
        super(memo);
        this.trafficController = memo.getTrafficController();
        this.trafficController.addEasyDccListener(this);
        log.debug("EasyDCC TurnoutManager prefix={}", (Object)this.getSystemPrefix());
    }

    @Override
    @Nonnull
    public EasyDccSystemConnectionMemo getMemo() {
        return (EasyDccSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int addr;
        try {
            addr = Integer.parseInt(systemName.substring(this.getSystemPrefix().length() + 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Could not create EasyDCC Turnout Systemname '" + systemName + "' .");
        }
        EasyDccTurnout t = new EasyDccTurnout(this.getSystemPrefix(), addr, this.getMemo());
        t.setUserName(userName);
        return t;
    }

    @Override
    public void message(EasyDccMessage m) {
        log.debug("message received unexpectedly: {}", (Object)m.toString());
    }

    @Override
    public void reply(EasyDccReply r) {
        log.debug("reply received unexpectedly: {}", (Object)r.toString());
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return this.getBitFromSystemName(systemName) != 0 ? Manager.NameValidity.VALID : Manager.NameValidity.INVALID;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String systemName, @Nonnull Locale locale) {
        return this.validateIntegerSystemNameFormat(systemName, 1, 511, locale);
    }

    public int getBitFromSystemName(String systemName) {
        try {
            this.validateSystemNameFormat(systemName, Locale.getDefault());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 0;
        }
        return Integer.parseInt(systemName.substring(this.getSystemNamePrefix().length()));
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }
}

