/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.easydcc;

import jmri.NmraPacket;
import jmri.implementation.AbstractTurnout;
import jmri.jmrix.easydcc.EasyDccMessage;
import jmri.jmrix.easydcc.EasyDccSystemConnectionMemo;
import jmri.jmrix.easydcc.EasyDccTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyDccTurnout
extends AbstractTurnout {
    int _number;
    private EasyDccTrafficController tc = null;
    protected String _prefix = "E";
    private static final Logger log = LoggerFactory.getLogger(EasyDccTurnout.class);

    public EasyDccTurnout(String prefix, int number, EasyDccSystemConnectionMemo memo) {
        super(String.valueOf(prefix) + "T" + number);
        this.tc = memo.getTrafficController();
        this._number = number;
        this._prefix = prefix;
    }

    public int getNumber() {
        return this._number;
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    @Override
    protected void forwardCommandChangeToLayout(int newState) {
        if ((newState & 2) != 0) {
            if ((newState & 4) != 0) {
                log.error("Cannot command both CLOSED and THROWN {}", (Object)newState);
            } else {
                this.sendMessage(true ^ this.getInverted());
            }
        } else {
            this.sendMessage(this.getInverted());
        }
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean _pushButtonLockout) {
        log.debug("Send command to {} Pushbutton {}T{}", new Object[]{_pushButtonLockout ? "Lock" : "Unlock", this._prefix, this._number});
    }

    protected void sendMessage(boolean closed) {
        byte[] bl = NmraPacket.accDecoderPkt(this._number, closed);
        if (log.isDebugEnabled()) {
            log.debug("packet: {} {} {}", new Object[]{Integer.toHexString(0xFF & bl[0]), Integer.toHexString(0xFF & bl[1]), Integer.toHexString(0xFF & bl[2])});
        }
        EasyDccMessage m = new EasyDccMessage(13);
        int i = 0;
        m.setElement(i++, 83);
        m.setElement(i++, 32);
        m.setElement(i++, 48);
        m.setElement(i++, 50);
        m.setElement(i++, 32);
        String s = Integer.toHexString(bl[0] & 0xFF).toUpperCase();
        if (s.length() == 1) {
            m.setElement(i++, 48);
            m.setElement(i++, s.charAt(0));
        } else {
            m.setElement(i++, s.charAt(0));
            m.setElement(i++, s.charAt(1));
        }
        s = Integer.toHexString(bl[1] & 0xFF).toUpperCase();
        m.setElement(i++, 32);
        if (s.length() == 1) {
            m.setElement(i++, 48);
            m.setElement(i++, s.charAt(0));
        } else {
            m.setElement(i++, s.charAt(0));
            m.setElement(i++, s.charAt(1));
        }
        s = Integer.toHexString(bl[2] & 0xFF).toUpperCase();
        m.setElement(i++, 32);
        if (s.length() == 1) {
            m.setElement(i++, 48);
            m.setElement(i++, s.charAt(0));
        } else {
            m.setElement(i++, s.charAt(0));
            m.setElement(i++, s.charAt(1));
        }
        log.debug("send easydcc message for turnout {}T{}", (Object)this._prefix, (Object)this._number);
        this.tc.sendEasyDccMessage(m, null);
    }
}

