/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.easydcc;

import java.util.EnumSet;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.LocoAddress;
import jmri.NmraPacket;
import jmri.SpeedStepMode;
import jmri.ThrottleListener;
import jmri.jmrix.AbstractThrottleManager;
import jmri.jmrix.easydcc.EasyDccMessage;
import jmri.jmrix.easydcc.EasyDccSystemConnectionMemo;
import jmri.jmrix.easydcc.EasyDccThrottle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyDccThrottleManager
extends AbstractThrottleManager {
    private EasyDccSystemConnectionMemo _memo = null;
    private static final Logger log = LoggerFactory.getLogger(EasyDccThrottleManager.class);

    public EasyDccThrottleManager(EasyDccSystemConnectionMemo memo) {
        super(memo);
        this._memo = memo;
    }

    @Override
    public void requestThrottleSetup(LocoAddress address, boolean control) {
        if (address instanceof DccLocoAddress) {
            log.debug("new EasyDccThrottle for {}", (Object)address);
            this.notifyThrottleKnown(new EasyDccThrottle(this._memo, (DccLocoAddress)address), address);
        } else {
            log.error("LocoAddress {} is not a DccLocoAddress", (Object)address);
            this.failedThrottleRequest(address, "LocoAddress " + address + " is not a DccLocoAddress");
        }
    }

    @Override
    public boolean hasDispatchFunction() {
        return false;
    }

    @Override
    public boolean canBeLongAddress(int address) {
        return EasyDccThrottleManager.isLongAddress(address);
    }

    @Override
    public boolean canBeShortAddress(int address) {
        return !EasyDccThrottleManager.isLongAddress(address);
    }

    @Override
    public boolean addressTypeUnique() {
        return true;
    }

    static boolean isLongAddress(int num) {
        return num >= 100;
    }

    @Override
    public EnumSet<SpeedStepMode> supportedSpeedModes() {
        return EnumSet.of(SpeedStepMode.NMRA_DCC_128, SpeedStepMode.NMRA_DCC_28);
    }

    @Override
    public boolean disposeThrottle(DccThrottle t, ThrottleListener l) {
        if (super.disposeThrottle(t, l)) {
            int value = 0;
            DccLocoAddress address = (DccLocoAddress)t.getLocoAddress();
            byte[] result = NmraPacket.speedStep128Packet(address.getNumber(), address.isLongAddress(), value, t.getIsForward());
            EasyDccMessage m = new EasyDccMessage(7);
            int i = 0;
            m.setElement(i++, 68);
            if (address.isLongAddress()) {
                m.setElement(i++, 32);
                m.addIntAsTwoHex(result[0] & 0xFF, i);
                i += 2;
                m.setElement(i++, 32);
                m.addIntAsTwoHex(result[1] & 0xFF, i);
            } else {
                m.setElement(i++, 32);
                m.addIntAsTwoHex(0, i);
                i += 2;
                m.setElement(i++, 32);
                m.addIntAsTwoHex(result[0] & 0xFF, i);
            }
            this._memo.getTrafficController().sendEasyDccMessage(m, null);
            if (t instanceof EasyDccThrottle) {
                EasyDccThrottle lnt = (EasyDccThrottle)t;
                lnt.throttleDispose();
                return true;
            }
            log.error("DccThrottle {} is not an EasyDccThrottle", (Object)t);
        }
        return false;
    }
}

