/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.easydcc;

import jmri.jmrix.AbstractMRReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyDccReply
extends AbstractMRReply {
    private static final Logger log = LoggerFactory.getLogger(EasyDccReply.class);

    public EasyDccReply() {
    }

    public EasyDccReply(String s) {
        super(s);
    }

    public EasyDccReply(EasyDccReply l) {
        super(l);
    }

    @Override
    protected int skipPrefix(int index) {
        while (index < this.getNumDataElements() - 1 && (char)this.getElement(index) <= ' ') {
            ++index;
        }
        return index;
    }

    @Override
    public int value() {
        int index = 0;
        if ((char)this.getElement(index) == 'C') {
            index = 5;
        } else if ((char)this.getElement(index) == 'V') {
            index = 2;
        } else {
            log.warn("Did not find recognizable format: {}", (Object)this.toString());
        }
        String s1 = "" + (char)this.getElement(index);
        String s2 = "" + (char)this.getElement(index + 1);
        int val = -1;
        try {
            int sum = Integer.valueOf(s2, 16);
            val = sum += 16 * Integer.valueOf(s1, 16);
        }
        catch (RuntimeException runtimeException) {
            log.error("Unable to get number from reply: \"{}{}\" index: {} message: \"{}\"", new Object[]{s1, s2, index, this.toString()});
        }
        return val;
    }
}

