/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.easydcc;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.AbstractProgrammer;
import jmri.jmrix.easydcc.EasyDccListener;
import jmri.jmrix.easydcc.EasyDccMessage;
import jmri.jmrix.easydcc.EasyDccReply;
import jmri.jmrix.easydcc.EasyDccSystemConnectionMemo;
import jmri.jmrix.easydcc.EasyDccTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyDccProgrammer
extends AbstractProgrammer
implements EasyDccListener {
    protected EasyDccTrafficController tc = null;
    int progState = 0;
    static final int NOTPROGRAMMING = 0;
    static final int COMMANDSENT = 2;
    boolean _progRead = false;
    int _val;
    int _cv;
    private ProgListener _usingProgrammer = null;
    private static final Logger log = LoggerFactory.getLogger(EasyDccProgrammer.class);

    public EasyDccProgrammer(EasyDccSystemConnectionMemo memo) {
        this.tc = memo.getTrafficController();
        this.LONG_TIMEOUT = 180000;
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(ProgrammingMode.PAGEMODE);
        ret.add(ProgrammingMode.REGISTERMODE);
        return ret;
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        if (log.isDebugEnabled()) {
            log.debug("writeCV {} listens {}", (Object)CV, (Object)p);
        }
        this.useProgrammer(p);
        this._progRead = false;
        this.progState = 2;
        this._val = val;
        this._cv = CV;
        try {
            this.startLongTimer();
            this.tc.sendEasyDccMessage(this.progTaskStart(this.getMode(), this._val, this._cv), this);
        }
        catch (ProgrammerException e) {
            this.progState = 0;
            throw e;
        }
    }

    @Override
    public synchronized void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        this.readCV(CV, p);
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        if (log.isDebugEnabled()) {
            log.debug("readCV {} listens {}", (Object)CV, (Object)p);
        }
        this.useProgrammer(p);
        this._progRead = true;
        this.progState = 2;
        this._cv = CV;
        try {
            this.startLongTimer();
            this.tc.sendEasyDccMessage(this.progTaskStart(this.getMode(), -1, this._cv), this);
        }
        catch (ProgrammerException e) {
            this.progState = 0;
            throw e;
        }
    }

    protected void useProgrammer(ProgListener p) throws ProgrammerException {
        if (this._usingProgrammer != null && this._usingProgrammer != p) {
            if (log.isDebugEnabled()) {
                log.debug("programmer already in use by {}", (Object)this._usingProgrammer);
            }
            throw new ProgrammerException("programmer in use");
        }
        this._usingProgrammer = p;
    }

    protected EasyDccMessage progTaskStart(ProgrammingMode mode, int val, int cvnum) throws ProgrammerException {
        if (val < 0) {
            if (this.getMode().equals(ProgrammingMode.PAGEMODE)) {
                return EasyDccMessage.getReadPagedCV(cvnum);
            }
            return EasyDccMessage.getReadRegister(this.registerFromCV(cvnum));
        }
        if (this.getMode().equals(ProgrammingMode.PAGEMODE)) {
            return EasyDccMessage.getWritePagedCV(cvnum, val);
        }
        return EasyDccMessage.getWriteRegister(this.registerFromCV(cvnum), val);
    }

    @Override
    public void message(EasyDccMessage m) {
        log.error("message received unexpectedly: {}", (Object)m.toString());
    }

    @Override
    public synchronized void reply(EasyDccReply m) {
        if (this.progState == 0) {
            if (log.isDebugEnabled()) {
                log.debug("reply in NOTPROGRAMMING state");
            }
            return;
        }
        if (this.progState == 2) {
            if (log.isDebugEnabled()) {
                log.debug("reply in COMMANDSENT state");
            }
            this.progState = 0;
            if (m.match("--") >= 0) {
                if (log.isDebugEnabled()) {
                    log.debug("handle error reply {}", (Object)m);
                }
                this.notifyProgListenerEnd(-1, 2);
            } else {
                if (this._progRead) {
                    this._val = m.value();
                }
                this.notifyProgListenerEnd(this._val, 0);
            }
        }
    }

    @Override
    protected synchronized void timeout() {
        if (this.progState != 0) {
            if (log.isDebugEnabled()) {
                log.debug("timeout!");
            }
            this.progState = 0;
            this.cleanup();
            this.notifyProgListenerEnd(this._val, 128);
        }
    }

    void cleanup() {
        this.tc.sendEasyDccMessage(EasyDccMessage.getExitProgMode(), this);
    }

    protected void notifyProgListenerEnd(int value, int status) {
        if (log.isDebugEnabled()) {
            log.debug("notifyProgListenerEnd value {} status {}", (Object)value, (Object)status);
        }
        ProgListener temp = this._usingProgrammer;
        this._usingProgrammer = null;
        this.notifyProgListenerEnd(temp, value, status);
    }
}

