/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.easydcc;

import jmri.JmriException;
import jmri.jmrix.easydcc.EasyDccListener;
import jmri.jmrix.easydcc.EasyDccMessage;
import jmri.jmrix.easydcc.EasyDccReply;
import jmri.jmrix.easydcc.EasyDccSystemConnectionMemo;
import jmri.jmrix.easydcc.EasyDccTrafficController;
import jmri.managers.AbstractPowerManager;

public class EasyDccPowerManager
extends AbstractPowerManager<EasyDccSystemConnectionMemo>
implements EasyDccListener {
    private EasyDccTrafficController trafficController = null;
    boolean waiting = false;
    int onReply = 1;

    public EasyDccPowerManager(EasyDccSystemConnectionMemo memo) {
        super(memo);
        this.trafficController = memo.getTrafficController();
        this.trafficController.addEasyDccListener(this);
    }

    @Override
    public void setPower(int v) throws JmriException {
        int old = this.power;
        this.power = 1;
        this.checkTC();
        if (v == 2) {
            this.waiting = true;
            this.onReply = 2;
            EasyDccMessage l = EasyDccMessage.getEnableMain();
            this.trafficController.sendEasyDccMessage(l, this);
        } else if (v == 4) {
            this.waiting = true;
            this.onReply = 4;
            EasyDccMessage l = EasyDccMessage.getKillMain();
            this.trafficController.sendEasyDccMessage(l, this);
        }
        this.firePowerPropertyChange(old, this.power);
    }

    @Override
    public void dispose() throws JmriException {
        this.trafficController.removeEasyDccListener(this);
        this.trafficController = null;
    }

    private void checkTC() throws JmriException {
        if (this.trafficController == null) {
            throw new JmriException("attempt to use EasyDccPowerManager after dispose");
        }
    }

    @Override
    public void reply(EasyDccReply m) {
        int old = this.power;
        if (this.waiting) {
            this.power = this.onReply;
            this.firePowerPropertyChange(old, this.power);
        }
        this.waiting = false;
    }

    @Override
    public void message(EasyDccMessage m) {
        if (m.isKillMain()) {
            this.waiting = true;
            this.onReply = 4;
        } else if (m.isEnableMain()) {
            this.waiting = true;
            this.onReply = 2;
        }
    }
}

