/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.easydcc;

import jmri.DccLocoAddress;
import jmri.jmrix.AbstractMRMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyDccMessage
extends AbstractMRMessage {
    protected static final int LONG_TIMEOUT = 180000;
    private static final Logger log = LoggerFactory.getLogger(EasyDccMessage.class);

    public EasyDccMessage() {
    }

    public EasyDccMessage(int i) {
        super(i);
    }

    public EasyDccMessage(EasyDccMessage m) {
        super(m);
    }

    public EasyDccMessage(String s) {
        super(s);
    }

    public boolean isKillMain() {
        return this.getOpCode() == 75;
    }

    public boolean isEnableMain() {
        return this.getOpCode() == 69;
    }

    public static EasyDccMessage getEnableMain() {
        EasyDccMessage m = new EasyDccMessage(1);
        m.setBinary(false);
        m.setOpCode(69);
        return m;
    }

    public static EasyDccMessage getKillMain() {
        EasyDccMessage m = new EasyDccMessage(1);
        m.setBinary(false);
        m.setOpCode(75);
        return m;
    }

    public static EasyDccMessage getAddConsistNormal(int ConsistAddress, DccLocoAddress LocoAddress2) {
        EasyDccMessage m = new EasyDccMessage(10);
        m.setBinary(false);
        m.setOpCode(71);
        m.setElement(1, 78);
        m.setElement(2, 32);
        m.addIntAsTwoHex(ConsistAddress, 3);
        m.setElement(5, 32);
        m.addIntAsFourHex(LocoAddress2.getNumber(), 6);
        return m;
    }

    public static EasyDccMessage getAddConsistReverse(int ConsistAddress, DccLocoAddress LocoAddress2) {
        EasyDccMessage m = new EasyDccMessage(10);
        m.setBinary(false);
        m.setOpCode(71);
        m.setElement(1, 82);
        m.setElement(2, 32);
        m.addIntAsTwoHex(ConsistAddress, 3);
        m.setElement(5, 32);
        m.addIntAsFourHex(LocoAddress2.getNumber(), 6);
        return m;
    }

    public static EasyDccMessage getSubtractConsist(int ConsistAddress, DccLocoAddress LocoAddress2) {
        EasyDccMessage m = new EasyDccMessage(10);
        m.setBinary(false);
        m.setOpCode(71);
        m.setElement(1, 83);
        m.setElement(2, 32);
        m.addIntAsTwoHex(ConsistAddress, 3);
        m.setElement(5, 32);
        m.addIntAsFourHex(LocoAddress2.getNumber(), 6);
        return m;
    }

    public static EasyDccMessage getKillConsist(int ConsistAddress) {
        EasyDccMessage m = new EasyDccMessage(5);
        m.setBinary(false);
        m.setOpCode(71);
        m.setElement(1, 75);
        m.setElement(2, 32);
        m.addIntAsTwoHex(ConsistAddress, 3);
        return m;
    }

    public static EasyDccMessage getDisplayConsist(int ConsistAddress) {
        EasyDccMessage m = new EasyDccMessage(5);
        m.setBinary(false);
        m.setOpCode(71);
        m.setElement(1, 68);
        m.setElement(2, 32);
        m.addIntAsTwoHex(ConsistAddress, 3);
        return m;
    }

    public static EasyDccMessage getProgMode() {
        EasyDccMessage m = new EasyDccMessage(1);
        m.setBinary(false);
        m.setOpCode(77);
        return m;
    }

    public static EasyDccMessage getExitProgMode() {
        EasyDccMessage m = new EasyDccMessage(1);
        m.setBinary(false);
        m.setOpCode(88);
        return m;
    }

    public static EasyDccMessage getReadPagedCV(int cv) {
        EasyDccMessage m = new EasyDccMessage(5);
        m.setBinary(false);
        m.setNeededMode(4);
        m.setTimeout(180000);
        m.setOpCode(82);
        m.setElement(1, 32);
        m.addIntAsThreeHex(cv, 2);
        return m;
    }

    public static EasyDccMessage getWritePagedCV(int cv, int val) {
        EasyDccMessage m = new EasyDccMessage(8);
        m.setBinary(false);
        m.setNeededMode(4);
        m.setTimeout(180000);
        m.setOpCode(80);
        m.setElement(1, 32);
        m.addIntAsThreeHex(cv, 2);
        m.setElement(5, 32);
        m.addIntAsTwoHex(val, 6);
        return m;
    }

    public static EasyDccMessage getReadRegister(int reg) {
        if (reg > 8) {
            log.error("register number too large: {}", (Object)reg);
        }
        EasyDccMessage m = new EasyDccMessage(2);
        m.setBinary(false);
        m.setNeededMode(4);
        m.setTimeout(180000);
        m.setOpCode(86);
        String s = "" + reg;
        m.setElement(1, s.charAt(s.length() - 1));
        return m;
    }

    public static EasyDccMessage getWriteRegister(int reg, int val) {
        if (reg > 8) {
            log.error("register number too large: {}", (Object)reg);
        }
        EasyDccMessage m = new EasyDccMessage(5);
        m.setBinary(false);
        m.setNeededMode(4);
        m.setTimeout(180000);
        m.setOpCode(83);
        String s = "" + reg;
        m.setElement(1, s.charAt(s.length() - 1));
        m.setElement(2, 32);
        m.addIntAsTwoHex(val, 3);
        return m;
    }
}

