/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.easydcc;

import jmri.DccLocoAddress;
import jmri.NmraPacket;
import jmri.implementation.DccConsist;
import jmri.jmrix.easydcc.EasyDccListener;
import jmri.jmrix.easydcc.EasyDccMessage;
import jmri.jmrix.easydcc.EasyDccReply;
import jmri.jmrix.easydcc.EasyDccSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyDccConsist
extends DccConsist
implements EasyDccListener {
    private EasyDccSystemConnectionMemo _memo = null;
    private static final Logger log = LoggerFactory.getLogger(EasyDccConsist.class);

    public EasyDccConsist(int address, EasyDccSystemConnectionMemo memo) {
        super(address);
        this._memo = memo;
    }

    public EasyDccConsist(DccLocoAddress address, EasyDccSystemConnectionMemo memo) {
        super(address);
        this._memo = memo;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void setConsistType(int consist_type) {
        if (consist_type == 0) {
            this.consistType = consist_type;
            return;
        }
        if (consist_type == 1) {
            this.consistType = consist_type;
        } else {
            log.error("Consist Type Not Supported");
            this.notifyConsistListeners(new DccLocoAddress(0, false), 1);
        }
    }

    @Override
    public boolean isAddressAllowed(DccLocoAddress address) {
        return address.getNumber() != 0;
    }

    @Override
    public int sizeLimit() {
        if (this.consistType == 0) {
            return -1;
        }
        if (this.consistType == 1) {
            return 8;
        }
        return 0;
    }

    @Override
    public boolean contains(DccLocoAddress address) {
        if (this.consistType == 0 || this.consistType == 1) {
            return this.consistList.contains(address);
        }
        log.error("Consist Type Not Supported");
        this.notifyConsistListeners(address, 1);
        return false;
    }

    @Override
    public boolean getLocoDirection(DccLocoAddress address) {
        if (this.consistType == 0 || this.consistType == 1) {
            Boolean Direction2 = (Boolean)this.consistDir.get(address);
            return Direction2;
        }
        log.error("Consist Type Not Supported");
        this.notifyConsistListeners(address, 1);
        return false;
    }

    private synchronized void addToConsistList(DccLocoAddress LocoAddress2, boolean directionNormal) {
        Boolean Direction2 = directionNormal;
        if (!this.consistList.contains(LocoAddress2)) {
            this.consistList.add(LocoAddress2);
        }
        this.consistDir.put(LocoAddress2, Direction2);
        if (this.consistType == 1 && this.consistList.size() == 8) {
            this.notifyConsistListeners(LocoAddress2, 10);
        } else {
            this.notifyConsistListeners(LocoAddress2, 2);
        }
    }

    private synchronized void removeFromConsistList(DccLocoAddress LocoAddress2) {
        this.consistDir.remove(LocoAddress2);
        this.consistList.remove(LocoAddress2);
        this.notifyConsistListeners(LocoAddress2, 2);
    }

    @Override
    public synchronized void add(DccLocoAddress LocoAddress2, boolean directionNormal) {
        if (this.consistType == 0) {
            this.addToConsistList(LocoAddress2, directionNormal);
            this.addToAdvancedConsist(LocoAddress2, directionNormal);
            this.setRosterEntryCVValue(LocoAddress2);
        } else if (this.consistType == 1) {
            if (this.consistList.size() < 8) {
                this.addToConsistList(LocoAddress2, directionNormal);
                this.addToCSConsist(LocoAddress2, directionNormal);
            } else {
                this.notifyConsistListeners(LocoAddress2, 12);
            }
        } else {
            log.error("Consist Type Not Supported");
            this.notifyConsistListeners(LocoAddress2, 1);
        }
    }

    @Override
    public synchronized void restore(DccLocoAddress LocoAddress2, boolean directionNormal) {
        if (this.consistType == 0) {
            this.addToConsistList(LocoAddress2, directionNormal);
        } else if (this.consistType == 1) {
            this.addToConsistList(LocoAddress2, directionNormal);
        } else {
            log.error("Consist Type Not Supported");
            this.notifyConsistListeners(LocoAddress2, 1);
        }
    }

    @Override
    public synchronized void remove(DccLocoAddress LocoAddress2) {
        if (this.consistType == 0) {
            this.resetRosterEntryCVValue(LocoAddress2);
            this.removeFromAdvancedConsist(LocoAddress2);
            this.removeFromConsistList(LocoAddress2);
        } else if (this.consistType == 1) {
            this.removeFromCSConsist(LocoAddress2);
            this.removeFromConsistList(LocoAddress2);
        } else {
            log.error("Consist Type Not Supported");
            this.notifyConsistListeners(LocoAddress2, 1);
        }
    }

    @Override
    protected synchronized void addToAdvancedConsist(DccLocoAddress LocoAddress2, boolean directionNormal) {
        if (log.isDebugEnabled()) {
            log.debug("Add Locomotive {} to advanced consist {} With Direction Normal {}.", new Object[]{LocoAddress2.toString(), this.consistAddress.toString(), directionNormal});
        }
        byte[] contents = NmraPacket.consistControl(LocoAddress2.getNumber(), LocoAddress2.isLongAddress(), this.consistAddress.getNumber(), directionNormal);
        EasyDccMessage msg = new EasyDccMessage(4 + 3 * contents.length);
        msg.setOpCode(83);
        msg.setElement(1, 32);
        msg.setElement(2, 48);
        msg.setElement(3, 53);
        int j = 4;
        int i = 0;
        while (i < contents.length) {
            msg.setElement(j++, 32);
            msg.addIntAsTwoHex(contents[i] & 0xFF, j);
            j += 2;
            ++i;
        }
        this._memo.getTrafficController().sendEasyDccMessage(msg, this);
    }

    @Override
    protected synchronized void removeFromAdvancedConsist(DccLocoAddress LocoAddress2) {
        if (log.isDebugEnabled()) {
            log.debug(" Remove Locomotive {} from advanced consist {}", (Object)LocoAddress2.toString(), (Object)this.consistAddress.toString());
        }
        byte[] contents = NmraPacket.consistControl(LocoAddress2.getNumber(), LocoAddress2.isLongAddress(), 0, true);
        EasyDccMessage msg = new EasyDccMessage(4 + 3 * contents.length);
        msg.setOpCode(83);
        msg.setElement(1, 32);
        msg.setElement(2, 48);
        msg.setElement(3, 53);
        int j = 4;
        int i = 0;
        while (i < contents.length) {
            msg.setElement(j++, 32);
            msg.addIntAsTwoHex(contents[i] & 0xFF, j);
            j += 2;
            ++i;
        }
        this._memo.getTrafficController().sendEasyDccMessage(msg, this);
    }

    private synchronized void addToCSConsist(DccLocoAddress LocoAddress2, boolean directionNormal) {
        if (log.isDebugEnabled()) {
            log.debug("Add Locomotive {} to Standard Consist {} With Direction Normal {}.", new Object[]{LocoAddress2.toString(), this.consistAddress.toString(), directionNormal});
        }
        EasyDccMessage m = directionNormal ? EasyDccMessage.getAddConsistNormal(this.consistAddress.getNumber(), LocoAddress2) : EasyDccMessage.getAddConsistReverse(this.consistAddress.getNumber(), LocoAddress2);
        this._memo.getTrafficController().sendEasyDccMessage(m, this);
    }

    public synchronized void removeFromCSConsist(DccLocoAddress LocoAddress2) {
        if (log.isDebugEnabled()) {
            log.debug("Remove Locomotive {} from Standard Consist {}.", (Object)LocoAddress2.toString(), (Object)this.consistAddress.toString());
        }
        EasyDccMessage m = EasyDccMessage.getSubtractConsist(this.consistAddress.getNumber(), LocoAddress2);
        this._memo.getTrafficController().sendEasyDccMessage(m, this);
    }

    @Override
    public void message(EasyDccMessage m) {
        log.error("message received unexpectedly: {}", (Object)m.toString());
    }

    @Override
    public void reply(EasyDccReply r) {
        if (log.isDebugEnabled()) {
            log.debug("reply received unexpectedly: {}", (Object)r.toString());
        }
    }
}

