/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.easydcc;

import jmri.CommandStation;
import jmri.jmrix.easydcc.EasyDccMessage;
import jmri.jmrix.easydcc.EasyDccSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyDccCommandStation
implements CommandStation {
    EasyDccSystemConnectionMemo memo = null;
    private static final Logger log = LoggerFactory.getLogger(EasyDccCommandStation.class);

    public EasyDccCommandStation(EasyDccSystemConnectionMemo memo) {
        this.memo = memo;
    }

    @Override
    public boolean sendPacket(byte[] packet, int repeats) {
        if (repeats > 9) {
            repeats = 9;
        }
        if (repeats < 0) {
            log.error("repeat count out of range: {}", (Object)repeats);
            repeats = 1;
        }
        EasyDccMessage m = new EasyDccMessage(4 + 3 * packet.length);
        int i = 0;
        m.setElement(i++, 83);
        m.setElement(i++, 32);
        m.setElement(i++, 48);
        m.setElement(i++, 48 + repeats);
        int j = 0;
        while (j < packet.length) {
            m.setElement(i++, 32);
            String s = Integer.toHexString(packet[j] & 0xFF).toUpperCase();
            if (s.length() == 1) {
                m.setElement(i++, 48);
                m.setElement(i++, s.charAt(0));
            } else {
                m.setElement(i++, s.charAt(0));
                m.setElement(i++, s.charAt(1));
            }
            ++j;
        }
        this.memo.getTrafficController().sendEasyDccMessage(m, null);
        return true;
    }

    @Override
    public String getUserName() {
        if (this.memo == null) {
            return "EasyDCC";
        }
        return this.memo.getUserName();
    }

    @Override
    public String getSystemPrefix() {
        if (this.memo == null) {
            return "E";
        }
        return this.memo.getSystemPrefix();
    }
}

