/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.direct.serial;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JOptionPane;
import jmri.jmrix.direct.DirectSystemConnectionMemo;
import jmri.jmrix.direct.PortController;
import jmri.jmrix.direct.TrafficController;
import jmri.jmrix.direct.serial.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class SerialDriverAdapter
extends PortController {
    Vector<String> portNameVector = null;
    SerialPort activeSerialPort = null;
    private boolean opened = false;
    InputStream serialInStream = null;
    OutputStream serialOutStream = null;
    private static final Logger log = LoggerFactory.getLogger(SerialDriverAdapter.class);

    @Override
    public Vector<String> getPortNames() {
        this.portNameVector = new Vector();
        Enumeration<CommPortIdentifier> portIDs = CommPortIdentifier.getPortIdentifiers();
        while (portIDs.hasMoreElements()) {
            CommPortIdentifier id = portIDs.nextElement();
            if (id.getPortType() == 2) continue;
            this.portNameVector.addElement(id.getName());
        }
        return this.portNameVector;
    }

    @Override
    @SuppressFBWarnings(value={"SR_NOT_CHECKED"}, justification="this is for skip-chars while loop: no matter how many, we're skipping")
    public String openPort(String portName, String appName) {
        try {
            CommPortIdentifier portID = CommPortIdentifier.getPortIdentifier(portName);
            try {
                this.activeSerialPort = (SerialPort)portID.open(appName, 2000);
            }
            catch (PortInUseException p) {
                return this.handlePortBusy(p, portName, log);
            }
            try {
                this.activeSerialPort.setSerialPortParams(17240, 8, 1, 0);
            }
            catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                log.warn("attempting to fall back to 16457 baud after 17240 failed");
                try {
                    this.activeSerialPort.setSerialPortParams(16457, 8, 1, 0);
                }
                catch (UnsupportedCommOperationException unsupportedCommOperationException2) {
                    log.warn("trouble setting 16457 baud");
                    this.activeSerialPort.setSerialPortParams(19200, 8, 1, 0);
                    JOptionPane.showMessageDialog(null, Bundle.getMessage("DirectBaudError", this.activeSerialPort.getBaudRate()), Bundle.getMessage("ErrorConnectionTitle"), 0);
                }
            }
            this.configureLeadsAndFlowControl(this.activeSerialPort, 0);
            log.debug("Serial timeout was observed as: {} {}", (Object)this.activeSerialPort.getReceiveTimeout(), (Object)this.activeSerialPort.isReceiveTimeoutEnabled());
            this.serialInStream = this.activeSerialPort.getInputStream();
            this.serialOutStream = this.activeSerialPort.getOutputStream();
            int count = this.serialInStream.available();
            log.debug("input stream shows {} bytes available", (Object)count);
            while (count > 0) {
                this.serialInStream.skip(count);
                count = this.serialInStream.available();
            }
            if (log.isInfoEnabled()) {
                log.info("{} port opened at {} baud, sees  DTR: {} RTS: {} DSR: {} CTS: {}  CD: {}", new Object[]{portName, this.activeSerialPort.getBaudRate(), this.activeSerialPort.isDTR(), this.activeSerialPort.isRTS(), this.activeSerialPort.isDSR(), this.activeSerialPort.isCTS(), this.activeSerialPort.isCD()});
            }
        }
        catch (NoSuchPortException p) {
            return this.handlePortNotFound(p, portName, log);
        }
        catch (IOException | UnsupportedCommOperationException ex) {
            log.error("Unexpected exception while opening port {}", (Object)portName, (Object)ex);
            return "Unexpected error while opening port " + portName + ": " + ex;
        }
        return null;
    }

    @Override
    public void configure() {
        TrafficController tc = new TrafficController((DirectSystemConnectionMemo)this.getSystemConnectionMemo());
        ((DirectSystemConnectionMemo)this.getSystemConnectionMemo()).setTrafficController(tc);
        tc.connectPort(this);
        ((DirectSystemConnectionMemo)this.getSystemConnectionMemo()).configureManagers();
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened) {
            log.error("getInputStream called before load(), stream not available");
            return null;
        }
        return new DataInputStream(this.serialInStream);
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened) {
            log.error("getOutputStream called before load(), stream not available");
        }
        return new DataOutputStream(this.serialOutStream);
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return new String[]{Bundle.getMessage("Baud19200")};
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[]{19200};
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }
}

