/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.direct;

import jmri.CommandStation;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.ThrottleListener;
import jmri.jmrix.AbstractThrottleManager;
import jmri.jmrix.direct.DirectSystemConnectionMemo;
import jmri.jmrix.direct.Throttle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottleManager
extends AbstractThrottleManager {
    private CommandStation tc;
    Throttle currentThrottle = null;
    private static final Logger log = LoggerFactory.getLogger(ThrottleManager.class);

    public ThrottleManager(DirectSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getTrafficController();
        InstanceManager.setDefault(ThrottleManager.class, this);
    }

    @Override
    public void requestThrottleSetup(LocoAddress address, boolean control) {
        if (this.currentThrottle != null) {
            log.error("DCC Direct cannot handle more than one throttle {}", (Object)address);
            this.failedThrottleRequest(address, "DCC direct cannot handle more than one throttle " + address);
            return;
        }
        if (address instanceof DccLocoAddress) {
            this.currentThrottle = new Throttle((DccLocoAddress)address, this.tc);
            this.notifyThrottleKnown(this.currentThrottle, this.currentThrottle.getLocoAddress());
        } else {
            log.error("LocoAddress {} is not a DccLocoAddress", (Object)address);
            this.failedThrottleRequest(address, "LocoAddress is not a DccLocoAddress " + address);
        }
    }

    @Override
    public boolean addressTypeUnique() {
        return false;
    }

    @Override
    public boolean canBeShortAddress(int a) {
        return a < 128;
    }

    @Override
    public boolean canBeLongAddress(int a) {
        return a > 0;
    }

    @Override
    public boolean disposeThrottle(DccThrottle t, ThrottleListener l) {
        if (super.disposeThrottle(t, l)) {
            this.currentThrottle = null;
            return true;
        }
        return false;
    }
}

