/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.direct;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nonnull;
import jmri.ProgrammingMode;
import jmri.jmrix.AbstractMRMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Message
extends AbstractMRMessage {
    private static final Logger log = LoggerFactory.getLogger(Message.class);

    public Message(int i) {
        if (i < 1) {
            log.error("invalid length in call to ctor");
        }
        this._nDataChars = i;
        this._dataChars = new int[i];
    }

    public Message(@Nonnull Message m) {
        this._nDataChars = m._nDataChars;
        this._dataChars = new int[this._nDataChars];
        System.arraycopy(m._dataChars, 0, this._dataChars, 0, this._nDataChars);
    }

    @Override
    public void setOpCode(int i) {
        this._dataChars[0] = i;
    }

    @Override
    public int getOpCode() {
        return this._dataChars[0];
    }

    @Override
    public String getOpCodeHex() {
        return "0x" + Integer.toHexString(this.getOpCode());
    }

    @Override
    public int getNumDataElements() {
        return this._nDataChars;
    }

    @Override
    public int getElement(int n) {
        return this._dataChars[n];
    }

    @Override
    public void setElement(int n, int v) {
        this._dataChars[n] = v & 0x7F;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("");
        int i = 0;
        while (i < this._nDataChars) {
            s.append((char)this._dataChars[i]);
            ++i;
        }
        return s.toString();
    }

    public boolean isKillMain() {
        return this.getOpCode() == 45;
    }

    public boolean isEnableMain() {
        return this.getOpCode() == 43;
    }

    public static Message getEnableMain() {
        log.error("getEnableMain doesn't have a reasonable implementation yet");
        return null;
    }

    public static Message getKillMain() {
        log.error("getKillMain doesn't have a reasonable implementation yet");
        return null;
    }

    public static Message getProgMode() {
        log.error("getProgMode doesn't have a reasonable implementation yet");
        return null;
    }

    public static Message getExitProgMode() {
        log.error("getExitProgMode doesn't have a reasonable implementation yet");
        return null;
    }

    public static Message getReadCV(int cv, ProgrammingMode mode) {
        Message m = new Message(5);
        if (mode.equals(ProgrammingMode.PAGEMODE)) {
            m.setOpCode(86);
        } else {
            m.setOpCode(67);
        }
        Message.addSpace(m, 1);
        Message.addIntAsThree(cv, m, 2);
        return m;
    }

    public static Message getWriteCV(int cv, int val, ProgrammingMode mode) {
        Message m = new Message(9);
        if (mode.equals(ProgrammingMode.PAGEMODE)) {
            m.setOpCode(86);
        } else {
            m.setOpCode(67);
        }
        Message.addSpace(m, 1);
        Message.addIntAsThree(cv, m, 2);
        Message.addSpace(m, 5);
        Message.addIntAsThree(val, m, 6);
        return m;
    }

    public static Message getReadRegister(int reg) {
        return null;
    }

    public static Message getWriteRegister(int reg, int val) {
        return null;
    }

    private static String addSpace(Message m, int offset) {
        String s = " ";
        m.setElement(offset, 32);
        return s;
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="was previously marked with @SuppressWarnings, reason unknown")
    private static String addIntAsTwo(int val, Message m, int offset) {
        String s = "" + val;
        if (s.length() != 2) {
            s = "0" + s;
        }
        m.setElement(offset, s.charAt(0));
        m.setElement(offset + 1, s.charAt(1));
        return s;
    }

    private static String addIntAsThree(int val, Message m, int offset) {
        String s = "" + val;
        if (s.length() != 3) {
            s = "0" + s;
        }
        if (s.length() != 3) {
            s = "0" + s;
        }
        m.setElement(offset, s.charAt(0));
        m.setElement(offset + 1, s.charAt(1));
        m.setElement(offset + 2, s.charAt(2));
        return s;
    }

    public int getAddr() {
        return this.getElement(0) & 0x7F;
    }
}

