/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.direct;

public class MakePacket {
    private static int preambleLength = 15;
    private static final int BITSTREAM_BITS_PER_BYTE = 9;
    private static final int BITS_0 = 240;
    private static final int BITS_00 = 198;
    private static final int BITS_01 = 120;
    private static final int BITS_10 = 225;
    private static final int BITS_001 = 102;
    private static final int BITS_010 = 150;
    private static final int BITS_011 = 92;
    private static final int BITS_100 = 153;
    private static final int BITS_101 = 113;
    private static final int BITS_110 = 197;
    private static final int BITS_0111 = 86;
    private static final int BITS_1011 = 89;
    private static final int BITS_1101 = 101;
    private static final int BITS_1110 = 149;
    private static final int BITS_11111 = 85;

    public static boolean setPreambleLength(int preambleLen) {
        if (preambleLen <= 0) {
            return false;
        }
        if (preambleLen % 5 != 0) {
            return false;
        }
        preambleLength = preambleLen;
        return true;
    }

    public static int[] createStream(byte[] packet) {
        int i = 0;
        int mask = 128;
        int[] bitStream = new int[packet.length * 9 + preambleLength + 1];
        int bitStreamIndex = 0;
        bitStreamIndex = 0;
        while (bitStreamIndex < preambleLength) {
            bitStream[bitStreamIndex] = 1;
            ++bitStreamIndex;
        }
        bitStream[bitStreamIndex++] = 0;
        i = 0;
        while (i < packet.length) {
            mask = 128;
            while (mask > 0) {
                bitStream[bitStreamIndex++] = (packet[i] & mask) != 0 ? 1 : 0;
                mask >>= 1;
            }
            bitStream[bitStreamIndex++] = 0;
            ++i;
        }
        bitStream[--bitStreamIndex] = 1;
        return MakePacket.bitStreamToSerialBytes(bitStream);
    }

    /*
     * Unable to fully structure code
     */
    static int[] bitStreamToSerialBytes(int[] inputBitStream) {
        treeIndex = -1;
        serialStream = new int[inputBitStream.length];
        tree = new Node[150];
        currentBufferIndex = 0;
        while (currentBufferIndex < tree.length) {
            tree[currentBufferIndex] = new Node();
            tree[currentBufferIndex].bitPattern = 0;
            tree[currentBufferIndex].patternLength = 0;
            ++currentBufferIndex;
        }
        currentBufferIndex = 0;
        treeIndex = 1;
        block1: while (currentBufferIndex < inputBitStream.length) {
            if (MakePacket.readFirstChild(inputBitStream, currentBufferIndex, inputBitStream.length - currentBufferIndex, tree[treeIndex])) {
                serialStream[treeIndex] = tree[treeIndex].bitPattern;
                currentBufferIndex += tree[treeIndex++].patternLength;
                continue;
            }
            if (currentBufferIndex + 4 <= inputBitStream.length) ** GOTO lbl30
            serialStream[treeIndex] = 85;
            currentBufferIndex = inputBitStream.length;
            continue;
lbl-1000:
            // 1 sources

            {
                currentBufferIndex -= tree[--treeIndex].patternLength;
                if (MakePacket.readNextChild(tree[treeIndex])) {
                    serialStream[treeIndex] = tree[treeIndex].bitPattern;
                    currentBufferIndex += tree[treeIndex++].patternLength;
                    continue block1;
                }
                if (treeIndex != 0) continue;
                serialStream[0] = 0;
                return serialStream;
lbl30:
                // 2 sources

                ** while (treeIndex > 0)
            }
lbl31:
            // 1 sources

        }
        serialStream[0] = --treeIndex;
        return serialStream;
    }

    static boolean readNextChild(Node thisNode) {
        switch (thisNode.bitPattern) {
            case 120: 
            case 198: {
                thisNode.bitPattern = 240;
                thisNode.patternLength = 1;
                break;
            }
            case 102: {
                thisNode.bitPattern = 198;
                thisNode.patternLength = 2;
                break;
            }
            case 92: 
            case 150: {
                thisNode.bitPattern = 120;
                thisNode.patternLength = 2;
                break;
            }
            case 153: {
                thisNode.bitPattern = 225;
                thisNode.patternLength = 2;
                break;
            }
            case 86: {
                thisNode.bitPattern = 92;
                thisNode.patternLength = 3;
                break;
            }
            case 89: {
                thisNode.bitPattern = 113;
                thisNode.patternLength = 3;
                break;
            }
            case 101: {
                thisNode.bitPattern = 197;
                thisNode.patternLength = 3;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    static boolean readFirstChild(int[] bs, int offset, int validBits, Node thisNode) {
        boolean b0 = false;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        boolean b4 = false;
        thisNode.patternLength = 0;
        switch (validBits) {
            default: {
                thisNode.patternLength = 5;
                b0 = bs[0 + offset] != 0;
                b1 = bs[1 + offset] != 0;
                b2 = bs[2 + offset] != 0;
                b3 = bs[3 + offset] != 0;
                boolean bl = b4 = bs[4 + offset] != 0;
                if (b0 && b1 && b2 && b3 && b4) {
                    thisNode.bitPattern = 85;
                    break;
                }
            }
            case 4: {
                thisNode.patternLength = 4;
                b0 = bs[0 + offset] != 0;
                b1 = bs[1 + offset] != 0;
                b2 = bs[2 + offset] != 0;
                boolean bl = b3 = bs[3 + offset] != 0;
                if (!b0 && b1 && b2 && b3) {
                    thisNode.bitPattern = 86;
                    break;
                }
                if (b0 && !b1 && b2 && b3) {
                    thisNode.bitPattern = 89;
                    break;
                }
                if (b0 && b1 && !b2 && b3) {
                    thisNode.bitPattern = 101;
                    break;
                }
                if (b0 && b1 && b2 && !b3) {
                    thisNode.bitPattern = 149;
                    break;
                }
            }
            case 3: {
                b0 = bs[0 + offset] != 0;
                b1 = bs[1 + offset] != 0;
                b2 = bs[2 + offset] != 0;
                thisNode.patternLength = 3;
                if (!b0 && !b1 && b2) {
                    thisNode.bitPattern = 102;
                    break;
                }
                if (!b0 && b1 && !b2) {
                    thisNode.bitPattern = 150;
                    break;
                }
                if (!b0 && b1 && b2) {
                    thisNode.bitPattern = 92;
                    break;
                }
                if (b0 && !b1 && !b2) {
                    thisNode.bitPattern = 153;
                    break;
                }
                if (b0 && !b1 && b2) {
                    thisNode.bitPattern = 113;
                    break;
                }
                if (b0 && b1 && !b2) {
                    thisNode.bitPattern = 197;
                    break;
                }
            }
            case 2: {
                thisNode.patternLength = 2;
                b0 = bs[0 + offset] != 0;
                boolean bl = b1 = bs[1 + offset] != 0;
                if (!b0 && !b1) {
                    thisNode.bitPattern = 198;
                    break;
                }
                if (!b0 && b1) {
                    thisNode.bitPattern = 120;
                    break;
                }
                if (b0 && !b1) {
                    thisNode.bitPattern = 225;
                    break;
                }
            }
            case 1: {
                thisNode.patternLength = 1;
                boolean bl = b0 = bs[0 + offset] != 0;
                if (!b0) {
                    thisNode.bitPattern = 240;
                    break;
                }
                thisNode.patternLength = 0;
            }
        }
        return thisNode.patternLength != 0;
    }

    private static class Node {
        int bitPattern;
        int patternLength;

        private Node() {
        }
    }
}

