/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp.swing.mon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import jmri.jmrix.AbstractMonFrame;
import jmri.jmrix.dccpp.DCCppListener;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppReply;
import jmri.jmrix.dccpp.DCCppSystemConnectionMemo;
import jmri.jmrix.dccpp.DCCppTrafficController;
import jmri.jmrix.dccpp.serial.SerialDCCppPacketizer;
import jmri.jmrix.dccpp.swing.mon.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppMonFrame
extends AbstractMonFrame
implements DCCppListener {
    final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrix.dccpp.swing.DCCppSwingBundle");
    protected DCCppTrafficController tc = null;
    protected DCCppSystemConnectionMemo _memo = null;
    protected SerialDCCppPacketizer serialDCCppTC = null;
    protected final JPanel serialPane = new JPanel();
    protected final JLabel queuedEntriesLabel = new JLabel("", 2);
    protected final JToggleButton pauseRefreshButton = new JToggleButton();
    protected final JButton clearRefreshQueueButton = new JButton();
    volatile PrintStream logStream = null;
    DateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
    StringBuffer linesBuffer = new StringBuffer();
    private static final Logger log = LoggerFactory.getLogger(DCCppMonFrame.class);
    private int previouslyQueuedMessages = -1;

    public DCCppMonFrame(DCCppSystemConnectionMemo memo) {
        this._memo = memo;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected String title() {
        return String.valueOf(this.rb.getString("DCCppMonFrameTitle")) + " (" + this._memo.getSystemPrefix() + ")";
    }

    @Override
    protected void init() {
        this.tc = this._memo.getDCCppTrafficController();
        this.tc.addDCCppListener(-1, this);
        if (this.tc instanceof SerialDCCppPacketizer && this.tc.getCommandStation().isFunctionRefreshRequired()) {
            this.serialDCCppTC = (SerialDCCppPacketizer)this.tc;
            this.pauseRefreshButton.setSelected(!this.serialDCCppTC.isActiveRefresh());
            this.refreshQueuedMessages();
            this.add((Component)this.serialPane, "Last");
        }
        JLabel functionLabel = new JLabel(Bundle.getMessage("LabelFunctionRefresh"), 2);
        this.pauseRefreshButton.setText(Bundle.getMessage("ButtonPauseRefresh"));
        this.pauseRefreshButton.setVisible(true);
        this.pauseRefreshButton.setToolTipText(Bundle.getMessage("TooltipPauseRefresh"));
        this.clearRefreshQueueButton.setText(Bundle.getMessage("ButtonClearRefreshQueue"));
        this.clearRefreshQueueButton.setVisible(true);
        this.clearRefreshQueueButton.setToolTipText(Bundle.getMessage("TooltipClearRefreshQueue"));
        this.serialPane.setLayout(new BoxLayout(this.serialPane, 2));
        this.serialPane.add(functionLabel);
        this.serialPane.add(Box.createRigidArea(new Dimension(5, 0)));
        this.serialPane.add(this.pauseRefreshButton);
        this.serialPane.add(Box.createRigidArea(new Dimension(5, 0)));
        this.serialPane.add(this.clearRefreshQueueButton);
        this.serialPane.add(Box.createRigidArea(new Dimension(5, 0)));
        this.serialPane.add(this.queuedEntriesLabel);
        this.pauseRefreshButton.addActionListener(e -> this.pauseButtonEvent(e));
        this.clearRefreshQueueButton.addActionListener(e -> this.clearButtonEvent(e));
        this.pack();
    }

    @Override
    public synchronized void message(DCCppMessage l) {
        StringBuilder raw = new StringBuilder();
        if (this.rawCheckBox.isSelected()) {
            raw.append(l.toString());
        }
        String text = l.toMonitorString();
        this.nextLine("TX: " + text + "\n", raw.toString());
        this.refreshQueuedMessages();
    }

    @Override
    public void message(DCCppReply l) {
        if (log.isDebugEnabled()) {
            log.debug("Message in Monitor: '{}' opcode {}", (Object)l, (Object)Character.toString(l.getOpCodeChar()));
        }
        StringBuilder raw = new StringBuilder();
        if (this.rawCheckBox.isSelected()) {
            raw.append(l.toString());
        }
        String text = l.toMonitorString();
        this.nextLine("RX: " + text + "\n", raw.toString());
        if (l.isStatusReply()) {
            if (this.tc.getCommandStation().isFunctionRefreshRequired()) {
                this.serialPane.setVisible(true);
            } else {
                this.serialPane.setVisible(false);
            }
        }
    }

    @Override
    public void notifyTimeout(DCCppMessage msg) {
    }

    private void clearButtonEvent(ActionEvent e) {
        if (this.serialDCCppTC != null) {
            this.serialDCCppTC.clearRefreshQueue();
        }
        this.refreshQueuedMessages();
    }

    private void pauseButtonEvent(ActionEvent e) {
        JToggleButton source = (JToggleButton)e.getSource();
        if (this.serialDCCppTC != null) {
            this.serialDCCppTC.setActiveRefresh(!source.isSelected());
        }
    }

    public synchronized void refreshQueuedMessages() {
        int currentlyQueuedMessages;
        if (this.serialDCCppTC != null && (currentlyQueuedMessages = this.serialDCCppTC.getQueueLength()) != this.previouslyQueuedMessages) {
            this.queuedEntriesLabel.setText(Bundle.getMessage("LabelQueuedEntries", String.valueOf(currentlyQueuedMessages)));
            this.clearRefreshQueueButton.setEnabled(currentlyQueuedMessages > 0);
            this.previouslyQueuedMessages = currentlyQueuedMessages;
        }
    }
}

