/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp.swing;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import jmri.jmrix.dccpp.DCCppCommandStation;
import jmri.jmrix.dccpp.DCCppListener;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppReply;
import jmri.jmrix.dccpp.DCCppSystemConnectionMemo;
import jmri.jmrix.dccpp.DCCppTrafficController;
import jmri.jmrix.dccpp.swing.Bundle;
import jmri.jmrix.dccpp.swing.DCCppMenu;
import jmri.jmrix.dccpp.swing.DCCppTableModel;
import jmri.util.JmriJFrame;
import jmri.util.LoggingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigBaseStationFrame
extends JmriJFrame
implements DCCppListener {
    private static final Map<String, Integer> Mnemonics = new HashMap<String, Integer>();
    protected EventListenerList listenerList = new EventListenerList();
    private final DCCppTrafficController _tc;
    private JTabbedPane tabbedPane;
    private JLabel versionLabel = new JLabel("");
    private SensorTableModel sensorModel;
    private DccTurnoutTableModel dccTurnoutModel;
    private ServoTurnoutTableModel servoTurnoutModel;
    private VpinTurnoutTableModel vpinTurnoutModel;
    private OutputTableModel outputModel;
    private JTable sensorTable;
    private JTable dccTurnoutTable;
    private JTable servoTurnoutTable;
    private JTable vpinTurnoutTable;
    private JTable outputTable;
    private TableRowSorter<TableModel> sensorSorter;
    private TableRowSorter<TableModel> dccTurnoutSorter;
    private TableRowSorter<TableModel> servoTurnoutSorter;
    private TableRowSorter<TableModel> vpinTurnoutSorter;
    private TableRowSorter<TableModel> outputSorter;
    private CurrentTab cTab;
    private DCCppSystemConnectionMemo _memo;
    private static final int SENSOR_TAB_NUM = 0;
    private static final int DCCTURNOUT_TAB_NUM = 1;
    private static final int SERVOTURNOUT_TAB_NUM = 2;
    private static final int VPINTURNOUT_TAB_NUM = 3;
    private static final int OUTPUT_TAB_NUM = 4;
    private static final Logger log;

    static {
        Mnemonics.put("SensorTab", 69);
        Mnemonics.put("DCCTurnoutTab", 84);
        Mnemonics.put("ServoTurnoutTab", 82);
        Mnemonics.put("VpinTurnoutTab", 86);
        Mnemonics.put("OutputTab", 79);
        Mnemonics.put("ButtonAdd", 65);
        Mnemonics.put("CloseButton", 88);
        Mnemonics.put("SaveButton", 83);
        log = LoggerFactory.getLogger(ConfigBaseStationFrame.class);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="2D array of different types passed as complex parameter. Better to switch to passing use-specific objects rather than papering this over with a deep copy of the arguments. In any case, there's no risk of exposure here.")
    public ConfigBaseStationFrame(DCCppSystemConnectionMemo memo) {
        super(false, false);
        this._memo = memo;
        this._tc = memo.getDCCppTrafficController();
        this.initGui();
    }

    private void initGui() {
        this.setTitle(String.valueOf(Bundle.getMessage("FieldManageBaseStationFrameTitle")) + " (" + this._memo.getSystemPrefix() + ")");
        this.buildMenu();
        JButton addButton = new JButton(Bundle.getMessage("ButtonAddX", Bundle.getMessage("BeanNameSensor")));
        addButton.setToolTipText(Bundle.getMessage("ToolTipButtonMSFAdd"));
        addButton.setMnemonic(Mnemonics.get("ButtonAdd"));
        addButton.addActionListener(e -> this.addButtonPressed(e));
        JButton closeButton = new JButton(Bundle.getMessage("ButtonClose"));
        closeButton.setToolTipText(Bundle.getMessage("ToolTipButtonClose"));
        closeButton.setMnemonic(Mnemonics.get("CloseButton"));
        closeButton.addActionListener(e -> this.closeButtonPressed(e));
        JButton saveButton = new JButton(Bundle.getMessage("ButtonSaveX", Bundle.getMessage("Sensors")));
        saveButton.setToolTipText(Bundle.getMessage("ToolTipButtonMSFSave"));
        saveButton.setMnemonic(Mnemonics.get("SaveButton"));
        saveButton.addActionListener(e -> this.saveButtonPressed(e));
        JScrollPane sensorScrollPanel = new JScrollPane();
        this.sensorModel = new SensorTableModel();
        this.sensorTable = new JTable(this.sensorModel);
        this.sensorTable.setFillsViewportHeight(true);
        sensorScrollPanel.getViewport().add(this.sensorTable);
        this.sensorTable.setPreferredScrollableViewportSize(new Dimension(520, 200));
        this.sensorTable.getColumn(Bundle.getMessage("ColumnDelete")).setCellRenderer(new ButtonRenderer());
        this.sensorTable.removeColumn(this.sensorTable.getColumn("isNew"));
        this.sensorTable.removeColumn(this.sensorTable.getColumn("isDirty"));
        this.sensorTable.removeColumn(this.sensorTable.getColumn("isDelete"));
        this.sensorTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ConfigBaseStationFrame.this.handleTableMouseClick(ConfigBaseStationFrame.this.sensorTable, evt);
            }
        });
        this.sensorTable.setAutoCreateRowSorter(true);
        this.sensorSorter = new TableRowSorter<TableModel>(this.sensorTable.getModel());
        this.sensorTable.setRowSorter(this.sensorSorter);
        ArrayList<RowSorter.SortKey> sensorSortKeys = new ArrayList<RowSorter.SortKey>();
        sensorSortKeys.add(new RowSorter.SortKey(this.sensorTable.getColumn(Bundle.getMessage("IDCol")).getModelIndex(), SortOrder.ASCENDING));
        this.sensorSorter.setSortKeys(sensorSortKeys);
        this.sensorSorter.sort();
        this.sensorSorter.setSortable(this.sensorTable.getColumn(Bundle.getMessage("ColumnDelete")).getModelIndex(), false);
        JScrollPane dccTurnoutScrollPanel = new JScrollPane();
        this.dccTurnoutModel = new DccTurnoutTableModel();
        this.dccTurnoutTable = new JTable(this.dccTurnoutModel);
        this.dccTurnoutTable.setFillsViewportHeight(true);
        dccTurnoutScrollPanel.getViewport().add(this.dccTurnoutTable);
        this.dccTurnoutTable.setPreferredScrollableViewportSize(new Dimension(520, 200));
        this.dccTurnoutTable.getColumn(Bundle.getMessage("ColumnDelete")).setCellRenderer(new ButtonRenderer());
        this.dccTurnoutTable.removeColumn(this.dccTurnoutTable.getColumn("isNew"));
        this.dccTurnoutTable.removeColumn(this.dccTurnoutTable.getColumn("isDirty"));
        this.dccTurnoutTable.removeColumn(this.dccTurnoutTable.getColumn("isDelete"));
        this.dccTurnoutTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ConfigBaseStationFrame.this.handleTableMouseClick(ConfigBaseStationFrame.this.dccTurnoutTable, evt);
            }
        });
        this.dccTurnoutTable.setAutoCreateRowSorter(true);
        this.dccTurnoutSorter = new TableRowSorter<TableModel>(this.dccTurnoutTable.getModel());
        this.dccTurnoutTable.setRowSorter(this.dccTurnoutSorter);
        ArrayList<RowSorter.SortKey> dccTurnoutSortKeys = new ArrayList<RowSorter.SortKey>();
        dccTurnoutSortKeys.add(new RowSorter.SortKey(this.dccTurnoutTable.getColumn(Bundle.getMessage("IDCol")).getModelIndex(), SortOrder.ASCENDING));
        this.dccTurnoutSorter.setSortKeys(dccTurnoutSortKeys);
        this.dccTurnoutSorter.setSortable(this.dccTurnoutTable.getColumn(Bundle.getMessage("ColumnDelete")).getModelIndex(), false);
        this.dccTurnoutSorter.sort();
        JScrollPane servoTurnoutScrollPanel = new JScrollPane();
        this.servoTurnoutModel = new ServoTurnoutTableModel();
        this.servoTurnoutTable = new JTable(this.servoTurnoutModel);
        this.servoTurnoutTable.setFillsViewportHeight(true);
        servoTurnoutScrollPanel.getViewport().add(this.servoTurnoutTable);
        this.servoTurnoutTable.setPreferredScrollableViewportSize(new Dimension(520, 200));
        this.servoTurnoutTable.getColumn(Bundle.getMessage("ColumnDelete")).setCellRenderer(new ButtonRenderer());
        this.servoTurnoutTable.removeColumn(this.servoTurnoutTable.getColumn("isNew"));
        this.servoTurnoutTable.removeColumn(this.servoTurnoutTable.getColumn("isDirty"));
        this.servoTurnoutTable.removeColumn(this.servoTurnoutTable.getColumn("isDelete"));
        this.servoTurnoutTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ConfigBaseStationFrame.this.handleTableMouseClick(ConfigBaseStationFrame.this.servoTurnoutTable, evt);
            }
        });
        this.servoTurnoutTable.setAutoCreateRowSorter(true);
        this.servoTurnoutSorter = new TableRowSorter<TableModel>(this.servoTurnoutTable.getModel());
        this.servoTurnoutTable.setRowSorter(this.servoTurnoutSorter);
        ArrayList<RowSorter.SortKey> servoTurnoutSortKeys = new ArrayList<RowSorter.SortKey>();
        servoTurnoutSortKeys.add(new RowSorter.SortKey(this.servoTurnoutTable.getColumn(Bundle.getMessage("IDCol")).getModelIndex(), SortOrder.ASCENDING));
        this.servoTurnoutSorter.setSortKeys(servoTurnoutSortKeys);
        this.servoTurnoutSorter.setSortable(this.servoTurnoutTable.getColumn(Bundle.getMessage("ColumnDelete")).getModelIndex(), false);
        this.servoTurnoutSorter.sort();
        JScrollPane vpinTurnoutScrollPanel = new JScrollPane();
        this.vpinTurnoutModel = new VpinTurnoutTableModel();
        this.vpinTurnoutTable = new JTable(this.vpinTurnoutModel);
        this.vpinTurnoutTable.setFillsViewportHeight(true);
        vpinTurnoutScrollPanel.getViewport().add(this.vpinTurnoutTable);
        this.vpinTurnoutTable.setPreferredScrollableViewportSize(new Dimension(520, 200));
        this.vpinTurnoutTable.getColumn(Bundle.getMessage("ColumnDelete")).setCellRenderer(new ButtonRenderer());
        this.vpinTurnoutTable.removeColumn(this.vpinTurnoutTable.getColumn("isNew"));
        this.vpinTurnoutTable.removeColumn(this.vpinTurnoutTable.getColumn("isDirty"));
        this.vpinTurnoutTable.removeColumn(this.vpinTurnoutTable.getColumn("isDelete"));
        this.vpinTurnoutTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ConfigBaseStationFrame.this.handleTableMouseClick(ConfigBaseStationFrame.this.vpinTurnoutTable, evt);
            }
        });
        this.vpinTurnoutTable.setAutoCreateRowSorter(true);
        this.vpinTurnoutSorter = new TableRowSorter<TableModel>(this.vpinTurnoutTable.getModel());
        this.vpinTurnoutTable.setRowSorter(this.vpinTurnoutSorter);
        ArrayList<RowSorter.SortKey> vpinTurnoutSortKeys = new ArrayList<RowSorter.SortKey>();
        vpinTurnoutSortKeys.add(new RowSorter.SortKey(this.vpinTurnoutTable.getColumn(Bundle.getMessage("IDCol")).getModelIndex(), SortOrder.ASCENDING));
        this.vpinTurnoutSorter.setSortKeys(vpinTurnoutSortKeys);
        this.vpinTurnoutSorter.setSortable(this.vpinTurnoutTable.getColumn(Bundle.getMessage("ColumnDelete")).getModelIndex(), false);
        this.vpinTurnoutSorter.sort();
        JScrollPane outputScrollPanel = new JScrollPane();
        this.outputModel = new OutputTableModel();
        this.outputTable = new JTable(this.outputModel);
        this.outputTable.setFillsViewportHeight(true);
        outputScrollPanel.getViewport().add(this.outputTable);
        this.outputTable.setPreferredScrollableViewportSize(new Dimension(520, 200));
        this.outputTable.getColumn(Bundle.getMessage("ColumnDelete")).setCellRenderer(new ButtonRenderer());
        this.outputTable.removeColumn(this.outputTable.getColumn("isNew"));
        this.outputTable.removeColumn(this.outputTable.getColumn("isDirty"));
        this.outputTable.removeColumn(this.outputTable.getColumn("isDelete"));
        this.outputTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ConfigBaseStationFrame.this.handleTableMouseClick(ConfigBaseStationFrame.this.outputTable, evt);
            }
        });
        this.outputTable.setAutoCreateRowSorter(true);
        this.outputSorter = new TableRowSorter<TableModel>(this.outputTable.getModel());
        this.outputTable.setRowSorter(this.outputSorter);
        ArrayList<RowSorter.SortKey> outputSortKeys = new ArrayList<RowSorter.SortKey>();
        outputSortKeys.add(new RowSorter.SortKey(this.sensorTable.getColumn(Bundle.getMessage("IDCol")).getModelIndex(), SortOrder.ASCENDING));
        this.outputSorter.setSortKeys(outputSortKeys);
        this.outputSorter.setSortable(this.sensorTable.getColumn(Bundle.getMessage("ColumnDelete")).getModelIndex(), false);
        this.outputSorter.sort();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(Bundle.getMessage("Sensors"), sensorScrollPanel);
        this.tabbedPane.setToolTipTextAt(0, Bundle.getMessage("ToolTipSensorTab"));
        this.tabbedPane.setMnemonicAt(0, Mnemonics.get("SensorTab"));
        this.tabbedPane.addTab(Bundle.getMessage("DCCTurnouts"), dccTurnoutScrollPanel);
        this.tabbedPane.setToolTipTextAt(1, Bundle.getMessage("ToolTipDccTurnoutTab"));
        this.tabbedPane.setMnemonicAt(1, Mnemonics.get("DCCTurnoutTab"));
        this.tabbedPane.addTab(Bundle.getMessage("ServoTurnouts"), servoTurnoutScrollPanel);
        this.tabbedPane.setToolTipTextAt(2, Bundle.getMessage("ToolTipServoTurnoutTab"));
        this.tabbedPane.setMnemonicAt(2, Mnemonics.get("ServoTurnoutTab"));
        this.tabbedPane.addTab(Bundle.getMessage("VpinTurnouts"), vpinTurnoutScrollPanel);
        this.tabbedPane.setToolTipTextAt(3, Bundle.getMessage("ToolTipVpinTurnoutTab"));
        this.tabbedPane.setMnemonicAt(3, Mnemonics.get("VpinTurnoutTab"));
        this.tabbedPane.addTab(Bundle.getMessage("FieldOutputsTabTitle"), outputScrollPanel);
        this.tabbedPane.setToolTipTextAt(4, Bundle.getMessage("ToolTipOutputTab"));
        this.tabbedPane.setMnemonicAt(4, Mnemonics.get("OutputTab"));
        this.cTab = CurrentTab.SENSOR;
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.addChangeListener(e -> {
            switch (this.tabbedPane.getSelectedIndex()) {
                case 4: {
                    this.cTab = CurrentTab.OUTPUT;
                    addButton.setText(Bundle.getMessage("ButtonAddX", Bundle.getMessage("Output")));
                    addButton.setToolTipText(Bundle.getMessage("ToolTipButtonMOFAdd"));
                    saveButton.setText(Bundle.getMessage("ButtonSaveX", Bundle.getMessage("FieldOutputsTabTitle")));
                    saveButton.setToolTipText(Bundle.getMessage("ToolTipButtonMOFSave"));
                    log.debug("Current Tab is: {}", (Object)this.tabbedPane.getSelectedIndex());
                    break;
                }
                case 3: {
                    this.cTab = CurrentTab.VPINTURNOUT;
                    addButton.setText(Bundle.getMessage("ButtonAddX", Bundle.getMessage("VpinTurnout")));
                    addButton.setToolTipText(Bundle.getMessage("ToolTipButtonMTFAdd"));
                    saveButton.setText(Bundle.getMessage("ButtonSaveX", Bundle.getMessage("VpinTurnouts")));
                    saveButton.setToolTipText(Bundle.getMessage("ToolTipButtonMTFSave"));
                    log.debug("Current Tab is: {}", (Object)this.tabbedPane.getSelectedIndex());
                    break;
                }
                case 2: {
                    this.cTab = CurrentTab.SERVOTURNOUT;
                    addButton.setText(Bundle.getMessage("ButtonAddX", Bundle.getMessage("ServoTurnout")));
                    addButton.setToolTipText(Bundle.getMessage("ToolTipButtonMTFAdd"));
                    saveButton.setText(Bundle.getMessage("ButtonSaveX", Bundle.getMessage("ServoTurnouts")));
                    saveButton.setToolTipText(Bundle.getMessage("ToolTipButtonMTFSave"));
                    log.debug("Current Tab is: {}", (Object)this.tabbedPane.getSelectedIndex());
                    break;
                }
                case 1: {
                    this.cTab = CurrentTab.DCCTURNOUT;
                    addButton.setText(Bundle.getMessage("ButtonAddX", Bundle.getMessage("DCCTurnout")));
                    addButton.setToolTipText(Bundle.getMessage("ToolTipButtonMTFAdd"));
                    saveButton.setText(Bundle.getMessage("ButtonSaveX", Bundle.getMessage("DCCTurnouts")));
                    saveButton.setToolTipText(Bundle.getMessage("ToolTipButtonMTFSave"));
                    log.debug("Current Tab is: {}", (Object)this.tabbedPane.getSelectedIndex());
                    break;
                }
                default: {
                    this.cTab = CurrentTab.SENSOR;
                    addButton.setText(Bundle.getMessage("ButtonAddX", Bundle.getMessage("BeanNameSensor")));
                    addButton.setToolTipText(Bundle.getMessage("ToolTipButtonMSFAdd"));
                    saveButton.setText(Bundle.getMessage("ButtonSaveX", Bundle.getMessage("Sensors")));
                    saveButton.setToolTipText(Bundle.getMessage("ToolTipButtonMSFSave"));
                    log.debug("Current Tab is: {}", (Object)this.tabbedPane.getSelectedIndex());
                }
            }
        });
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel bottomPanelLeft = new JPanel();
        JPanel bottomPanelRight = new JPanel();
        bottomPanelLeft.add(addButton);
        bottomPanelLeft.add(saveButton);
        bottomPanel.add((Component)bottomPanelLeft, "West");
        bottomPanelRight.add(this.versionLabel);
        bottomPanelRight.add(closeButton);
        bottomPanel.add((Component)bottomPanelRight, "East");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.tabbedPane);
        this.getContentPane().add(bottomPanel);
        this.pack();
        this.setVisible(true);
    }

    private void buildMenu() {
        this.setJMenuBar(new JMenuBar());
        JMenu fileMenu = new JMenu(Bundle.getMessage("MenuFile"));
        this.getJMenuBar().add(fileMenu);
        JMenu mSend = new JMenu(Bundle.getMessage("MenuSend"));
        JMenuItem iRequestDefs = new JMenuItem(Bundle.getMessage("RequestDefs"));
        iRequestDefs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ConfigBaseStationFrame.this._tc.sendDCCppMessage(new DCCppMessage(String.valueOf('S')), null);
                ConfigBaseStationFrame.this._tc.sendDCCppMessage(new DCCppMessage(String.valueOf('T')), null);
                ConfigBaseStationFrame.this._tc.sendDCCppMessage(new DCCppMessage(String.valueOf('Z')), null);
            }
        });
        mSend.add(iRequestDefs);
        JMenuItem iRequestStates = new JMenuItem(Bundle.getMessage("RequestStates"));
        iRequestStates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ConfigBaseStationFrame.this._tc.sendDCCppMessage(new DCCppMessage(String.valueOf('s')), null);
            }
        });
        mSend.add(iRequestStates);
        JMenuItem iSaveToEeprom = new JMenuItem(Bundle.getMessage("SaveToEEPROM"));
        iSaveToEeprom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ConfigBaseStationFrame.this._tc.sendDCCppMessage(new DCCppMessage(String.valueOf('E')), null);
            }
        });
        mSend.add(iSaveToEeprom);
        JMenuItem iEraseEeprom = new JMenuItem(Bundle.getMessage("ClearEEPROM"));
        iEraseEeprom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ConfigBaseStationFrame.this._tc.sendDCCppMessage(new DCCppMessage(String.valueOf('e')), null);
            }
        });
        mSend.add(iEraseEeprom);
        this.getJMenuBar().add(mSend);
        DCCppMenu dccppMenu = new DCCppMenu(this._memo);
        dccppMenu.setText(Bundle.getMessage("MenuDCC++"));
        this.getJMenuBar().add(dccppMenu);
    }

    @Override
    public void message(DCCppReply r) {
        if (r.isSensorDefReply()) {
            ArrayList<Object> v = new ArrayList<Object>();
            v.add(r.getSensorDefNumInt());
            v.add(r.getSensorDefPinInt());
            v.add(r.getSensorDefPullupBool());
            this.sensorModel.insertData(v, false);
            this.sensorSorter.sort();
        } else if (r.isTurnoutDefReply() || r.isTurnoutDefDCCReply()) {
            ArrayList<Object> v = new ArrayList<Object>();
            v.add(r.getTOIDInt());
            v.add(r.getTurnoutDefAddrInt());
            v.add(r.getTurnoutDefSubAddrInt());
            this.dccTurnoutModel.insertData(v, false);
            this.dccTurnoutSorter.sort();
        } else if (r.isTurnoutDefServoReply()) {
            ArrayList<Object> v = new ArrayList<Object>();
            v.add(r.getTOIDInt());
            v.add(r.getTOPinInt());
            v.add(r.getTOThrownPositionInt());
            v.add(r.getTOClosedPositionInt());
            v.add(r.getTOProfileInt());
            this.servoTurnoutModel.insertData(v, false);
            this.servoTurnoutSorter.sort();
        } else if (r.isTurnoutDefVpinReply()) {
            ArrayList<Object> v = new ArrayList<Object>();
            v.add(r.getTOIDInt());
            v.add(r.getTOPinInt());
            this.vpinTurnoutModel.insertData(v, false);
            this.vpinTurnoutSorter.sort();
        } else if (r.isOutputDefReply()) {
            ArrayList<Object> v = new ArrayList<Object>();
            v.add(r.getOutputNumInt());
            v.add(r.getOutputListPinInt());
            v.add((r.getOutputListIFlagInt() & 1) == 1);
            v.add((r.getOutputListIFlagInt() & 2) == 2);
            v.add((r.getOutputListIFlagInt() & 4) == 4);
            this.outputModel.insertData(v, false);
            this.outputSorter.sort();
        } else if (r.isStatusReply()) {
            DCCppCommandStation cs = this._tc.getCommandStation();
            if (cs.isServoTurnoutCreationSupported()) {
                this.tabbedPane.setEnabledAt(2, true);
                this.tabbedPane.setEnabledAt(3, true);
            } else {
                this.tabbedPane.setEnabledAt(2, false);
                this.tabbedPane.setEnabledAt(3, false);
            }
            String v = String.valueOf(cs.getStationType()) + " " + cs.getVersion() + " " + cs.getBuild();
            if (v.length() > 40) {
                v = "";
            }
            this.versionLabel.setText(v);
        }
    }

    @Override
    public void message(DCCppMessage m) {
    }

    @Override
    public void notifyTimeout(DCCppMessage m) {
    }

    private void handleTableMouseClick(JTable table, MouseEvent evt) {
        int row = table.rowAtPoint(evt.getPoint());
        int col = table.columnAtPoint(evt.getPoint());
        if (row < 0 || col < 0) {
            return;
        }
        DCCppTableModel model = (DCCppTableModel)table.getModel();
        if (col == table.convertColumnIndexToView(model.getDeleteColumn())) {
            int sel = table.convertRowIndexToModel(row);
            int idx = (Integer)model.getValueAt(sel, 0);
            log.debug("idx = {}", (Object)sel);
            int value = JOptionPane.showConfirmDialog(null, Bundle.getMessage("DeleteWarningMessage", Integer.toString(idx)), Bundle.getMessage("WarningTitle"), 2);
            if (value == 0 && this.cTab != null) {
                switch (this.cTab) {
                    case SENSOR: {
                        this._tc.sendDCCppMessage(DCCppMessage.makeSensorDeleteMsg(idx), this);
                        this.sensorModel.removeRow(sel);
                        log.debug("Delete sensor {}", (Object)idx);
                        break;
                    }
                    case DCCTURNOUT: {
                        DCCppMessage m = new DCCppMessage("T " + Integer.toString(idx));
                        this._tc.sendDCCppMessage(m, this);
                        log.debug("Sending: {}", (Object)m);
                        this.dccTurnoutModel.removeRow(sel);
                        break;
                    }
                    case SERVOTURNOUT: {
                        DCCppMessage m = new DCCppMessage("T " + Integer.toString(idx));
                        this._tc.sendDCCppMessage(m, this);
                        log.debug("Sending: {}", (Object)m);
                        this.servoTurnoutModel.removeRow(sel);
                        break;
                    }
                    case VPINTURNOUT: {
                        DCCppMessage m = new DCCppMessage("T " + Integer.toString(idx));
                        this._tc.sendDCCppMessage(m, this);
                        log.debug("Sending: {}", (Object)m);
                        this.vpinTurnoutModel.removeRow(sel);
                        break;
                    }
                    case OUTPUT: {
                        this._tc.sendDCCppMessage(DCCppMessage.makeOutputDeleteMsg(idx), this);
                        this.outputModel.removeRow(sel);
                        break;
                    }
                    default: {
                        LoggingUtil.warnOnce(log, "Unexpected cTab value = {}", new Object[]{this.cTab});
                    }
                }
            }
        }
    }

    private void addButtonPressed(ActionEvent e) {
        if (this.cTab != null) {
            switch (this.cTab) {
                case SENSOR: {
                    ArrayList<Object> v = new ArrayList<Object>();
                    v.add(0);
                    v.add(0);
                    v.add(false);
                    this.sensorModel.insertData(v, true);
                    break;
                }
                case DCCTURNOUT: {
                    ArrayList<Object> v = new ArrayList<Object>();
                    v.add(0);
                    v.add(0);
                    v.add(0);
                    this.dccTurnoutModel.insertData(v, true);
                    break;
                }
                case SERVOTURNOUT: {
                    ArrayList<Object> v = new ArrayList<Object>();
                    v.add(0);
                    v.add(0);
                    v.add(0);
                    v.add(0);
                    v.add(0);
                    this.servoTurnoutModel.insertData(v, true);
                    break;
                }
                case VPINTURNOUT: {
                    ArrayList<Object> v = new ArrayList<Object>();
                    v.add(0);
                    v.add(0);
                    this.vpinTurnoutModel.insertData(v, true);
                    break;
                }
                case OUTPUT: {
                    ArrayList<Object> v = new ArrayList<Object>();
                    v.add(0);
                    v.add(0);
                    v.add(false);
                    v.add(false);
                    v.add(false);
                    this.outputModel.insertData(v, true);
                    break;
                }
            }
        }
    }

    private void saveButtonPressed(ActionEvent e) {
        int value = JOptionPane.showConfirmDialog(null, Bundle.getMessage("FieldMCFSaveDialogConfirmMessage"), Bundle.getMessage("ConfirmSaveDialogTitle"), 0);
        if (this.sensorTable.getCellEditor() != null) {
            this.sensorTable.getCellEditor().stopCellEditing();
        }
        if (this.dccTurnoutTable.getCellEditor() != null) {
            this.dccTurnoutTable.getCellEditor().stopCellEditing();
        }
        if (this.servoTurnoutTable.getCellEditor() != null) {
            this.servoTurnoutTable.getCellEditor().stopCellEditing();
        }
        if (this.vpinTurnoutTable.getCellEditor() != null) {
            this.vpinTurnoutTable.getCellEditor().stopCellEditing();
        }
        if (this.outputTable.getCellEditor() != null) {
            this.outputTable.getCellEditor().stopCellEditing();
        }
        if (value == 0) {
            this.saveTableValues();
        }
    }

    private void saveTableValues() {
        int value;
        if (this.cTab != null) {
            switch (this.cTab) {
                case SENSOR: {
                    int i = 0;
                    while (i < this.sensorModel.getRowData().size()) {
                        List<Object> r = this.sensorModel.getRowData().get(i);
                        boolean isnew = (Boolean)r.get(4);
                        boolean isdirty = (Boolean)r.get(5);
                        boolean isdelete = (Boolean)r.get(6);
                        int row = this.sensorModel.getRowData().indexOf(r);
                        if (isnew) {
                            this._tc.sendDCCppMessage(DCCppMessage.makeSensorAddMsg((Integer)r.get(0), (Integer)r.get(1), (Boolean)r.get(2) != false ? 1 : 0), this);
                            this.sensorModel.setNewRow(row, false);
                        } else if (isdelete) {
                            this._tc.sendDCCppMessage(DCCppMessage.makeSensorDeleteMsg((Integer)r.get(0)), this);
                            this.sensorModel.getRowData().remove(r);
                        } else if (isdirty) {
                            this._tc.sendDCCppMessage(DCCppMessage.makeSensorDeleteMsg((Integer)r.get(0)), this);
                            this._tc.sendDCCppMessage(DCCppMessage.makeSensorAddMsg((Integer)r.get(0), (Integer)r.get(1), (Boolean)r.get(2) != false ? 1 : 0), this);
                            this.sensorModel.setNewRow(row, false);
                            this.sensorModel.setDirtyRow(row, false);
                        }
                        ++i;
                    }
                    this._tc.sendDCCppMessage(DCCppMessage.makeSensorListMsg(), this);
                    break;
                }
                case DCCTURNOUT: {
                    int i = 0;
                    while (i < this.dccTurnoutModel.getRowData().size()) {
                        List<Object> r = this.dccTurnoutModel.getRowData().get(i);
                        boolean isnew = (Boolean)r.get(4);
                        boolean isdirty = (Boolean)r.get(5);
                        boolean isdelete = (Boolean)r.get(6);
                        int row = this.dccTurnoutModel.getRowData().indexOf(r);
                        if (isnew) {
                            this._tc.sendDCCppMessage(DCCppMessage.makeTurnoutAddMsg((Integer)r.get(0), (Integer)r.get(1), (Integer)r.get(2)), this);
                            this.dccTurnoutModel.setNewRow(row, false);
                        } else if (isdelete) {
                            DCCppMessage m = new DCCppMessage("T " + Integer.toString((Integer)r.get(0)));
                            this._tc.sendDCCppMessage(m, this);
                            log.debug("Sending: {}", (Object)m);
                            this.dccTurnoutModel.getRowData().remove(r);
                        } else if (isdirty) {
                            this._tc.sendDCCppMessage(DCCppMessage.makeTurnoutDeleteMsg((Integer)r.get(0)), this);
                            this._tc.sendDCCppMessage(DCCppMessage.makeTurnoutAddMsg((Integer)r.get(0), (Integer)r.get(1), (Integer)r.get(2)), this);
                            this.dccTurnoutModel.setNewRow(row, false);
                            this.dccTurnoutModel.setDirtyRow(row, false);
                        }
                        ++i;
                    }
                    this._tc.sendDCCppMessage(DCCppMessage.makeTurnoutListMsg(), this);
                    break;
                }
                case SERVOTURNOUT: {
                    int i = 0;
                    while (i < this.servoTurnoutModel.getRowData().size()) {
                        DCCppMessage m;
                        List<Object> r = this.servoTurnoutModel.getRowData().get(i);
                        boolean isnew = (Boolean)r.get(6);
                        boolean isdirty = (Boolean)r.get(7);
                        boolean isdelete = (Boolean)r.get(8);
                        int row = this.servoTurnoutModel.getRowData().indexOf(r);
                        if (isnew) {
                            m = new DCCppMessage("T " + (Integer)r.get(0) + " SERVO " + (Integer)r.get(1) + " " + (Integer)r.get(2) + " " + (Integer)r.get(3) + " " + (Integer)r.get(4));
                            log.debug("Sending: {}", (Object)m);
                            this._tc.sendDCCppMessage(m, this);
                            this.servoTurnoutModel.setNewRow(row, false);
                        } else if (isdelete) {
                            m = new DCCppMessage("T " + Integer.toString((Integer)r.get(0)));
                            this._tc.sendDCCppMessage(m, this);
                            log.debug("Sending: {}", (Object)m);
                            this.servoTurnoutModel.getRowData().remove(r);
                        } else if (isdirty) {
                            this._tc.sendDCCppMessage(DCCppMessage.makeTurnoutDeleteMsg((Integer)r.get(0)), this);
                            this._tc.sendDCCppMessage(DCCppMessage.makeTurnoutAddMsg((Integer)r.get(0), (Integer)r.get(1), (Integer)r.get(2)), this);
                            this.servoTurnoutModel.setNewRow(row, false);
                            this.servoTurnoutModel.setDirtyRow(row, false);
                        }
                        ++i;
                    }
                    this._tc.sendDCCppMessage(DCCppMessage.makeTurnoutListMsg(), this);
                    break;
                }
                case VPINTURNOUT: {
                    int i = 0;
                    while (i < this.vpinTurnoutModel.getRowData().size()) {
                        DCCppMessage m;
                        List<Object> r = this.vpinTurnoutModel.getRowData().get(i);
                        boolean isnew = (Boolean)r.get(3);
                        boolean isdirty = (Boolean)r.get(4);
                        boolean isdelete = (Boolean)r.get(5);
                        int row = this.vpinTurnoutModel.getRowData().indexOf(r);
                        if (isnew) {
                            m = new DCCppMessage("T " + (Integer)r.get(0) + " VPIN " + (Integer)r.get(1));
                            log.debug("Sending: {}", (Object)m);
                            this._tc.sendDCCppMessage(m, this);
                            this.vpinTurnoutModel.setNewRow(row, false);
                        } else if (isdelete) {
                            m = new DCCppMessage("T " + (Integer)r.get(0));
                            log.debug("Sending: {}", (Object)m);
                            this._tc.sendDCCppMessage(m, this);
                            this.vpinTurnoutModel.getRowData().remove(r);
                        } else if (isdirty) {
                            m = new DCCppMessage("T " + (Integer)r.get(0));
                            log.debug("Sending: {}", (Object)m);
                            this._tc.sendDCCppMessage(m, this);
                            this.vpinTurnoutModel.setNewRow(row, false);
                            this.vpinTurnoutModel.setDirtyRow(row, false);
                        }
                        ++i;
                    }
                    this._tc.sendDCCppMessage(DCCppMessage.makeTurnoutListMsg(), this);
                    break;
                }
                case OUTPUT: {
                    int i = 0;
                    while (i < this.outputModel.getRowData().size()) {
                        int f;
                        List<Object> r = this.outputModel.getRowData().get(i);
                        boolean isnew = (Boolean)r.get(6);
                        boolean isdirty = (Boolean)r.get(7);
                        boolean isdelete = (Boolean)r.get(8);
                        int row = this.outputModel.getRowData().indexOf(r);
                        if (isnew) {
                            f = (Boolean)r.get(2) != false ? 1 : 0;
                            f += (Boolean)r.get(3) != false ? 2 : 0;
                            this._tc.sendDCCppMessage(DCCppMessage.makeOutputAddMsg((Integer)r.get(0), (Integer)r.get(1), f += (Boolean)r.get(4) != false ? 4 : 0), this);
                            this.outputModel.setNewRow(row, false);
                        } else if (isdelete) {
                            this._tc.sendDCCppMessage(DCCppMessage.makeOutputDeleteMsg((Integer)r.get(0)), this);
                            this.outputModel.getRowData().remove(r);
                        } else if (isdirty) {
                            this._tc.sendDCCppMessage(DCCppMessage.makeOutputDeleteMsg((Integer)r.get(0)), this);
                            f = (Boolean)r.get(2) != false ? 1 : 0;
                            f += (Boolean)r.get(3) != false ? 2 : 0;
                            this._tc.sendDCCppMessage(DCCppMessage.makeOutputAddMsg((Integer)r.get(0), (Integer)r.get(1), f += (Boolean)r.get(4) != false ? 4 : 0), this);
                            this.outputModel.setNewRow(row, false);
                            this.outputModel.setDirtyRow(row, false);
                        }
                        ++i;
                    }
                    this._tc.sendDCCppMessage(DCCppMessage.makeOutputListMsg(), this);
                    break;
                }
            }
        }
        if ((value = JOptionPane.showConfirmDialog(null, Bundle.getMessage("FieldMCFCloseDialogConfirmMessage"), Bundle.getMessage("FieldMCFCloseDialogTitle"), 0)) == 0) {
            this._tc.sendDCCppMessage(new DCCppMessage(String.valueOf('E')), this);
            log.debug("Sending: <E> (Write To EEPROM)");
        }
    }

    private void closeButtonPressed(ActionEvent e) {
        if (this.sensorTable.getCellEditor() != null) {
            this.sensorTable.getCellEditor().stopCellEditing();
        }
        if (this.dccTurnoutTable.getCellEditor() != null) {
            this.dccTurnoutTable.getCellEditor().stopCellEditing();
        }
        if (this.servoTurnoutTable.getCellEditor() != null) {
            this.servoTurnoutTable.getCellEditor().stopCellEditing();
        }
        if (this.vpinTurnoutTable.getCellEditor() != null) {
            this.vpinTurnoutTable.getCellEditor().stopCellEditing();
        }
        if (this.outputTable.getCellEditor() != null) {
            this.outputTable.getCellEditor().stopCellEditing();
        }
        if (this.sensorModel.isDirty() || this.dccTurnoutModel.isDirty() || this.servoTurnoutModel.isDirty() || this.vpinTurnoutModel.isDirty() || this.outputModel.isDirty()) {
            int value = JOptionPane.showConfirmDialog(null, Bundle.getMessage("FieldMCFSaveDialogConfirmMessage"), Bundle.getMessage("ConfirmSaveDialogTitle"), 0);
            if (value == 0) {
                this.saveTableValues();
            }
            if ((value = JOptionPane.showConfirmDialog(null, Bundle.getMessage("FieldMCFCloseDialogConfirmMessage"), Bundle.getMessage("FieldMCFCloseDialogTitle"), 0)) == 0) {
                this._tc.sendDCCppMessage(new DCCppMessage(String.valueOf('E')), this);
                log.debug("Sending: <E> (Write To EEPROM)");
            }
        } else {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("FieldMCFCloseNoChangesDialog"));
        }
        this.dispose();
    }

    class ButtonEditor
    extends DefaultCellEditor {
        protected JButton button;
        private String label;

        public ButtonEditor(JCheckBox checkBox, JTable t) {
            super(checkBox);
            this.button = new JButton();
            this.button.setOpaque(true);
            this.button.addActionListener(e -> {});
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (isSelected) {
                this.button.setForeground(table.getSelectionForeground());
                this.button.setBackground(table.getSelectionBackground());
            } else {
                this.button.setForeground(table.getForeground());
                this.button.setBackground(table.getBackground());
            }
            this.label = value == null ? "" : value.toString();
            this.button.setText(this.label);
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            return this.label;
        }
    }

    static class ButtonRenderer
    extends JButton
    implements TableCellRenderer {
        public ButtonRenderer() {
            super.setOpaque(true);
            super.setSelected(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(UIManager.getColor("Button.background"));
            }
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    private static enum CurrentTab {
        SENSOR,
        DCCTURNOUT,
        SERVOTURNOUT,
        VPINTURNOUT,
        OUTPUT;

    }

    private static class DccTurnoutTableModel
    extends DCCppTableModel {
        public DccTurnoutTableModel() {
            super(4, 5, 6, 7);
            this.columnNames = new String[7];
            this.columnNames[0] = Bundle.getMessage("IDCol");
            this.columnNames[1] = Bundle.getMessage("AddressCol");
            this.columnNames[2] = Bundle.getMessage("FieldTableSubaddrColumn");
            this.columnNames[3] = Bundle.getMessage("ColumnDelete");
            this.columnNames[4] = "isNew";
            this.columnNames[5] = "isDirty";
            this.columnNames[6] = "isDelete";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 1: 
                case 2: {
                    return Integer.class;
                }
                case 3: {
                    return ButtonEditor.class;
                }
                case 4: 
                case 5: 
                case 6: {
                    return Boolean.class;
                }
            }
            return super.getColumnClass(columnIndex);
        }
    }

    private static class OutputTableModel
    extends DCCppTableModel {
        public OutputTableModel() {
            super(6, 7, 8, 9);
            this.columnNames = new String[9];
            this.columnNames[0] = Bundle.getMessage("IDCol");
            this.columnNames[1] = Bundle.getMessage("FieldTablePinColumn");
            this.columnNames[2] = Bundle.getMessage("FieldTableInvertColumn");
            this.columnNames[3] = Bundle.getMessage("FieldTableOutputRestoreStateColumn");
            this.columnNames[4] = Bundle.getMessage("FieldTableOutputForceToColumn");
            this.columnNames[5] = Bundle.getMessage("ColumnDelete");
            this.columnNames[6] = "isNew";
            this.columnNames[7] = "isDirty";
            this.columnNames[8] = "isDelete";
        }

        @Override
        public int getDeleteColumn() {
            return 5;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 1: {
                    return Integer.class;
                }
                case 2: 
                case 3: 
                case 4: {
                    return Boolean.class;
                }
                case 5: {
                    return ButtonEditor.class;
                }
                case 6: 
                case 7: 
                case 8: {
                    return Boolean.class;
                }
            }
            return super.getColumnClass(columnIndex);
        }
    }

    private static class SensorTableModel
    extends DCCppTableModel {
        public SensorTableModel() {
            super(4, 5, 6, 7);
            this.columnNames = new String[7];
            this.columnNames[0] = Bundle.getMessage("IDCol");
            this.columnNames[1] = Bundle.getMessage("FieldTablePinColumn");
            this.columnNames[2] = Bundle.getMessage("FieldTablePullupColumn");
            this.columnNames[3] = Bundle.getMessage("ColumnDelete");
            this.columnNames[4] = "isNew";
            this.columnNames[5] = "isDirty";
            this.columnNames[6] = "isDelete";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 1: {
                    return Integer.class;
                }
                case 2: {
                    return Boolean.class;
                }
                case 3: {
                    return ButtonEditor.class;
                }
                case 4: 
                case 5: 
                case 6: {
                    return Boolean.class;
                }
            }
            return super.getColumnClass(columnIndex);
        }
    }

    private static class ServoTurnoutTableModel
    extends DCCppTableModel {
        public ServoTurnoutTableModel() {
            super(6, 7, 8, 9);
            this.columnNames = new String[9];
            this.columnNames[0] = Bundle.getMessage("IDCol");
            this.columnNames[1] = Bundle.getMessage("PinCol");
            this.columnNames[2] = Bundle.getMessage("ThrownPosCol");
            this.columnNames[3] = Bundle.getMessage("ClosedPosCol");
            this.columnNames[4] = Bundle.getMessage("ProfileCol");
            this.columnNames[5] = Bundle.getMessage("ColumnDelete");
            this.columnNames[6] = "isNew";
            this.columnNames[7] = "isDirty";
            this.columnNames[8] = "isDelete";
        }

        @Override
        public int getDeleteColumn() {
            return 5;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return Integer.class;
                }
                case 5: {
                    return ButtonEditor.class;
                }
                case 6: 
                case 7: 
                case 8: {
                    return Boolean.class;
                }
            }
            return super.getColumnClass(columnIndex);
        }
    }

    private static class VpinTurnoutTableModel
    extends DCCppTableModel {
        public VpinTurnoutTableModel() {
            super(3, 4, 5, 6);
            this.columnNames = new String[6];
            this.columnNames[0] = Bundle.getMessage("IDCol");
            this.columnNames[1] = Bundle.getMessage("PinCol");
            this.columnNames[2] = Bundle.getMessage("ColumnDelete");
            this.columnNames[3] = "isNew";
            this.columnNames[4] = "isDirty";
            this.columnNames[5] = "isDelete";
        }

        @Override
        public int getDeleteColumn() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 1: {
                    return Integer.class;
                }
                case 2: {
                    return ButtonEditor.class;
                }
                case 3: 
                case 4: 
                case 5: {
                    return Boolean.class;
                }
            }
            return super.getColumnClass(columnIndex);
        }
    }
}

