/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp.serial;

import java.util.concurrent.DelayQueue;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.dccpp.DCCppCommandStation;
import jmri.jmrix.dccpp.DCCppListener;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppPacketizer;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialDCCppPacketizer
extends DCCppPacketizer {
    final DelayQueue<DCCppMessage> resendFunctions = new DelayQueue();
    boolean activeBackgroundRefresh = true;
    private DCCppCommandStation cs;
    private boolean backgroundRefreshStarted = false;
    private static final Logger log = LoggerFactory.getLogger(SerialDCCppPacketizer.class);

    public SerialDCCppPacketizer(DCCppCommandStation pCommandStation) {
        super(pCommandStation);
        log.debug("Loading Serial Extention to DCCppPacketizer");
        this.cs = pCommandStation;
    }

    @Override
    protected int lengthOfByteStream(AbstractMRMessage m) {
        return m.getNumDataElements() + 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueFunction(DCCppMessage m) {
        m.delayFor(250L);
        this.resendFunctions.offer(m);
        SerialDCCppPacketizer serialDCCppPacketizer = this;
        synchronized (serialDCCppPacketizer) {
            if (!this.backgroundRefreshStarted) {
                ThreadingUtil.runOnLayoutDelayed(new RefreshAction(), 250);
                this.backgroundRefreshStarted = true;
            }
        }
    }

    @Override
    public void sendDCCppMessage(DCCppMessage m, DCCppListener reply) {
        boolean isFunction = m.isFunctionMessage();
        if (isFunction) {
            this.resendFunctions.remove(m);
        }
        super.sendDCCppMessage(m, reply);
        if (isFunction && this.cs.isFunctionRefreshRequired()) {
            this.enqueueFunction(m);
        }
    }

    public void clearRefreshQueue() {
        this.resendFunctions.clear();
    }

    public int getQueueLength() {
        return this.resendFunctions.size();
    }

    public boolean setActiveRefresh(boolean activeState) {
        boolean oldActiveState = this.activeBackgroundRefresh;
        this.activeBackgroundRefresh = activeState;
        return oldActiveState;
    }

    public boolean isActiveRefresh() {
        return this.activeBackgroundRefresh;
    }

    final class RefreshAction
    implements ThreadingUtil.ThreadAction {
        RefreshAction() {
        }

        @Override
        public void run() {
            try {
                DCCppMessage message;
                if (SerialDCCppPacketizer.this.activeBackgroundRefresh && (message = (DCCppMessage)SerialDCCppPacketizer.this.resendFunctions.poll()) != null) {
                    message.setRetries(0);
                    SerialDCCppPacketizer.this.sendDCCppMessage(message, null);
                }
            }
            finally {
                ThreadingUtil.runOnLayoutDelayed(this, 250);
            }
        }
    }
}

