/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp.serial;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import jmri.jmrix.dccpp.DCCppCommandStation;
import jmri.jmrix.dccpp.DCCppInitializationManager;
import jmri.jmrix.dccpp.DCCppSerialPortController;
import jmri.jmrix.dccpp.serial.Bundle;
import jmri.jmrix.dccpp.serial.SerialDCCppPacketizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class DCCppAdapter
extends DCCppSerialPortController {
    protected String[] validSpeeds = new String[]{Bundle.getMessage("Baud115200")};
    protected int[] validSpeedValues = new int[]{115200};
    protected String[] validOption1 = new String[]{Bundle.getMessage("FlowOptionNo")};
    private boolean opened = false;
    InputStream serialStream = null;
    static volatile DCCppAdapter mInstance = null;
    private static final Logger log = LoggerFactory.getLogger(DCCppAdapter.class);

    public DCCppAdapter() {
        this.manufacturerName = "DCC++";
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            CommPortIdentifier portID = CommPortIdentifier.getPortIdentifier(portName);
            try {
                this.activeSerialPort = (SerialPort)portID.open(appName, 2000);
            }
            catch (PortInUseException p) {
                return this.handlePortBusy(p, portName, log);
            }
            try {
                this.setSerialPort();
            }
            catch (UnsupportedCommOperationException e) {
                log.error("Cannot set serial parameters on port {}: {}", (Object)portName, (Object)e.getMessage());
                return "Cannot set serial parameters on port " + portName + ": " + e.getMessage();
            }
            try {
                this.activeSerialPort.enableReceiveTimeout(10);
                log.debug("Serial timeout was observed as: {} {}", (Object)this.activeSerialPort.getReceiveTimeout(), (Object)this.activeSerialPort.isReceiveTimeoutEnabled());
            }
            catch (UnsupportedCommOperationException et) {
                log.info("failed to set serial timeout: {}", (Throwable)et);
            }
            this.serialStream = this.activeSerialPort.getInputStream();
            this.purgeStream(this.serialStream);
            log.info("{} port opened at {} baud with DTR: {} RTS: {} DSR: {} CTS: {}  CD: {}", new Object[]{portName, this.activeSerialPort.getBaudRate(), this.activeSerialPort.isDTR(), this.activeSerialPort.isRTS(), this.activeSerialPort.isDSR(), this.activeSerialPort.isCTS(), this.activeSerialPort.isCD()});
            if (log.isDebugEnabled()) {
                log.debug(" port flow control shows {}", (Object)(this.activeSerialPort.getFlowControlMode() == 2 ? "hardware flow control" : "no flow control"));
                this.setPortEventLogging(this.activeSerialPort);
            }
            this.opened = true;
        }
        catch (NoSuchPortException p) {
            return this.handlePortNotFound(p, portName, log);
        }
        catch (IOException ex) {
            log.error("Unexpected exception while opening port {}", (Object)portName, (Object)ex);
            return "Unexpected error while opening port " + portName + ": " + ex;
        }
        return null;
    }

    @Override
    public void configure() {
        SerialDCCppPacketizer packets = new SerialDCCppPacketizer(new DCCppCommandStation());
        packets.connectPort(this);
        this.getSystemConnectionMemo().setDCCppTrafficController(packets);
        new DCCppInitializationManager(this.getSystemConnectionMemo());
    }

    public BufferedReader getInputStreamBR() {
        if (!this.opened) {
            log.error("getInputStream called before load(), stream not available");
            return null;
        }
        return new BufferedReader(new InputStreamReader(this.serialStream));
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened) {
            log.error("getInputStream called before load(), stream not available");
        }
        try {
            return new DataInputStream(this.activeSerialPort.getInputStream());
        }
        catch (IOException e) {
            log.error("getInputStream exception: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened) {
            log.error("getOutputStream called before load(), stream not available");
        }
        try {
            return new DataOutputStream(this.activeSerialPort.getOutputStream());
        }
        catch (IOException e) {
            log.error("getOutputStream exception: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    protected void setSerialPort() throws UnsupportedCommOperationException {
        int baud = this.currentBaudNumber(this.mBaudRate);
        this.activeSerialPort.setSerialPortParams(baud, 8, 1, 0);
        int flow = 0;
        this.configureLeadsAndFlowControl(this.activeSerialPort, flow);
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }

    @Deprecated
    public static DCCppAdapter instance() {
        if (mInstance == null) {
            mInstance = new DCCppAdapter();
        }
        return mInstance;
    }
}

