/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp.network;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRTrafficController;
import jmri.jmrix.dccpp.DCCppCommandStation;
import jmri.jmrix.dccpp.serial.SerialDCCppPacketizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppEthernetPacketizer
extends SerialDCCppPacketizer {
    private static final Logger log = LoggerFactory.getLogger(DCCppEthernetPacketizer.class);

    public DCCppEthernetPacketizer(DCCppCommandStation pCommandStation) {
        super(pCommandStation);
        log.debug("Loading DCC++ Ethernet Extension to DCCppPacketizer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"TLW_TWO_LOCK_WAIT"}, justification="Two locks needed for synchronization here, this is OK")
    protected synchronized void forwardToPort(AbstractMRMessage m, AbstractMRListener reply) {
        block16: {
            log.debug("forwardToPort message: [{}]", (Object)m);
            this.mLastSender = reply;
            AbstractMRTrafficController.XmtNotifier r = new AbstractMRTrafficController.XmtNotifier(m, this.mLastSender, this);
            SwingUtilities.invokeLater(r);
            byte[] msg = new byte[this.lengthOfByteStream(m)];
            int offset = this.addHeaderToOutput(msg, m);
            int len = m.getNumDataElements();
            int i = 0;
            while (i < len) {
                msg[i + offset] = (byte)m.getElement(i);
                ++i;
            }
            this.addTrailerToOutput(msg, len + offset, m);
            try {
                if (this.ostream != null) {
                    if (log.isDebugEnabled()) {
                        StringBuilder f = new StringBuilder("formatted message: ");
                        byte[] byArray = msg;
                        int n = msg.length;
                        int n2 = 0;
                        while (n2 < n) {
                            byte b = byArray[n2];
                            f.append(Integer.toHexString(0xFF & b));
                            f.append(" ");
                            ++n2;
                        }
                        log.debug(f.toString());
                    }
                    while (m.getRetries() >= 0) {
                        if (this.portReadyToSend(this.controller)) {
                            this.ostream.write(msg);
                            this.ostream.flush();
                            log.debug("written, msg timeout: {} mSec", (Object)m.getTimeout());
                            break block16;
                        }
                        if (m.getRetries() >= 0) {
                            if (log.isDebugEnabled()) {
                                log.debug("Retry message: '{}' attempts remaining: {}", (Object)m, (Object)m.getRetries());
                            }
                            m.setRetries(m.getRetries() - 1);
                            try {
                                int timeOut = m.getTimeout();
                                Runnable runnable = this.xmtRunnable;
                                synchronized (runnable) {
                                    if (timeOut > 0) {
                                        this.xmtRunnable.wait(timeOut);
                                    }
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                                log.error("retry wait interrupted");
                            }
                            continue;
                        }
                        log.warn("sendMessage: port not ready for data sending: {}", (Object)Arrays.toString(msg));
                    }
                    break block16;
                }
                this.connectionWarn();
            }
            catch (IOException e) {
                this.portWarn(e);
                this.controller.recover();
            }
        }
    }
}

