/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp.network;

import java.io.IOException;
import java.util.TimerTask;
import jmri.jmrix.dccpp.DCCppCommandStation;
import jmri.jmrix.dccpp.DCCppInitializationManager;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppNetworkPortController;
import jmri.jmrix.dccpp.network.Bundle;
import jmri.jmrix.dccpp.network.DCCppEthernetPacketizer;
import jmri.util.TimerUtil;
import jmri.util.zeroconf.ZeroConfClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppEthernetAdapter
extends DCCppNetworkPortController {
    static final int COMMUNICATION_TCP_PORT = 2560;
    static final String DEFAULT_IP_ADDRESS = "192.168.0.200";
    private TimerTask keepAliveTimer;
    private static final long keepAliveTimeoutValue = 30000L;
    private boolean mDNSConfigure = false;
    ZeroConfClient mdnsClient = null;
    private static final Logger log = LoggerFactory.getLogger(DCCppEthernetAdapter.class);

    public DCCppEthernetAdapter() {
        log.debug("Constructor Called");
        this.setHostName(DEFAULT_IP_ADDRESS);
        this.setPort(2560);
        this.manufacturerName = "DCC++";
    }

    @Override
    public void connect() throws IOException {
        super.connect();
        log.debug("openPort called");
        this.keepAliveTimer();
    }

    @Override
    public boolean okToSend() {
        return this.status();
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public void configure() {
        log.debug("configure called");
        DCCppEthernetPacketizer packets = new DCCppEthernetPacketizer(new DCCppCommandStation());
        packets.connectPort(this);
        this.getSystemConnectionMemo().setDCCppTrafficController(packets);
        new DCCppInitializationManager(this.getSystemConnectionMemo());
    }

    private void keepAliveTimer() {
        if (this.keepAliveTimer == null) {
            this.keepAliveTimer = new TimerTask(){

                @Override
                public void run() {
                    DCCppEthernetAdapter.this.getSystemConnectionMemo().getDCCppTrafficController().sendDCCppMessage(DCCppMessage.makeCSStatusMsg(), null);
                }
            };
        } else {
            this.keepAliveTimer.cancel();
        }
        TimerUtil.schedule(this.keepAliveTimer, 30000L, 30000L);
    }

    @Override
    public void setMdnsConfigure(boolean autoconfig) {
        log.debug("Setting DCC++ Ethernet adapter autoconfiguration to: {}", (Object)autoconfig);
        this.mDNSConfigure = autoconfig;
    }

    @Override
    public boolean getMdnsConfigure() {
        return this.mDNSConfigure;
    }

    @Override
    public void autoConfigure() {
        log.info("Configuring DCC++ interface via JmDNS");
        if (this.getHostName().equals(DEFAULT_IP_ADDRESS)) {
            this.setHostName("");
        }
        String serviceType = Bundle.getMessage("defaultMDNSServiceType");
        log.debug("Listening for service: {}", (Object)serviceType);
        if (this.mdnsClient == null) {
            this.mdnsClient = new ZeroConfClient();
            this.mdnsClient.startServiceListener(serviceType);
        }
        try {
            String qualifiedHostName = String.valueOf(this.m_HostName) + "." + Bundle.getMessage("defaultMDNSDomainName");
            this.setHostAddress(this.mdnsClient.getServiceOnHost(serviceType, qualifiedHostName).getHostAddresses()[0]);
        }
        catch (NullPointerException nullPointerException) {
            String qualifiedServiceName = String.valueOf(Bundle.getMessage("defaultMDNSServiceName")) + "." + serviceType;
            this.setHostAddress(this.mdnsClient.getServicebyAdName(serviceType, qualifiedServiceName).getHostAddresses()[0]);
        }
    }

    @Override
    public String getAdvertisementName() {
        return Bundle.getMessage("defaultMDNSServiceName");
    }

    @Override
    public String getServiceType() {
        return Bundle.getMessage("defaultMDNSServiceType");
    }
}

