/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp.dccppovertcp;

import java.awt.event.WindowEvent;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoInitialize;
import jmri.implementation.AbstractInstanceInitializer;
import jmri.jmrix.dccpp.dccppovertcp.Bundle;
import jmri.jmrix.dccpp.dccppovertcp.Server;
import jmri.jmrix.dccpp.dccppovertcp.ServerListner;
import jmri.util.JmriJFrame;

public class ServerFrame
extends JmriJFrame
implements ServerListner,
InstanceManagerAutoInitialize {
    JSpinner portNumber;
    SpinnerNumberModel portNumberModel;
    JLabel portNumberLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("LabelPort")));
    private final JLabel statusLabel = new JLabel(Bundle.getMessage("StatusLabel", Bundle.getMessage("Stopped"), 0));
    JCheckBox autoStartCheckBox = new JCheckBox(Bundle.getMessage("LabelStartup"));
    JButton startButton = new JButton(Bundle.getMessage("StartServer"));
    JButton stopButton = new JButton(Bundle.getMessage("StopServer"));
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));

    private ServerFrame() {
        super("DCCppOverTcp Server");
        super.getContentPane().setLayout(new BoxLayout(super.getContentPane(), 1));
        this.portNumber = new JSpinner();
        this.portNumberModel = new SpinnerNumberModel(65535, 1, 65535, 1);
        this.portNumber.setModel(this.portNumberModel);
        this.portNumber.setFocusable(false);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.autoStartCheckBox);
        panel.add(this.portNumberLabel);
        panel.add(this.portNumber);
        super.getContentPane().add(panel);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.startButton);
        panel.add(this.stopButton);
        panel.add(this.saveButton);
        super.getContentPane().add(panel);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.statusLabel);
        super.getContentPane().add(panel);
        this.startButton.addActionListener(a -> InstanceManager.getDefault(Server.class).enable());
        this.stopButton.addActionListener(a -> InstanceManager.getDefault(Server.class).disable());
        this.saveButton.addActionListener(a -> {
            InstanceManager.getDefault(Server.class).setAutoStart(this.autoStartCheckBox.isSelected());
            InstanceManager.getDefault(Server.class).setPortNumber((Integer)this.portNumber.getValue());
            InstanceManager.getDefault(Server.class).saveSettings();
        });
        this.autoStartCheckBox.addActionListener(a -> this.saveButton.setEnabled(true));
        this.portNumber.addChangeListener(e -> this.saveButton.setEnabled(true));
        super.pack();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
        InstanceManager.getDefault(Server.class).setStateListner(null);
        InstanceManager.deregister(this, ServerFrame.class);
        this.dispose();
        super.windowClosing(e);
    }

    private void updateServerStatus() {
        Server server = InstanceManager.getDefault(Server.class);
        this.autoStartCheckBox.setSelected(server.getAutoStart());
        this.autoStartCheckBox.setEnabled(!server.isEnabled());
        this.portNumber.setValue(server.getPortNumber());
        this.portNumber.setEnabled(!server.isEnabled());
        this.portNumberLabel.setEnabled(!server.isEnabled());
        this.startButton.setEnabled(!server.isEnabled());
        this.stopButton.setEnabled(server.isEnabled());
        this.saveButton.setEnabled(server.isSettingChanged());
        this.updateClientStatus(server);
    }

    private void updateClientStatus(Server s) {
        this.statusLabel.setText(Bundle.getMessage("StatusLabel", s.isEnabled() ? Bundle.getMessage("Running") : Bundle.getMessage("Stopped"), s.getClientCount()));
    }

    @Override
    public void notifyServerStateChanged(Server s) {
        SwingUtilities.invokeLater(() -> this.updateServerStatus());
    }

    @Override
    public void notifyClientStateChanged(Server s) {
        SwingUtilities.invokeLater(() -> this.updateClientStatus(s));
    }

    @Override
    public void initialize() {
        Server server = InstanceManager.getDefault(Server.class);
        server.setStateListner(this);
        server.updateServerStateListener();
        server.updateClinetStateListener();
    }

    /* synthetic */ ServerFrame(ServerFrame serverFrame) {
        this();
    }

    public static class Initializer
    extends AbstractInstanceInitializer {
        @Override
        @Nonnull
        public <T> Object getDefault(Class<T> type) {
            if (type.equals(ServerFrame.class)) {
                return new ServerFrame(null);
            }
            return super.getDefault(type);
        }

        @Override
        @Nonnull
        public Set<Class<?>> getInitalizes() {
            Set<Class<?>> set = super.getInitalizes();
            set.add(ServerFrame.class);
            return set;
        }
    }
}

