/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp.dccppovertcp;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import jmri.InstanceManager;
import jmri.ShutDownManager;
import jmri.implementation.AbstractInstanceInitializer;
import jmri.jmrix.dccpp.dccppovertcp.ClientRxHandler;
import jmri.jmrix.dccpp.dccppovertcp.ServerListner;
import jmri.util.FileUtil;
import jmri.util.zeroconf.ZeroConfService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server {
    private final LinkedList<ClientRxHandler> clients = new LinkedList();
    Thread socketListener;
    ServerSocket serverSocket;
    boolean settingsLoaded = false;
    ServerListner stateListner;
    boolean settingsChanged = false;
    Runnable shutDownTask;
    ZeroConfService service = null;
    static final String AUTO_START_KEY = "AutoStart";
    static final String PORT_NUMBER_KEY = "PortNumber";
    static final String SETTINGS_FILE_NAME = "DCCppOverTcpSettings.ini";
    private boolean autoStart;
    private int portNumber = 1235;
    private static final Logger log = LoggerFactory.getLogger(Server.class);

    private Server() {
    }

    public void setStateListner(ServerListner l) {
        this.stateListner = l;
    }

    private void loadSettings() {
        if (!this.settingsLoaded) {
            this.settingsLoaded = true;
            Properties settings = new Properties();
            String settingsFileName = String.valueOf(FileUtil.getUserFilesPath()) + SETTINGS_FILE_NAME;
            try {
                log.debug("Server: opening settings file {}", (Object)settingsFileName);
                try (FileInputStream settingsStream = new FileInputStream(settingsFileName);){
                    settings.load(settingsStream);
                }
                String val = settings.getProperty(AUTO_START_KEY, "0");
                this.autoStart = val.equals("1");
                val = settings.getProperty(PORT_NUMBER_KEY, Integer.toString(1235));
                this.portNumber = Integer.parseInt(val, 10);
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.debug("Server: loadSettings file not found");
            }
            catch (IOException ex) {
                log.debug("Server: loadSettings exception: ", (Throwable)ex);
            }
            this.updateServerStateListener();
        }
    }

    public void saveSettings() {
        String settingsFileName = String.valueOf(FileUtil.getUserFilesPath()) + SETTINGS_FILE_NAME;
        log.debug("Server: saving settings file {}", (Object)settingsFileName);
        try {
            FileOutputStream outStream = new FileOutputStream(settingsFileName);
            PrintStream settingsStream = new PrintStream(outStream);
            settingsStream.println("# DCCppOverTcp Configuration Settings");
            settingsStream.println("AutoStart = " + (this.autoStart ? "1" : "0"));
            settingsStream.println("PortNumber = " + this.portNumber);
            settingsStream.flush();
            settingsStream.close();
            this.settingsChanged = false;
        }
        catch (FileNotFoundException ex) {
            log.warn("Server: saveSettings exception: ", (Throwable)ex);
        }
        this.updateServerStateListener();
    }

    public boolean getAutoStart() {
        this.loadSettings();
        return this.autoStart;
    }

    public void setAutoStart(boolean start) {
        this.loadSettings();
        this.autoStart = start;
        this.settingsChanged = true;
        this.updateServerStateListener();
    }

    public int getPortNumber() {
        this.loadSettings();
        return this.portNumber;
    }

    public void setPortNumber(int port) {
        this.loadSettings();
        if (port >= 1024 && port <= 65535) {
            this.portNumber = port;
            this.settingsChanged = true;
            this.updateServerStateListener();
        }
    }

    public boolean isEnabled() {
        return this.socketListener != null && this.socketListener.isAlive();
    }

    public boolean isSettingChanged() {
        return this.settingsChanged;
    }

    public void enable() {
        if (this.socketListener == null) {
            this.socketListener = new Thread(new ClientListener());
            this.socketListener.setDaemon(true);
            this.socketListener.setName("DCCppOverTcpServer");
            log.info("Starting new DCCppOverTcpServer listener on port {}", (Object)this.portNumber);
            this.socketListener.start();
            this.updateServerStateListener();
            if (this.service == null) {
                this.service = ZeroConfService.create("_dccppovertcpserver._tcp.local.", this.portNumber);
            }
            log.info("Starting ZeroConfService _dccppovertcpserver._tcp.local for DCCppOverTCP Server");
            this.service.publish();
            if (this.shutDownTask == null) {
                this.shutDownTask = this::disable;
            }
            if (this.shutDownTask != null) {
                InstanceManager.getDefault(ShutDownManager.class).register(this.shutDownTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        if (this.socketListener != null) {
            Object[] clientsArray;
            this.socketListener.interrupt();
            this.socketListener = null;
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (IOException iOException) {}
            this.updateServerStateListener();
            LinkedList<ClientRxHandler> linkedList = this.clients;
            synchronized (linkedList) {
                clientsArray = this.clients.toArray();
            }
            int i = 0;
            while (i < clientsArray.length) {
                ((ClientRxHandler)clientsArray[i]).close();
                ++i;
            }
        }
        this.service.stop();
        if (this.shutDownTask != null) {
            InstanceManager.getDefault(ShutDownManager.class).deregister(this.shutDownTask);
        }
    }

    public void updateServerStateListener() {
        if (this.stateListner != null) {
            this.stateListner.notifyServerStateChanged(this);
        }
    }

    public void updateClinetStateListener() {
        if (this.stateListner != null) {
            this.stateListner.notifyClientStateChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addClient(ClientRxHandler handler) {
        LinkedList<ClientRxHandler> linkedList = this.clients;
        synchronized (linkedList) {
            this.clients.add(handler);
        }
        this.updateClinetStateListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeClient(ClientRxHandler handler) {
        LinkedList<ClientRxHandler> linkedList = this.clients;
        synchronized (linkedList) {
            this.clients.remove(handler);
        }
        this.updateClinetStateListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientCount() {
        LinkedList<ClientRxHandler> linkedList = this.clients;
        synchronized (linkedList) {
            return this.clients.size();
        }
    }

    /* synthetic */ Server(Server server) {
        this();
    }

    class ClientListener
    implements Runnable {
        ClientListener() {
        }

        @Override
        public void run() {
            block3: {
                try {
                    Server.this.serverSocket = new ServerSocket(Server.this.getPortNumber());
                    Server.this.serverSocket.setReuseAddress(true);
                    while (!Server.this.socketListener.isInterrupted()) {
                        Socket newClientConnection = Server.this.serverSocket.accept();
                        String remoteAddress = newClientConnection.getRemoteSocketAddress().toString();
                        log.info("Server: Connection from: {}", (Object)remoteAddress);
                        Server.this.addClient(new ClientRxHandler(remoteAddress, newClientConnection));
                    }
                    Server.this.serverSocket.close();
                }
                catch (IOException ex) {
                    if (ex.toString().indexOf("socket closed") != -1) break block3;
                    log.error("Server: IO Exception: ", (Throwable)ex);
                }
            }
            Server.this.serverSocket = null;
        }
    }

    public static class Initializer
    extends AbstractInstanceInitializer {
        @Override
        public <T> Object getDefault(Class<T> type) {
            if (type.equals(Server.class)) {
                Server instance = new Server(null);
                if (instance.getAutoStart()) {
                    instance.enable();
                }
                return instance;
            }
            return super.getDefault(type);
        }

        @Override
        public Set<Class<?>> getInitalizes() {
            Set<Class<?>> set = super.getInitalizes();
            set.add(Server.class);
            return set;
        }
    }
}

