/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import jmri.implementation.AbstractTurnout;
import jmri.jmrix.dccpp.DCCppListener;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppReply;
import jmri.jmrix.dccpp.DCCppTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppTurnout
extends AbstractTurnout
implements DCCppListener {
    protected static final int COMMANDSENT = 2;
    protected static final int STATUSREQUESTSENT = 4;
    protected static final int IDLE = 0;
    protected int internalState = 0;
    static String[] modeNames = null;
    static int[] modeValues = null;
    protected String _prefix = "D";
    protected DCCppTrafficController tc = null;
    protected int mNumber;
    DCCppTurnoutStateListener _stateListener;
    private static final Logger log = LoggerFactory.getLogger(DCCppTurnout.class);

    public DCCppTurnout(String prefix, int pNumber, DCCppTrafficController controller) {
        super(String.valueOf(prefix) + "T" + pNumber);
        this.tc = controller;
        this._prefix = prefix;
        this.mNumber = pNumber;
        this._validFeedbackTypes |= 8;
        this._validFeedbackTypes |= 2;
        this._activeFeedbackType = 1;
        DCCppTurnout.setModeInformation(this._validFeedbackNames, this._validFeedbackModes);
        this._validFeedbackNames = DCCppTurnout.getModeNames();
        this._validFeedbackModes = DCCppTurnout.getModeValues();
        this._stateListener = new DCCppTurnoutStateListener(this);
        this.addPropertyChangeListener(this._stateListener);
        this.tc.getTurnoutReplyCache().requestCachedStateFromLayout(this);
    }

    private static synchronized void setModeInformation(String[] feedbackNames, int[] feedbackModes) {
        if (modeNames == null) {
            if (feedbackNames.length != feedbackModes.length) {
                log.error("int and string feedback arrays different length");
            }
            modeNames = new String[feedbackNames.length + 2];
            modeValues = new int[feedbackNames.length + 2];
            int i = 0;
            while (i < feedbackNames.length) {
                DCCppTurnout.modeNames[i] = feedbackNames[i];
                DCCppTurnout.modeValues[i] = feedbackModes[i];
                ++i;
            }
            DCCppTurnout.modeNames[feedbackNames.length] = "BSTURNOUT";
            DCCppTurnout.modeValues[feedbackNames.length] = 8;
            DCCppTurnout.modeNames[feedbackNames.length + 1] = "BSOUTPUT";
            DCCppTurnout.modeValues[feedbackNames.length + 1] = 2;
        }
    }

    static int[] getModeValues() {
        return modeValues;
    }

    static String[] getModeNames() {
        return modeNames;
    }

    public int getNumber() {
        return this.mNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCommandedState(int s) {
        log.debug("set commanded state for turnout {} to {}", (Object)this.getSystemName(), (Object)s);
        DCCppTurnout dCCppTurnout = this;
        synchronized (dCCppTurnout) {
            this.newCommandedState(s);
        }
        this.forwardCommandChangeToLayout(s);
        if (this._activeFeedbackType == 2 || this._activeFeedbackType == 8) {
            dCCppTurnout = this;
            synchronized (dCCppTurnout) {
                this.newKnownState(8);
            }
        }
        if (this._activeFeedbackType == 1) {
            dCCppTurnout = this;
            synchronized (dCCppTurnout) {
                this.newKnownState(s);
            }
        }
    }

    @Override
    protected synchronized void forwardCommandChangeToLayout(int s) {
        DCCppMessage msg;
        boolean newState;
        if (s != 2 && s != 4) {
            log.warn("Turnout {}: state {} not forwarded to layout.", (Object)this.mNumber, (Object)s);
            return;
        }
        boolean bl = newState = s == 4;
        if (this.getInverted()) {
            newState = !newState;
        }
        switch (this._activeFeedbackType) {
            case 2: {
                msg = DCCppMessage.makeOutputCmdMsg(this.mNumber, !newState);
                this.internalState = 2;
                break;
            }
            case 8: {
                msg = DCCppMessage.makeTurnoutCommandMsg(this.mNumber, newState);
                this.internalState = 2;
                break;
            }
            default: {
                msg = DCCppMessage.makeAccessoryDecoderMsg(this.mNumber, newState);
                this.internalState = 0;
            }
        }
        log.debug("Sending Message: '{}'", (Object)msg);
        this.tc.sendDCCppMessage(msg, null);
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean _pushButtonLockout) {
        log.debug("Send command to {} Pushbutton {}T{}", new Object[]{_pushButtonLockout ? "Lock" : "Unlock", this._prefix, this.mNumber});
    }

    @Override
    public void requestUpdateFromLayout() {
        super.requestUpdateFromLayout();
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    synchronized void initmessage(DCCppReply l) {
        int oldState = this.internalState;
        this.message(l);
        this.internalState = oldState;
    }

    @Override
    public synchronized void message(DCCppReply l) {
        if (l.isTurnoutDefDCCReply() || l.isTurnoutDefServoReply() || l.isTurnoutDefVpinReply() || l.isTurnoutDefLCNReply()) {
            l.getProperties().forEach((key, value) -> this.setProperty((String)key, value));
        }
        switch (this.getFeedbackMode()) {
            case 2: {
                this.handleExactModeFeedback(l);
                break;
            }
            case 8: {
                this.handleMonitoringModeFeedback(l);
            }
        }
    }

    @Override
    public void message(DCCppMessage l) {
    }

    @Override
    public void notifyTimeout(DCCppMessage msg) {
        log.debug("Notified of timeout on message '{}'", (Object)msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void handleMonitoringModeFeedback(DCCppReply l) {
        log.debug("Handle Message for turnout {} in MONITORING feedback mode", (Object)this.mNumber);
        if (l.isTurnoutReply() && l.getTOIDInt() == this.mNumber) {
            if (l.getTOIsThrown()) {
                log.debug("Turnout is Thrown. Inverted = {}", (Object)(this.getInverted() ? "True" : "False"));
                DCCppTurnout dCCppTurnout = this;
                synchronized (dCCppTurnout) {
                    this.newCommandedState(this.getInverted() ? 2 : 4);
                    this.newKnownState(this.getCommandedState());
                }
            }
            if (l.getTOIsClosed()) {
                log.debug("Turnout is Closed. Inverted = {}", (Object)(this.getInverted() ? "True" : "False"));
                DCCppTurnout dCCppTurnout = this;
                synchronized (dCCppTurnout) {
                    this.newCommandedState(this.getInverted() ? 4 : 2);
                    this.newKnownState(this.getCommandedState());
                }
            }
            this.internalState = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void handleExactModeFeedback(DCCppReply l) {
        log.debug("Handle Message for turnout {} in EXACT feedback mode", (Object)this.mNumber);
        if (l.isOutputCmdReply() && l.getOutputNumInt() == this.mNumber) {
            if (l.getOutputIsLow()) {
                log.debug("Turnout is Thrown. Inverted = {}", (Object)(this.getInverted() ? "True" : "False"));
                DCCppTurnout dCCppTurnout = this;
                synchronized (dCCppTurnout) {
                    this.newCommandedState(this.getInverted() ? 2 : 4);
                    this.newKnownState(this.getCommandedState());
                }
            }
            if (l.getOutputIsHigh()) {
                log.debug("Turnout is Closed. Inverted = {}", (Object)(this.getInverted() ? "True" : "False"));
                DCCppTurnout dCCppTurnout = this;
                synchronized (dCCppTurnout) {
                    this.newCommandedState(this.getInverted() ? 4 : 2);
                    this.newKnownState(this.getCommandedState());
                }
            }
            this.internalState = 0;
        }
    }

    @Override
    public void dispose() {
        this.removePropertyChangeListener(this._stateListener);
        super.dispose();
    }

    private static class DCCppTurnoutStateListener
    implements PropertyChangeListener {
        DCCppTurnout _turnout = null;

        DCCppTurnoutStateListener(DCCppTurnout turnout) {
            this._turnout = turnout;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            log.debug("propertyChange called");
            if (this._turnout.getFeedbackMode() != 1) {
                if (log.isDebugEnabled()) {
                    log.debug("propertyChange Not Direct Mode property: {} old value {} new value {}", new Object[]{event.getPropertyName(), event.getOldValue(), event.getNewValue()});
                }
                if (event.getPropertyName().equals("KnownState")) {
                    int oldKnownState = (Integer)event.getOldValue();
                    int curKnownState = (Integer)event.getNewValue();
                    log.debug("propertyChange KnownState - old value {} new value {}", (Object)oldKnownState, (Object)curKnownState);
                    if (curKnownState != 8 && this._turnout.getCommandedState() == oldKnownState) {
                        if (log.isDebugEnabled()) {
                            log.debug("propertyChange CommandedState: {}", (Object)this._turnout.getCommandedState());
                        }
                        this._turnout.newCommandedState(curKnownState);
                    } else if (oldKnownState == 8 && log.isDebugEnabled()) {
                        log.debug("propertyChange CommandedState: {}", (Object)this._turnout.getCommandedState());
                    }
                }
            }
        }
    }
}

