/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.AbstractMRTrafficController;
import jmri.jmrix.dccpp.DCCppCommandStation;
import jmri.jmrix.dccpp.DCCppInterface;
import jmri.jmrix.dccpp.DCCppListener;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppProgrammer;
import jmri.jmrix.dccpp.DCCppReply;
import jmri.jmrix.dccpp.DCCppSystemConnectionMemo;
import jmri.jmrix.dccpp.DCCppTurnoutReplyCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DCCppTrafficController
extends AbstractMRTrafficController
implements DCCppInterface {
    protected HashMap<DCCppListener, Integer> mListenerMasks;
    LinkedBlockingQueue<DCCppMessage> highPriorityQueue;
    LinkedBlockingQueue<DCCppListener> highPriorityListeners;
    DCCppCommandStation mCommandStation;
    DCCppSystemConnectionMemo mMemo = null;
    private DCCppTurnoutReplyCache _TurnoutReplyCache = null;
    private static final Logger log = LoggerFactory.getLogger(DCCppTrafficController.class);

    @Override
    protected void transmitLoop() {
        log.debug("Don't start sending for 1.5 seconds to avoid Arduino restart");
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        super.transmitLoop();
    }

    DCCppTrafficController(DCCppCommandStation pCommandStation) {
        this.mCommandStation = pCommandStation;
        this.setAllowUnexpectedReply(true);
        this.mListenerMasks = new HashMap();
        this.highPriorityQueue = new LinkedBlockingQueue();
        this.highPriorityListeners = new LinkedBlockingQueue();
        log.debug("DCCppTrafficController created");
    }

    @Override
    public abstract void sendDCCppMessage(DCCppMessage var1, DCCppListener var2);

    @Override
    protected int lengthOfByteStream(AbstractMRMessage m) {
        int len = m.getNumDataElements();
        return len + 2;
    }

    @Override
    public void forwardMessage(AbstractMRListener reply, AbstractMRMessage m) {
        if (reply instanceof DCCppListener && m instanceof DCCppMessage) {
            ((DCCppListener)reply).message((DCCppMessage)m);
        }
    }

    @Override
    public void forwardReply(AbstractMRListener client, AbstractMRReply m) {
        if (!(client instanceof DCCppListener)) {
            return;
        }
        if (!(m instanceof DCCppReply)) {
            return;
        }
        try {
            ((DCCppListener)client).message((DCCppReply)m);
        }
        catch (NullPointerException nullPointerException) {
            ((DCCppListener)client).message((DCCppReply)m);
        }
    }

    public void sendHighPriorityDCCppMessage(DCCppMessage m, DCCppListener reply) {
        try {
            this.highPriorityQueue.put(m);
            this.highPriorityListeners.put(reply);
        }
        catch (InterruptedException interruptedException) {
            log.error("Interrupted while adding High Priority Message to Queue");
        }
    }

    @Override
    protected AbstractMRMessage pollMessage() {
        block3: {
            try {
                if (this.highPriorityQueue.peek() != null) break block3;
                return null;
            }
            catch (InterruptedException interruptedException) {
                log.error("Interrupted while removing High Priority Message from Queue");
                return null;
            }
        }
        return this.highPriorityQueue.take();
    }

    @Override
    protected AbstractMRListener pollReplyHandler() {
        block3: {
            try {
                if (this.highPriorityListeners.peek() != null) break block3;
                return null;
            }
            catch (InterruptedException interruptedException) {
                log.error("Interrupted while removing High Priority Message Listener from Queue");
                return null;
            }
        }
        return this.highPriorityListeners.take();
    }

    @Override
    public synchronized void addDCCppListener(int mask, DCCppListener l) {
        this.addListener(l);
        this.mListenerMasks.put(l, mask);
    }

    @Override
    public synchronized void removeDCCppListener(int mask, DCCppListener l) {
        this.removeListener(l);
        this.mListenerMasks.remove(l);
    }

    @Override
    protected AbstractMRMessage enterProgMode() {
        return null;
    }

    @Override
    protected AbstractMRMessage enterNormalMode() {
        return null;
    }

    @Override
    protected boolean programmerIdle() {
        if (this.mMemo == null) {
            return true;
        }
        DCCppProgrammer progrmr = (DCCppProgrammer)this.mMemo.getProgrammerManager().getGlobalProgrammer();
        if (progrmr != null) {
            return !progrmr.programmerBusy();
        }
        log.warn("Unable to fetch DCCppProgrammer");
        return true;
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply msg) {
        return msg.getElement(msg.getNumDataElements() - 1) == 62;
    }

    @Override
    protected AbstractMRReply newReply() {
        return new DCCppReply();
    }

    @Override
    protected void handleTimeout(AbstractMRMessage msg, AbstractMRListener l) {
        super.handleTimeout(msg, l);
        if (l != null) {
            ((DCCppListener)l).notifyTimeout((DCCppMessage)msg);
        }
    }

    public DCCppCommandStation getCommandStation() {
        return this.mCommandStation;
    }

    public DCCppSystemConnectionMemo getSystemConnectionMemo() {
        return this.mMemo;
    }

    public void setSystemConnectionMemo(DCCppSystemConnectionMemo m) {
        this.mMemo = m;
    }

    public DCCppTurnoutReplyCache getTurnoutReplyCache() {
        if (this._TurnoutReplyCache == null) {
            this._TurnoutReplyCache = new DCCppTurnoutReplyCache(this);
        }
        return this._TurnoutReplyCache;
    }
}

