/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import java.util.concurrent.LinkedBlockingQueue;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.dccpp.DCCppCommandStation;
import jmri.jmrix.dccpp.DCCppListener;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppReply;
import jmri.jmrix.dccpp.DCCppSystemConnectionMemo;
import jmri.jmrix.dccpp.DCCppThrottleManager;
import jmri.jmrix.dccpp.DCCppTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppThrottle
extends AbstractThrottle
implements DCCppListener {
    protected DCCppTrafficController tc;
    protected static final int THROTTLEIDLE = 0;
    protected static final int THROTTLESPEEDSENT = 2;
    protected static final int THROTTLEFUNCSENT = 4;
    public int requestState = 0;
    protected int address;
    protected LinkedBlockingQueue<RequestMessage> requestList;
    private static final Logger log = LoggerFactory.getLogger(DCCppThrottle.class);

    public DCCppThrottle(DCCppSystemConnectionMemo memo, DCCppTrafficController controller) {
        super(memo);
        this.tc = controller;
        this.requestList = new LinkedBlockingQueue();
        this.isForward = true;
        log.debug("DCCppThrottle constructor");
    }

    public DCCppThrottle(DCCppSystemConnectionMemo memo, LocoAddress address, DCCppTrafficController controller) {
        super(memo);
        this.tc = controller;
        if (address instanceof DccLocoAddress) {
            this.setDccAddress(address.getNumber());
        } else {
            log.error("LocoAddress {} is not a DccLocoAddress", (Object)address);
        }
        this.speedStepMode = SpeedStepMode.NMRA_DCC_128;
        this.requestList = new LinkedBlockingQueue();
        this.isForward = true;
        log.debug("DCCppThrottle constructor called for address {}", (Object)address);
    }

    public void setDCCppTrafficController(DCCppTrafficController controller) {
        this.tc = controller;
    }

    int getRegisterNum() {
        return this.tc.getCommandStation().getRegisterNum(this.getDccAddress());
    }

    @Override
    protected void sendFunctionGroup1() {
        log.debug("sendFunctionGroup1(): f0 {} f1 {} f2 {} f3 {} f4{}", new Object[]{this.getFunction(0), this.getFunction(1), this.getFunction(2), this.getFunction(3), this.getFunction(4)});
        DCCppMessage msg = DCCppMessage.makeFunctionGroup1OpsMsg(this.getDccAddress(), this.getFunction(0), this.getFunction(1), this.getFunction(2), this.getFunction(3), this.getFunction(4));
        log.debug("sendFunctionGroup1(): Message: {}", (Object)msg);
        this.queueMessage(msg, 0);
    }

    @Override
    protected void sendFunctionGroup2() {
        DCCppMessage msg = DCCppMessage.makeFunctionGroup2OpsMsg(this.getDccAddress(), this.getFunction(5), this.getFunction(6), this.getFunction(7), this.getFunction(8));
        this.queueMessage(msg, 0);
    }

    @Override
    protected void sendFunctionGroup3() {
        DCCppMessage msg = DCCppMessage.makeFunctionGroup3OpsMsg(this.getDccAddress(), this.getFunction(9), this.getFunction(10), this.getFunction(11), this.getFunction(12));
        this.queueMessage(msg, 0);
    }

    @Override
    protected void sendFunctionGroup4() {
        DCCppMessage msg = DCCppMessage.makeFunctionGroup4OpsMsg(this.getDccAddress(), this.getFunction(13), this.getFunction(14), this.getFunction(15), this.getFunction(16), this.getFunction(17), this.getFunction(18), this.getFunction(19), this.getFunction(20));
        this.queueMessage(msg, 0);
    }

    @Override
    protected void sendFunctionGroup5() {
        log.debug("sendFunctionGroup5(): f21 {} f22 {} f23 {} f24 {} f25 {} f26 {} f27 {} f28 {}", new Object[]{this.getFunction(21), this.getFunction(22), this.getFunction(23), this.getFunction(24), this.getFunction(25), this.getFunction(26), this.getFunction(27), this.getFunction(28)});
        DCCppMessage msg = DCCppMessage.makeFunctionGroup5OpsMsg(this.getDccAddress(), this.getFunction(21), this.getFunction(22), this.getFunction(23), this.getFunction(24), this.getFunction(25), this.getFunction(26), this.getFunction(27), this.getFunction(28));
        log.debug("sendFunctionGroup5(): Message: '{}'", (Object)msg);
        this.queueMessage(msg, 0);
    }

    @Override
    public synchronized void setSpeedSetting(float speed) {
        if (log.isDebugEnabled()) {
            log.debug("set Speed to: {} Current step mode is: {}", (Object)Float.valueOf(speed), (Object)this.speedStepMode);
        }
        super.setSpeedSetting(speed);
        if (speed < 0.0f) {
            this.sendEmergencyStop();
        } else {
            if (speed > 1.0f) {
                speed = 1.0f;
            }
            DCCppMessage msg = DCCppMessage.makeSpeedAndDirectionMsg(this.getRegisterNum(), this.getDccAddress(), speed, this.isForward);
            this.queueMessage(msg, 0);
        }
    }

    protected void sendEmergencyStop() {
        DCCppMessage msg = DCCppMessage.makeAddressedEmergencyStop(this.getRegisterNum(), this.getDccAddress());
        this.queueMessage(msg, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIsForward(boolean forward) {
        super.setIsForward(forward);
        DCCppThrottle dCCppThrottle = this;
        synchronized (dCCppThrottle) {
            this.setSpeedSetting(this.speedSetting);
        }
    }

    @Override
    public void setSpeedStepMode(SpeedStepMode Mode) {
        super.setSpeedStepMode(Mode);
    }

    @Override
    protected void throttleDispose() {
        this.active = false;
        this.finishRecord();
    }

    public int setDccAddress(int newaddress) {
        this.address = newaddress;
        return this.address;
    }

    public int getDccAddress() {
        return this.address;
    }

    protected int getDccAddressHigh() {
        return DCCppCommandStation.getDCCAddressHigh(this.address);
    }

    protected int getDccAddressLow() {
        return DCCppCommandStation.getDCCAddressLow(this.address);
    }

    @Override
    public void message(DCCppReply l) {
        if (log.isDebugEnabled()) {
            log.debug("Throttle {} - received message '{}'", (Object)this.getDccAddress(), (Object)l);
        }
        if (this.requestState == 0) {
            log.debug("Current throttle status is THROTTLEIDLE");
        } else if ((this.requestState & 2) == 2) {
            log.debug("Current throttle status is THROTTLESPEEDSENT");
            if (l.isThrottleReply()) {
                this.handleThrottleReply(l);
            }
            log.debug("Last Command processed successfully.");
            this.requestState = 0;
            this.sendQueuedMessage();
        }
        if ((this.requestState & 4) == 4) {
            log.debug("Current throttle status is THROTTLEFUNCSENT. Ignoring Reply: '{}'", (Object)l);
        }
        this.requestState = 0;
        this.sendQueuedMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleThrottleReply(DCCppReply l) {
        int reg = l.getRegisterInt();
        int speed = l.getSpeedInt();
        int dir = l.getDirectionInt();
        int regaddr = this.tc.getCommandStation().getRegisterAddress(reg);
        if (regaddr != -1 && regaddr == this.address) {
            DCCppThrottle dCCppThrottle = this;
            synchronized (dCCppThrottle) {
                this.speedSetting = speed < 0 ? 0.0f : (float)speed * 1.0f / 126.0f;
            }
            this.isForward = dir == 1;
        }
    }

    @Override
    public void message(DCCppMessage l) {
    }

    @Override
    public void notifyTimeout(DCCppMessage msg) {
        log.debug("Notified of timeout on message '{}' , {} retries available.", (Object)msg, (Object)msg.getRetries());
        if (msg.getRetries() > 0) {
            this.tc.sendDCCppMessage(msg, this);
        } else {
            this.sendQueuedMessage();
        }
    }

    @Override
    public LocoAddress getLocoAddress() {
        return new DccLocoAddress(this.address, DCCppThrottleManager.isLongAddress(this.address));
    }

    protected synchronized void sendQueuedMessage() {
        if (!this.requestList.isEmpty()) {
            RequestMessage msg;
            log.debug("sending message to traffic controller");
            try {
                msg = this.requestList.take();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this.requestState = msg.getState();
            this.tc.sendDCCppMessage(msg.getMsg(), this);
        } else {
            log.debug("message queue empty");
            this.requestState = 0;
        }
    }

    protected synchronized void queueMessage(DCCppMessage m, int s) {
        log.debug("adding message to message queue");
        RequestMessage msg = new RequestMessage(m, s);
        try {
            this.requestList.put(msg);
        }
        catch (InterruptedException interruptedException) {}
        if (this.requestState == 0) {
            this.sendQueuedMessage();
        }
    }

    protected static class RequestMessage {
        private final int state;
        private final DCCppMessage msg;

        RequestMessage(DCCppMessage m, int s) {
            this.state = s;
            this.msg = m;
        }

        int getState() {
            return this.state;
        }

        DCCppMessage getMsg() {
            return this.msg;
        }
    }
}

