/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import java.util.Comparator;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammerManager;
import jmri.CommandStation;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.NamedBean;
import jmri.PowerManager;
import jmri.SensorManager;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.dccpp.DCCppCommandStation;
import jmri.jmrix.dccpp.DCCppPacketizer;
import jmri.jmrix.dccpp.DCCppPowerManager;
import jmri.jmrix.dccpp.DCCppProgrammerManager;
import jmri.jmrix.dccpp.DCCppThrottleManager;
import jmri.jmrix.dccpp.DCCppTrafficController;
import jmri.jmrix.dccpp.swing.DCCppComponentFactory;
import jmri.jmrix.swing.ComponentFactory;
import jmri.util.NamedBeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppSystemConnectionMemo
extends DefaultSystemConnectionMemo {
    ComponentFactory cf = null;
    private DCCppTrafficController xt;
    private static final Logger log = LoggerFactory.getLogger(DCCppSystemConnectionMemo.class);

    public DCCppSystemConnectionMemo(@Nonnull DCCppTrafficController xt) {
        super("D", "DCC++");
        this.xt = xt;
        xt.setSystemConnectionMemo(this);
        InstanceManager.store(this, DCCppSystemConnectionMemo.class);
        this.cf = new DCCppComponentFactory(this);
        InstanceManager.store(this.cf, ComponentFactory.class);
        log.debug("Created DCCppSystemConnectionMemo");
    }

    public DCCppSystemConnectionMemo() {
        super("D", "DCC++");
        InstanceManager.store(this, DCCppSystemConnectionMemo.class);
        this.cf = new DCCppComponentFactory(this);
        InstanceManager.store(this.cf, ComponentFactory.class);
        log.debug("Created DCCppSystemConnectionMemo");
    }

    public DCCppTrafficController getDCCppTrafficController() {
        if (this.xt == null) {
            this.setDCCppTrafficController(new DCCppPacketizer(new DCCppCommandStation(this)));
            log.debug("Auto create of DCCppTrafficController for initial configuration");
        }
        return this.xt;
    }

    public void setDCCppTrafficController(@Nonnull DCCppTrafficController xt) {
        this.xt = xt;
        xt.setSystemConnectionMemo(this);
    }

    public DCCppProgrammerManager getProgrammerManager() {
        return (DCCppProgrammerManager)this.get(DCCppProgrammerManager.class);
    }

    public void setProgrammerManager(DCCppProgrammerManager p) {
        this.store(p, DCCppProgrammerManager.class);
        this.store(p, GlobalProgrammerManager.class);
        this.store(p, AddressedProgrammerManager.class);
    }

    public ThrottleManager getThrottleManager() {
        return (ThrottleManager)this.classObjectMap.computeIfAbsent(ThrottleManager.class, c -> new DCCppThrottleManager(this));
    }

    public void setThrottleManager(ThrottleManager t) {
        this.store(t, ThrottleManager.class);
    }

    @Nonnull
    public PowerManager getPowerManager() {
        return (PowerManager)this.classObjectMap.computeIfAbsent(PowerManager.class, c -> {
            DCCppPowerManager powerManager = new DCCppPowerManager(this);
            log.debug("power manager created: {}", (Object)powerManager);
            return powerManager;
        });
    }

    public void setPowerManager(@Nonnull PowerManager p) {
        this.store(p, PowerManager.class);
    }

    public SensorManager getSensorManager() {
        return (SensorManager)this.get(SensorManager.class);
    }

    public void setSensorManager(SensorManager s) {
        this.store(s, SensorManager.class);
    }

    public TurnoutManager getTurnoutManager() {
        return (TurnoutManager)this.get(TurnoutManager.class);
    }

    public void setTurnoutManager(TurnoutManager t) {
        this.store(t, TurnoutManager.class);
    }

    public LightManager getLightManager() {
        return (LightManager)this.get(LightManager.class);
    }

    public void setLightManager(LightManager l) {
        this.store(l, LightManager.class);
    }

    public CommandStation getCommandStation() {
        return (CommandStation)this.get(CommandStation.class);
    }

    public void setCommandStation(@Nonnull CommandStation c) {
        this.store(c, CommandStation.class);
        if (c instanceof DCCppCommandStation) {
            ((DCCppCommandStation)c).setTrafficController(this.xt);
            ((DCCppCommandStation)c).setSystemConnectionMemo(this);
        }
    }

    @Override
    @Nonnull
    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.dccpp.DCCppActionListBundle");
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    @Override
    public void dispose() {
        this.xt = null;
        InstanceManager.deregister(this, DCCppSystemConnectionMemo.class);
        if (this.cf != null) {
            InstanceManager.deregister(this.cf, ComponentFactory.class);
        }
        super.dispose();
    }
}

