/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.dccpp.DCCppPortController;
import jmri.jmrix.dccpp.DCCppSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.SerialPort;

public abstract class DCCppSerialPortController
extends AbstractSerialPortController
implements DCCppPortController {
    protected SerialPort activeSerialPort = null;
    private boolean outputBufferEmpty = true;
    protected String[] validOption2 = new String[]{"yes", "no"};
    private boolean checkBuffer = false;
    private static final Logger log = LoggerFactory.getLogger(DCCppSerialPortController.class);

    public DCCppSerialPortController() {
        super(new DCCppSystemConnectionMemo());
    }

    @Override
    public abstract DataInputStream getInputStream();

    @Override
    public abstract DataOutputStream getOutputStream();

    @Override
    public abstract boolean status();

    @Override
    public boolean okToSend() {
        if ((this.activeSerialPort.getFlowControlMode() & 2) == 2) {
            if (this.checkBuffer) {
                log.debug("CTS: {} Buffer Empty: {}", (Object)this.activeSerialPort.isCTS(), (Object)this.outputBufferEmpty);
                return this.activeSerialPort.isCTS() && this.outputBufferEmpty;
            }
            log.debug("CTS: {}", (Object)this.activeSerialPort.isCTS());
            return this.activeSerialPort.isCTS();
        }
        if (this.checkBuffer) {
            log.debug("Buffer Empty: {}", (Object)this.outputBufferEmpty);
            return this.outputBufferEmpty;
        }
        log.debug("No Flow Control or Buffer Check");
        return true;
    }

    @Override
    public synchronized void setOutputBufferEmpty(boolean s) {
        this.outputBufferEmpty = s;
    }

    protected void setCheckBuffer(boolean b) {
        this.checkBuffer = b;
    }

    @Override
    public DCCppSystemConnectionMemo getSystemConnectionMemo() {
        return (DCCppSystemConnectionMemo)super.getSystemConnectionMemo();
    }
}

