/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Manager;
import jmri.Sensor;
import jmri.jmrix.dccpp.Bundle;
import jmri.jmrix.dccpp.DCCppListener;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppReply;
import jmri.jmrix.dccpp.DCCppSensor;
import jmri.jmrix.dccpp.DCCppSystemConnectionMemo;
import jmri.jmrix.dccpp.DCCppTrafficController;
import jmri.managers.AbstractSensorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppSensorManager
extends AbstractSensorManager
implements DCCppListener {
    protected DCCppTrafficController tc = null;
    int iName;
    private static final Logger log = LoggerFactory.getLogger(DCCppSensorManager.class);

    public DCCppSensorManager(DCCppSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getDCCppTrafficController();
        this.tc.addDCCppListener(8, this);
        DCCppMessage msg = DCCppMessage.makeSensorListMsg();
        this.tc.sendDCCppMessage(msg, this);
    }

    @Override
    @Nonnull
    public DCCppSystemConnectionMemo getMemo() {
        return (DCCppSystemConnectionMemo)this.memo;
    }

    @Override
    public void dispose() {
        this.tc.removeDCCppListener(8, this);
        super.dispose();
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int addr;
        try {
            addr = Integer.parseInt(systemName.substring(this.getSystemPrefix().length() + 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Can't convert " + systemName.substring(this.getSystemNamePrefix().length()) + " to DCC++ sensor address");
        }
        return new DCCppSensor(String.valueOf(this.getSystemNamePrefix()) + addr, userName, this.tc);
    }

    @Override
    public void message(DCCppReply l) {
        int addr = -1;
        if (l.isSensorDefReply()) {
            addr = l.getSensorDefNumInt();
            if (log.isDebugEnabled()) {
                log.debug("SensorDef Reply for Encoder {}", (Object)Integer.toString(addr));
            }
        } else if (l.isSensorReply()) {
            addr = l.getSensorNumInt();
            if (log.isDebugEnabled()) {
                log.debug("Sensor Status Reply for Encoder {}", (Object)Integer.toString(addr));
            }
        }
        if (addr >= 0) {
            String s = String.valueOf(this.getSystemNamePrefix()) + addr;
            if (this.getBySystemName(s) == null) {
                DCCppSensor sn = (DCCppSensor)this.provideSensor(s);
                sn.initmessage(l);
            } else {
                Sensor sen = this.getBySystemName(s);
                if (sen == null) {
                    log.error("Failed to get sensor for {}", (Object)s);
                } else {
                    ((DCCppSensor)sen).message(l);
                }
            }
        }
    }

    @Override
    public void message(DCCppMessage l) {
    }

    @Override
    public void notifyTimeout(DCCppMessage msg) {
        log.debug("Notified of timeout on message '{}' , {} retries available.", (Object)msg, (Object)msg.getRetries());
        if (msg.getRetries() > 0) {
            msg.setRetries(msg.getRetries() - 1);
            this.tc.sendDCCppMessage(msg, this);
        }
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    @Nonnull
    public synchronized String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        int encoderAddress = 0;
        int input = 0;
        if (curAddress.contains(":")) {
            int seperator = curAddress.indexOf(":");
            try {
                encoderAddress = Integer.parseInt(curAddress.substring(0, seperator));
                input = Integer.parseInt(curAddress.substring(seperator + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new JmriException("Unable to convert " + curAddress + " into the cab and input format of nn:xx");
            }
            this.iName = (encoderAddress - 1) * 8 + input;
        } else {
            try {
                this.iName = Integer.parseInt(curAddress);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JmriException("Hardware Address " + curAddress + " should be a number or cab and input format of nn:xx");
            }
        }
        return String.valueOf(prefix) + this.typeLetter() + this.iName;
    }

    @Override
    public synchronized String getNextValidAddress(@Nonnull String curAddress, @Nonnull String prefix, boolean ignoreInitialExisting) throws JmriException {
        String tmpSName = this.createSystemName(curAddress, prefix);
        Sensor s = this.getBySystemName(tmpSName);
        if (s != null || ignoreInitialExisting) {
            int x = 1;
            while (x < 10) {
                ++this.iName;
                s = this.getBySystemName(String.valueOf(prefix) + this.typeLetter() + this.iName);
                if (s == null) {
                    return Integer.toString(this.iName);
                }
                ++x;
            }
            throw new JmriException(Bundle.getMessage("InvalidNextValidTenInUse", this.getBeanTypeHandled(true), curAddress, this.iName));
        }
        return Integer.toString(this.iName);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return this.getBitFromSystemName(systemName) != 0 ? Manager.NameValidity.VALID : Manager.NameValidity.INVALID;
    }

    @Override
    public String validateSystemNameFormat(String systemName, Locale locale) {
        return this.validateIntegerSystemNameFormat(systemName, 1, Short.MAX_VALUE, locale);
    }

    public int getBitFromSystemName(String systemName) {
        try {
            this.validateSystemNameFormat(systemName, Locale.getDefault());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 0;
        }
        return Integer.parseInt(systemName.substring(this.getSystemNamePrefix().length()));
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }
}

