/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import javax.annotation.concurrent.GuardedBy;
import jmri.implementation.AbstractSensor;
import jmri.jmrix.dccpp.DCCppListener;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppReply;
import jmri.jmrix.dccpp.DCCppTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppSensor
extends AbstractSensor
implements DCCppListener {
    private boolean statusRequested = false;
    private int address;
    @GuardedBy(value="this")
    private int pin;
    @GuardedBy(value="this")
    private boolean pullup;
    private String systemName;
    protected DCCppTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(DCCppSensor.class);

    public DCCppSensor(String systemName, String userName, DCCppTrafficController controller) {
        super(systemName, userName);
        this.tc = controller;
        this.init(systemName);
    }

    public DCCppSensor(String systemName, DCCppTrafficController controller) {
        super(systemName);
        this.tc = controller;
        this.init(systemName);
    }

    public synchronized boolean getPullup() {
        return this.pullup;
    }

    public synchronized int getPin() {
        return this.pin;
    }

    public int getIndex() {
        return this.address;
    }

    private void init(String id) {
        this.systemName = id;
        this.address = Integer.parseInt(id.substring(id.lastIndexOf(83) + 1));
        log.debug("New sensor system name {} address {}", (Object)this.getSystemName(), (Object)this.address);
        log.debug("Created Sensor {}", (Object)this.systemName);
    }

    @Override
    public void requestUpdateFromLayout() {
    }

    synchronized void initmessage(DCCppReply l) {
        boolean oldState = this.statusRequested;
        this.message(l);
        this.statusRequested = oldState;
    }

    @Override
    public synchronized void message(DCCppReply l) {
        if (l.isSensorDefReply()) {
            log.debug("Sensor Def Reply received: '{}'", (Object)l);
            if (l.getSensorDefNumInt() == this.address) {
                log.debug("Def Message for sensor {} (Pin {})", (Object)this.systemName, (Object)this.address);
                this.setOwnState(1);
                l.getProperties().forEach((key, value) -> this.setProperty((String)key, value));
            }
        } else if (l.isSensorReply() && l.getSensorNumInt() == this.address) {
            log.debug("Message for sensor {} (Pin {})", (Object)this.systemName, (Object)this.address);
            if (l.getSensorIsActive()) {
                this.setOwnState(this._inverted ? 4 : 2);
            } else if (l.getSensorIsInactive()) {
                this.setOwnState(this._inverted ? 2 : 4);
            } else {
                this.setOwnState(1);
            }
        }
    }

    @Override
    public void message(DCCppMessage l) {
    }

    @Override
    public void notifyTimeout(DCCppMessage msg) {
        log.debug("Notified of timeout on message '{}'", (Object)msg);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    int getNumber() {
        return this.address;
    }

    int getBaseAddress() {
        return this.address;
    }

    int getNibble() {
        return 0;
    }
}

