/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jmri.Meter;
import jmri.Version;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.jmrix.AbstractMRReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppReply
extends AbstractMRReply {
    protected String myRegex;
    protected StringBuilder myReply;
    private static final Logger log = LoggerFactory.getLogger(DCCppReply.class);

    public DCCppReply() {
        this.setBinary(false);
        this.myRegex = "";
        this.myReply = new StringBuilder();
    }

    public DCCppReply(DCCppReply reply) {
        super(reply);
        this.setBinary(false);
        this.myRegex = reply.myRegex;
        this.myReply = reply.myReply;
    }

    public DCCppReply(String reply) {
        this.setBinary(false);
        this.myRegex = "";
        this.myReply = new StringBuilder(reply);
        this._nDataChars = this.toString().length();
    }

    @Override
    public String toString() {
        log.trace("DCCppReply.toString(): msg '{}'", (Object)this.myReply);
        return this.myReply.toString();
    }

    @Override
    public String toMonitorString() {
        String text;
        switch (this.getOpCodeChar()) {
            case 'T': {
                text = "Throttle Reply: ";
                text = String.valueOf(text) + "Register: " + this.getRegisterString() + ", ";
                text = String.valueOf(text) + "Speed: " + this.getSpeedString() + ", ";
                text = String.valueOf(text) + "Direction: " + this.getDirectionString();
                break;
            }
            case 'H': {
                if (this.isTurnoutCmdReply()) {
                    text = "Turnout Reply: ";
                    text = String.valueOf(text) + "ID: " + this.getTOIDString() + ", ";
                    text = String.valueOf(text) + "Dir: " + this.getTOStateString();
                    break;
                }
                if (this.isTurnoutDefReply()) {
                    text = "Turnout Def Reply: ";
                    text = String.valueOf(text) + "ID:" + this.getTOIDString() + ", ";
                    text = String.valueOf(text) + "Address:" + this.getTOAddressString() + ", ";
                    text = String.valueOf(text) + "Index:" + this.getTOAddressIndexString() + ", ";
                    if (this.getTOAddressInt() != -1 && this.getTOAddressIndexInt() != -1) {
                        int boardAddr = this.getTOAddressInt();
                        int boardIndex = this.getTOAddressIndexInt();
                        int dccAddress = (boardAddr - 1) * 4 + boardIndex + 1;
                        text = String.valueOf(text) + "DCC Address: " + dccAddress + ", ";
                    }
                    text = String.valueOf(text) + "Dir: " + this.getTOStateString();
                    break;
                }
                if (this.isTurnoutDefDCCReply()) {
                    text = "Turnout Def DCC Reply: ";
                    text = String.valueOf(text) + "ID:" + this.getTOIDString() + ", ";
                    text = String.valueOf(text) + "Address:" + this.getTOAddressString() + ", ";
                    text = String.valueOf(text) + "Index:" + this.getTOAddressIndexString() + ", ";
                    if (this.getTOAddressInt() != -1 && this.getTOAddressIndexInt() != -1) {
                        int boardAddr = this.getTOAddressInt();
                        int boardIndex = this.getTOAddressIndexInt();
                        int dccAddress = (boardAddr - 1) * 4 + boardIndex + 1;
                        text = String.valueOf(text) + "DCC Address:" + dccAddress + ", ";
                    }
                    text = String.valueOf(text) + "Dir:" + this.getTOStateString();
                    break;
                }
                if (this.isTurnoutDefServoReply()) {
                    text = "Turnout Def SERVO Reply: ";
                    text = String.valueOf(text) + "ID:" + this.getTOIDString() + ", ";
                    text = String.valueOf(text) + "Pin:" + this.getTOPinInt() + ", ";
                    text = String.valueOf(text) + "ThrownPos:" + this.getTOThrownPositionInt() + ", ";
                    text = String.valueOf(text) + "ClosedPos:" + this.getTOClosedPositionInt() + ", ";
                    text = String.valueOf(text) + "Profile:" + this.getTOProfileInt() + ", ";
                    text = String.valueOf(text) + "Dir:" + this.getTOStateString();
                    break;
                }
                if (this.isTurnoutDefVpinReply()) {
                    text = "Turnout Def VPIN Reply: ";
                    text = String.valueOf(text) + "ID:" + this.getTOIDString() + ", ";
                    text = String.valueOf(text) + "Pin:" + this.getTOPinInt() + ", ";
                    text = String.valueOf(text) + "Dir:" + this.getTOStateString();
                    break;
                }
                if (this.isTurnoutDefLCNReply()) {
                    text = "Turnout Def LCN Reply: ";
                    text = String.valueOf(text) + "ID:" + this.getTOIDString() + ", ";
                    text = String.valueOf(text) + "Dir:" + this.getTOStateString();
                    break;
                }
                text = "Unknown Turnout Reply Format: ";
                text = String.valueOf(text) + this.toString();
                break;
            }
            case 'q': {
                text = "Sensor Reply (Inactive): ";
                text = String.valueOf(text) + "Number: " + this.getSensorNumString() + ", ";
                text = String.valueOf(text) + "State: INACTIVE";
                break;
            }
            case 'Q': {
                if (this.isSensorDefReply()) {
                    text = "Sensor Def Reply: ";
                    text = String.valueOf(text) + "Number: " + this.getSensorDefNumString() + ", ";
                    text = String.valueOf(text) + "Pin: " + this.getSensorDefPinString() + ", ";
                    text = String.valueOf(text) + "Pullup: " + this.getSensorDefPullupString();
                    break;
                }
                text = "Sensor Reply (Active): ";
                text = String.valueOf(text) + "Number: " + this.getSensorNumString() + ", ";
                text = String.valueOf(text) + "State: ACTIVE";
                break;
            }
            case 'Y': {
                if (this.isOutputCmdReply()) {
                    text = "Output Command Reply: ";
                    text = String.valueOf(text) + "Number: " + this.getOutputNumString() + ", ";
                    text = String.valueOf(text) + "State: " + this.getOutputCmdStateString();
                    break;
                }
                if (this.isOutputDefReply()) {
                    text = "Output Command Reply: ";
                    text = String.valueOf(text) + "Number: " + this.getOutputNumString() + ", ";
                    text = String.valueOf(text) + "Pin: " + this.getOutputListPinString() + ", ";
                    text = String.valueOf(text) + "Flags: " + this.getOutputListIFlagString() + ", ";
                    text = String.valueOf(text) + "State: " + this.getOutputListStateString();
                    break;
                }
                text = "Invalid Output Reply Format: ";
                text = String.valueOf(text) + this.toString();
                break;
            }
            case 'r': {
                if (this.isProgramBitReply()) {
                    text = "Program Bit Reply: ";
                    text = String.valueOf(text) + "Callback Num: " + this.getCallbackNumString() + ", ";
                    text = String.valueOf(text) + "Callback Sub: " + this.getCallbackSubString() + ", ";
                    text = String.valueOf(text) + "CV: " + this.getCVString() + ", ";
                    text = String.valueOf(text) + "CV Bit: " + this.getProgramBitString() + ", ";
                } else {
                    text = "Program Reply: ";
                    text = String.valueOf(text) + "Callback Num: " + this.getCallbackNumString() + ", ";
                    text = String.valueOf(text) + "Callback Sub: " + this.getCallbackSubString() + ", ";
                    text = String.valueOf(text) + "CV: " + this.getCVString() + ", ";
                }
                text = String.valueOf(text) + "Value: " + this.getReadValueString();
                break;
            }
            case 'v': {
                text = "Prog Verify Reply: ";
                text = String.valueOf(text) + "CV: " + this.getCVString() + ", ";
                text = String.valueOf(text) + "Value: " + this.getReadValueString();
                break;
            }
            case 'i': {
                text = "Status:";
                text = String.valueOf(text) + "Station: " + this.getStationType();
                text = String.valueOf(text) + ", Build: " + this.getBuildString();
                text = String.valueOf(text) + ", Version: " + this.getVersion();
                break;
            }
            case 'p': {
                if (this.isNamedPowerReply()) {
                    text = "Power Status: ";
                    text = String.valueOf(text) + "Name:" + this.getPowerDistrictName();
                    text = String.valueOf(text) + " Status:" + this.getPowerDistrictStatus();
                    break;
                }
                text = "Power Status: ";
                text = String.valueOf(text) + (this.getPowerBool() ? "ON" : "OFF");
                break;
            }
            case 'a': {
                text = "Current: " + this.getCurrentString() + " / 1024";
                break;
            }
            case 'c': {
                text = String.format("Meter reply: name %s, value %.2f, type %s, unit %s, min %.2f, max %.2f, resolution %.2f, warn %.2f", new Object[]{this.getMeterName(), this.getMeterValue(), this.getMeterType(), this.getMeterUnit(), this.getMeterMinValue(), this.getMeterMaxValue(), this.getMeterResolution(), this.getMeterWarnValue()});
                break;
            }
            case 'e': {
                text = "Write EEPROM Reply... ";
                text = String.valueOf(text) + "Turnouts: " + this.getValueString(1) + ", ";
                text = String.valueOf(text) + "Sensors: " + this.getValueString(2) + ", ";
                text = String.valueOf(text) + "Outputs: " + this.getValueString(3);
                break;
            }
            case 'N': {
                text = "Comm Type Reply ";
                text = String.valueOf(text) + "Type: " + this.getCommTypeInt();
                text = String.valueOf(text) + " Port: " + this.getCommTypeValueString();
                break;
            }
            case 'X': {
                text = "No Sensor/Turnout/Output Reply ";
                break;
            }
            case 'O': {
                text = "Sensor/Turnout/Output MADC Success Reply ";
                break;
            }
            case '#': {
                text = "Number of slots reply: " + this.getValueString(1);
                break;
            }
            case '*': {
                text = "DIAG: " + this.getValueString(1);
                break;
            }
            default: {
                text = "Unrecognized reply: '" + this.toString() + "'";
            }
        }
        return text;
    }

    public String getPropertiesAsString() {
        StringBuilder text = new StringBuilder();
        StringBuilder comma = new StringBuilder();
        switch (this.getOpCodeChar()) {
            case 'H': 
            case 'Q': 
            case 'Y': {
                this.getProperties().forEach((key, value) -> {
                    text.append((CharSequence)comma).append((String)key).append(":").append(value);
                    comma.setLength(0);
                    comma.append(",");
                });
                break;
            }
        }
        return text.toString();
    }

    public LinkedHashMap<String, Object> getProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        switch (this.getOpCodeChar()) {
            case 'H': {
                if (this.isTurnoutDefDCCReply()) {
                    properties.put("Type", "DCC");
                    properties.put("ID", this.getTOIDInt());
                    properties.put("Address", this.getTOAddressInt());
                    properties.put("Index", this.getTOAddressIndexInt());
                    if (this.getTOAddressInt() == -1 || this.getTOAddressIndexInt() == -1) break;
                    int boardAddr = this.getTOAddressInt();
                    int boardIndex = this.getTOAddressIndexInt();
                    int dccAddress = (boardAddr - 1) * 4 + boardIndex + 1;
                    properties.put("DCC Address", dccAddress);
                    break;
                }
                if (this.isTurnoutDefServoReply()) {
                    properties.put("Type", "SERVO");
                    properties.put("ID", this.getTOIDInt());
                    properties.put("Pin", this.getTOPinInt());
                    properties.put("ThrownPos", this.getTOThrownPositionInt());
                    properties.put("ClosedPos", this.getTOClosedPositionInt());
                    properties.put("Profile", this.getTOProfileInt());
                    break;
                }
                if (this.isTurnoutDefVpinReply()) {
                    properties.put("Type", "VPIN");
                    properties.put("ID", this.getTOIDInt());
                    properties.put("Pin", this.getTOPinInt());
                    break;
                }
                if (!this.isTurnoutDefLCNReply()) break;
                properties.put("Type", "LCN");
                properties.put("ID", this.getTOIDInt());
                break;
            }
            case 'Q': {
                if (!this.isSensorDefReply()) break;
                properties.put("Type", "SENSOR");
                properties.put("ID", this.getSensorDefNumInt());
                properties.put("Pin", this.getSensorDefPinInt());
                properties.put("Pullup", this.getSensorDefPullupBool());
                break;
            }
            case 'Y': {
                if (!this.isOutputDefReply()) break;
                properties.put("Type", "OUTPUT");
                properties.put("ID", this.getOutputNumInt());
                properties.put("Pin", this.getOutputListPinInt());
                properties.put("IFlag", this.getOutputListIFlagInt());
                break;
            }
        }
        return properties;
    }

    public void parseReply(String s) {
        DCCppReply r = DCCppReply.parseDCCppReply(s);
        log.debug("in parseReply() string: {}", (Object)s);
        if (r != null) {
            this.myRegex = r.myRegex;
            this.myReply = r.myReply;
            this._nDataChars = r._nDataChars;
            log.trace("copied: this: {}", (Object)this);
        }
    }

    public static DCCppReply parseDCCppReply(String s) {
        if (log.isTraceEnabled()) {
            log.trace("Parse charAt(0): {}", (Object)Character.valueOf(s.charAt(0)));
        }
        DCCppReply r = new DCCppReply(s);
        switch (s.charAt(0)) {
            case 'i': {
                if (s.matches("i(DCC\\+\\+.*): V-(.*)\\+\\s\\/\\s(.*)")) {
                    log.debug("BSC Status Reply: '{}'", (Object)r);
                    r.myRegex = "i(DCC\\+\\+.*): V-(.*)\\+\\s\\/\\s(.*)";
                } else if (s.matches("iDCC\\+\\+.*ESP32.*: V-([\\d\\.]+)\\s+/\\s+(.*)")) {
                    log.debug("ESP32 Status Reply: '{}'", (Object)r);
                    r.myRegex = "iDCC\\+\\+.*ESP32.*: V-([\\d\\.]+)\\s+/\\s+(.*)";
                } else if (s.matches("i(DCC\\+\\+[^:]*):(?:\\sBUILD)? (.*)")) {
                    log.debug("Original Status Reply: '{}'", (Object)r);
                    r.myRegex = "i(DCC\\+\\+[^:]*):(?:\\sBUILD)? (.*)";
                } else if (s.matches("i(DCC-EX) V-([\\d\\.]*).*G-(.*)")) {
                    log.debug("DCC-EX Status Reply: '{}'", (Object)r);
                    r.myRegex = "i(DCC-EX) V-([\\d\\.]*).*G-(.*)";
                }
                return r;
            }
            case 'T': {
                if (s.matches("\\s*T\\s*(\\d+)\\s+([-]*\\d+)\\s+([1,0]).*")) {
                    log.debug("Throttle Reply: '{}'", (Object)r);
                    r.myRegex = "\\s*T\\s*(\\d+)\\s+([-]*\\d+)\\s+([1,0]).*";
                }
                return r;
            }
            case 'H': {
                if (s.matches("\\s*H\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+([0|1]).*")) {
                    r.myRegex = "\\s*H\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+([0|1]).*";
                } else if (s.matches("\\s*H\\s(\\d+)\\sDCC\\s(\\d+)\\s(\\d+)\\s+([0|1]).*")) {
                    r.myRegex = "\\s*H\\s(\\d+)\\sDCC\\s(\\d+)\\s(\\d+)\\s+([0|1]).*";
                } else if (s.matches("\\s*H\\s(\\d+)\\sSERVO\\s(\\d+)\\s(\\d+)\\s(\\d+)\\s(\\d+)\\s+([0|1]).*")) {
                    r.myRegex = "\\s*H\\s(\\d+)\\sSERVO\\s(\\d+)\\s(\\d+)\\s(\\d+)\\s(\\d+)\\s+([0|1]).*";
                } else if (s.matches("\\s*H\\s(\\d+)\\sVPIN\\s(\\d+)\\s+([0|1]).*")) {
                    r.myRegex = "\\s*H\\s(\\d+)\\sVPIN\\s(\\d+)\\s+([0|1]).*";
                } else if (s.matches("\\s*H\\s(\\d+)\\sLCN\\s+([0|1]).*")) {
                    r.myRegex = "\\s*H\\s(\\d+)\\sLCN\\s+([0|1]).*";
                } else if (s.matches("\\s*H\\s*(\\d+)\\s+([1,0])\\s*")) {
                    r.myRegex = "\\s*H\\s*(\\d+)\\s+([1,0])\\s*";
                } else if (s.matches("\\s*X.*")) {
                    r.myRegex = "\\s*X.*";
                }
                log.debug("Parsed Reply: '{}' length {}", (Object)r.toString(), (Object)r._nDataChars);
                return r;
            }
            case 'Y': {
                if (s.matches("\\s*Y\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+).*")) {
                    r.myRegex = "\\s*Y\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+).*";
                } else if (s.matches("\\s*Y\\s*(\\d+)\\s+(\\d+)\\s*")) {
                    r.myRegex = "\\s*Y\\s*(\\d+)\\s+(\\d+)\\s*";
                }
                log.debug("Parsed Reply: '{}' length {}", (Object)r, (Object)r._nDataChars);
                return r;
            }
            case 'r': {
                if (s.matches("\\s*r\\s*(\\d+)\\|(\\d+)\\|(\\d+)\\s+(\\d+)\\s+(\\d+)\\s*")) {
                    log.debug("Matches ProgBitReply");
                    r.myRegex = "\\s*r\\s*(\\d+)\\|(\\d+)\\|(\\d+)\\s+(\\d+)\\s+(\\d+)\\s*";
                } else if (s.matches("\\s*r\\s*(\\d+)\\|(\\d+)\\|(\\d+)\\s+([-]*\\d+)\\s*")) {
                    log.debug("Matches ProgReply");
                    r.myRegex = "\\s*r\\s*(\\d+)\\|(\\d+)\\|(\\d+)\\s+([-]*\\d+)\\s*";
                } else {
                    log.debug("Does not match ProgReply Regex");
                }
                return r;
            }
            case 'v': {
                if (s.matches("\\s*v\\s*(\\d+)\\s*([-]*\\d+)\\s*")) {
                    log.debug("Matches VerifyReply");
                    r.myRegex = "\\s*v\\s*(\\d+)\\s*([-]*\\d+)\\s*";
                } else {
                    log.debug("Does not match VerifyReply Regex");
                }
                return r;
            }
            case 'p': {
                if (s.matches("\\s*p\\s*(\\d+)\\s+(\\w+).*")) {
                    r.myRegex = "\\s*p\\s*(\\d+)\\s+(\\w+).*";
                } else if (s.matches("\\s*p\\s*([0,1])\\s*")) {
                    r.myRegex = "\\s*p\\s*([0,1])\\s*";
                }
                return r;
            }
            case 'a': {
                if (s.matches("\\s*a\\s*(\\w*?[a-zA-Z])\\s*(\\d+).*")) {
                    r.myRegex = "\\s*a\\s*(\\w*?[a-zA-Z])\\s*(\\d+).*";
                } else if (s.matches("\\s*a\\s*(\\d+).*")) {
                    r.myRegex = "\\s*a\\s*(\\d+).*";
                }
                return r;
            }
            case 'c': {
                if (s.matches(" *c *(.+) +([\\d\\.]+) +([A-Z]) +(\\w+) +([\\d\\.]+) +([\\d\\.]+) +([\\d\\.]+) +([\\d\\.]+).*")) {
                    r.myRegex = " *c *(.+) +([\\d\\.]+) +([A-Z]) +(\\w+) +([\\d\\.]+) +([\\d\\.]+) +([\\d\\.]+) +([\\d\\.]+).*";
                }
                return r;
            }
            case '#': {
                if (s.matches("\\s*#\\s*(\\d+).*")) {
                    r.myRegex = "\\s*#\\s*(\\d+).*";
                }
                return r;
            }
            case '*': {
                if (s.matches("^\\*\\s*(.*)\\s+\\*$")) {
                    r.myRegex = "^\\*\\s*(.*)\\s+\\*$";
                }
                return r;
            }
            case 'e': {
                if (s.matches("\\s*e\\s*(\\d+)\\s+(\\d+)\\s+(\\d+).*")) {
                    r.myRegex = "\\s*e\\s*(\\d+)\\s+(\\d+)\\s+(\\d+).*";
                }
                return r;
            }
            case 'q': {
                if (s.matches("\\s*q\\s*(\\d+)\\s*")) {
                    r.myRegex = "\\s*q\\s*(\\d+)\\s*";
                }
                return r;
            }
            case 'Q': {
                if (s.matches("\\s*Q\\s*(\\d+)\\s+(\\d+)\\s+([0|1]).*")) {
                    r.myRegex = "\\s*Q\\s*(\\d+)\\s+(\\d+)\\s+([0|1]).*";
                } else if (s.matches("\\s*Q\\s*(\\d+)\\s*")) {
                    r.myRegex = "\\s*Q\\s*(\\d+)\\s*";
                }
                return r;
            }
            case 'X': {
                r.myRegex = "\\s*X.*";
                return r;
            }
            case 'O': {
                r.myRegex = "\\s*O.*";
                return r;
            }
            case 'N': {
                r.myRegex = "\\s*N\\s*(\\d+):\\s+((SERIAL)|(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})).*";
                return r;
            }
        }
        return r;
    }

    @Override
    public int getOpCode() {
        if (this.myReply.length() > 0) {
            return Character.getNumericValue(this.myReply.charAt(0));
        }
        return 0;
    }

    public char getOpCodeChar() {
        if (this.myReply.length() > 0) {
            return this.myReply.charAt(0);
        }
        return '\u0000';
    }

    @Override
    public int getElement(int n) {
        if (n >= 0 && n < this.myReply.length()) {
            return this.myReply.charAt(n);
        }
        return 32;
    }

    @Override
    public void setElement(int n, int v) {
        char c = (char)(v & 0xFF);
        if (this.myReply == null) {
            this.myReply = new StringBuilder(Character.toString(c));
        } else if (n >= this.myReply.length()) {
            this.myReply.append(c);
        } else if (n > 0) {
            this.myReply.setCharAt(n, c);
        }
    }

    @Deprecated
    public Integer getElementBCD(int n) {
        return Integer.decode(Integer.toHexString(this.getElement(n)));
    }

    public boolean getValueBool(int idx) {
        Matcher m = DCCppReply.match(this.myReply.toString(), this.myRegex, "gvb");
        if (m == null) {
            log.error("DCCppReply '{}' not matched by '{}'", (Object)this.toString(), (Object)this.myRegex);
            return false;
        }
        if (idx <= m.groupCount()) {
            return !m.group(idx).equals("0");
        }
        log.error("DCCppReply bool value index too big. idx = {} msg = {}", (Object)idx, (Object)this.toString());
        return false;
    }

    public String getValueString(int idx) {
        Matcher m = DCCppReply.match(this.myReply.toString(), this.myRegex, "gvs");
        if (m == null) {
            log.error("DCCppReply '{}' not matched by '{}'", (Object)this.toString(), (Object)this.myRegex);
            return "";
        }
        if (idx <= m.groupCount()) {
            return m.group(idx);
        }
        log.error("DCCppReply string value index too big. idx = {} msg = {}", (Object)idx, (Object)this.toString());
        return "";
    }

    public boolean valueExists(int idx) {
        Matcher m = DCCppReply.match(this.myReply.toString(), this.myRegex, "gvs");
        return m != null && idx <= m.groupCount();
    }

    public int getValueInt(int idx) {
        Matcher m = DCCppReply.match(this.myReply.toString(), this.myRegex, "gvi");
        if (m == null) {
            log.error("DCCppReply '{}' not matched by '{}'", (Object)this.toString(), (Object)this.myRegex);
            return 0;
        }
        if (idx <= m.groupCount()) {
            return Integer.parseInt(m.group(idx));
        }
        log.error("DCCppReply int value index too big. idx = {} msg = {}", (Object)idx, (Object)this.toString());
        return 0;
    }

    public double getValueDouble(int idx) {
        Matcher m = DCCppReply.match(this.myReply.toString(), this.myRegex, "gvd");
        if (m == null) {
            log.error("DCCppReply '{}' not matched by '{}'", (Object)this.toString(), (Object)this.myRegex);
            return 0.0;
        }
        if (idx <= m.groupCount()) {
            return Double.parseDouble(m.group(idx));
        }
        log.error("DCCppReply double value index too big. idx = {} msg = {}", (Object)idx, (Object)this.toString());
        return 0.0;
    }

    @Override
    protected int skipPrefix(int index) {
        return -1;
    }

    @Override
    public int maxSize() {
        return 256;
    }

    public int getLength() {
        return this.myReply.length();
    }

    protected boolean matches(String pat) {
        return DCCppReply.match(this.toString(), pat, "Validator") != null;
    }

    protected static Matcher match(String s, String pat, String name) {
        Matcher m;
        block5: {
            Pattern p = Pattern.compile(pat);
            m = p.matcher(s);
            if (m.matches()) break block5;
            log.trace("No Match {} Command: {} pattern {}", new Object[]{name, s, pat});
            return null;
        }
        try {
            return m;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            log.error("Malformed DCC++ reply syntax! s = {}", (Object)pat);
            return null;
        }
        catch (IllegalStateException illegalStateException) {
            log.error("Group called before match operation executed string = {}", (Object)s);
            return null;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            log.error("Index out of bounds string = {}", (Object)s);
            return null;
        }
    }

    public String getStationType() {
        if (this.isStatusReply()) {
            return this.getValueString(1);
        }
        return "Unknown";
    }

    public String getBuildString() {
        if (this.isStatusReply()) {
            if (this.valueExists(3)) {
                return this.getValueString(3);
            }
            return this.getValueString(2);
        }
        return "Unknown";
    }

    public String getVersion() {
        if (this.isStatusReply()) {
            String s = this.getValueString(2);
            if (Version.isCanonicalVersion(s)) {
                return s;
            }
            return "0.0.0";
        }
        return "Unknown";
    }

    public String getRegisterString() {
        if (this.isThrottleReply()) {
            return this.getValueString(1);
        }
        log.error("ThrottleReply Parser called on non-Throttle message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getRegisterInt() {
        if (this.isThrottleReply()) {
            return this.getValueInt(1);
        }
        log.error("ThrottleReply Parser called on non-Throttle message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public String getSpeedString() {
        if (this.isThrottleReply()) {
            return this.getValueString(2);
        }
        log.error("ThrottleReply Parser called on non-Throttle message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getSpeedInt() {
        if (this.isThrottleReply()) {
            return this.getValueInt(2);
        }
        log.error("ThrottleReply Parser called on non-Throttle message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public String getDirectionString() {
        if (this.isThrottleReply()) {
            return this.getValueBool(3) ? "Forward" : "Reverse";
        }
        log.error("ThrottleReply Parser called on non-ThrottleReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "Not a Throttle";
    }

    public int getDirectionInt() {
        if (this.isThrottleReply()) {
            return this.getValueInt(3);
        }
        log.error("ThrottleReply Parser called on non-ThrottleReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public boolean getDirectionBool() {
        if (this.isThrottleReply()) {
            return this.getValueBool(3);
        }
        log.error("ThrottleReply Parser called on non-ThrottleReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return false;
    }

    public String getTOIDString() {
        if (this.isTurnoutReply()) {
            return this.getValueString(1);
        }
        log.error("TurnoutReply Parser called on non-TurnoutReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getTOIDInt() {
        if (this.isTurnoutReply()) {
            return this.getValueInt(1);
        }
        log.error("TurnoutReply Parser called on non-TurnoutReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public String getTOAddressString() {
        if (this.isTurnoutDefReply() || this.isTurnoutDefDCCReply()) {
            return this.getValueString(2);
        }
        return "-1";
    }

    public int getTOAddressInt() {
        if (this.isTurnoutDefReply() || this.isTurnoutDefDCCReply()) {
            return this.getValueInt(2);
        }
        return -1;
    }

    public String getTOAddressIndexString() {
        if (this.isTurnoutDefReply() || this.isTurnoutDefDCCReply()) {
            return this.getValueString(3);
        }
        return "-1";
    }

    public int getTOAddressIndexInt() {
        if (this.isTurnoutDefReply() || this.isTurnoutDefDCCReply()) {
            return this.getValueInt(3);
        }
        return -1;
    }

    public int getTOPinInt() {
        if (this.isTurnoutDefServoReply() || this.isTurnoutDefVpinReply()) {
            return this.getValueInt(2);
        }
        return -1;
    }

    public int getTOThrownPositionInt() {
        if (this.isTurnoutDefServoReply()) {
            return this.getValueInt(3);
        }
        return -1;
    }

    public int getTOClosedPositionInt() {
        if (this.isTurnoutDefServoReply()) {
            return this.getValueInt(4);
        }
        return -1;
    }

    public int getTOProfileInt() {
        if (this.isTurnoutDefServoReply()) {
            return this.getValueInt(5);
        }
        return -1;
    }

    public String getTOStateString() {
        if (this.isTurnoutReply()) {
            return this.getTOStateInt() == 1 ? "THROWN" : "CLOSED";
        }
        log.error("TurnoutReply Parser called on non-TurnoutReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "Not a Turnout";
    }

    public int getTOStateInt() {
        if (this.isTurnoutDefReply() || this.isTurnoutDefDCCReply()) {
            return this.getValueInt(4);
        }
        if (this.isTurnoutDefServoReply()) {
            return this.getValueInt(6);
        }
        if (this.isTurnoutDefVpinReply()) {
            return this.getValueInt(3);
        }
        if (this.isTurnoutDefLCNReply()) {
            return this.getValueInt(2);
        }
        if (this.isTurnoutReply()) {
            return this.getValueInt(2);
        }
        log.error("TurnoutReply Parser called on non-TurnoutReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public boolean getTOIsThrown() {
        return this.getTOStateInt() == 1;
    }

    public boolean getTOIsClosed() {
        return !this.getTOIsThrown();
    }

    public String getCallbackNumString() {
        if (this.isProgramReply() || this.isProgramBitReply()) {
            return this.getValueString(1);
        }
        log.error("ProgramReply Parser called on non-ProgramReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getCallbackNumInt() {
        if (this.isProgramReply() || this.isProgramBitReply()) {
            return this.getValueInt(1);
        }
        log.error("ProgramReply Parser called on non-ProgramReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public String getCallbackSubString() {
        if (this.isProgramReply() || this.isProgramBitReply()) {
            return this.getValueString(2);
        }
        log.error("ProgramReply Parser called on non-ProgramReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getCallbackSubInt() {
        if (this.isProgramReply() || this.isProgramBitReply()) {
            return this.getValueInt(2);
        }
        log.error("ProgramReply Parser called on non-ProgramReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public String getCVString() {
        if (this.isProgramReply() || this.isProgramBitReply()) {
            return this.getValueString(3);
        }
        if (this.isVerifyReply()) {
            return this.getValueString(1);
        }
        log.error("ProgramReply Parser called on non-ProgramReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getCVInt() {
        if (this.isProgramReply() || this.isProgramBitReply()) {
            return this.getValueInt(3);
        }
        if (this.isVerifyReply()) {
            return this.getValueInt(1);
        }
        log.error("ProgramReply Parser called on non-ProgramReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public String getProgramBitString() {
        if (this.isProgramBitReply()) {
            return this.getValueString(4);
        }
        log.error("ProgramReply Parser called on non-ProgramReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getProgramBitInt() {
        if (this.isProgramBitReply()) {
            return this.getValueInt(4);
        }
        log.error("ProgramReply Parser called on non-ProgramReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public String getReadValueString() {
        if (this.isProgramReply() || this.isProgramBitReply()) {
            if (this.matches("\\s*r\\s*(\\d+)\\|(\\d+)\\|(\\d+)\\s+(\\d+)\\s+(\\d+)\\s*")) {
                return this.getValueString(5);
            }
            return this.getValueString(4);
        }
        if (this.isVerifyReply()) {
            return this.getValueString(2);
        }
        log.error("ProgramReply Parser called on non-ProgramReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getReadValueInt() {
        return Integer.parseInt(this.getReadValueString());
    }

    public String getPowerDistrictName() {
        if (this.isNamedPowerReply()) {
            return this.getValueString(2);
        }
        log.error("NamedPowerReply Parser called on non-NamedPowerReply message type '{}' message '{}'", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this.toString());
        return "";
    }

    public String getPowerDistrictStatus() {
        if (this.isNamedPowerReply()) {
            if (this.getValueString(1).equals("0")) {
                return "OFF";
            }
            if (this.getValueString(1).equals("1")) {
                return "ON";
            }
            return "OVERLOAD";
        }
        log.error("NamedPowerReply Parser called on non-NamedPowerReply message type {} message {}", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this.toString());
        return "";
    }

    public String getCurrentString() {
        if (this.isCurrentReply()) {
            if (this.isNamedCurrentReply()) {
                return this.getValueString(2);
            }
            return this.getValueString(1);
        }
        log.error("CurrentReply Parser called on non-CurrentReply message type {} message {}", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this.toString());
        return "0";
    }

    public int getCurrentInt() {
        return Integer.parseInt(this.getCurrentString());
    }

    public String getMeterName() {
        if (this.isMeterReply()) {
            return this.getValueString(1);
        }
        log.error("MeterReply Parser called on non-MeterReply message type '{}' message '{}'", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this.toString());
        return "";
    }

    public double getMeterValue() {
        if (this.isMeterReply()) {
            return this.getValueDouble(2);
        }
        log.error("MeterReply Parser called on non-MeterReply message type '{}' message '{}'", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this.toString());
        return 0.0;
    }

    public String getMeterType() {
        if (this.isMeterReply()) {
            String t = this.getValueString(3);
            if (t.equals("V") || t.equals("C")) {
                return t;
            }
            log.warn("Meter Type '{}' is not valid type in message '{}'", (Object)t, (Object)this.toString());
            return "";
        }
        log.error("MeterReply Parser called on non-MeterReply message type '{}' message '{}'", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this.toString());
        return "";
    }

    public Meter.Unit getMeterUnit() {
        if (this.isMeterReply()) {
            String us = this.getValueString(4);
            AbstractXmlAdapter.EnumIoNames<Meter.Unit> map = new AbstractXmlAdapter.EnumIoNames<Meter.Unit>(Meter.Unit.class);
            return (Meter.Unit)((Object)((AbstractXmlAdapter.EnumIO)map).inputFromString(us));
        }
        log.error("MeterReply Parser called on non-MeterReply message type '{}' message '{}'", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this.toString());
        return Meter.Unit.NoPrefix;
    }

    public double getMeterMinValue() {
        if (this.isMeterReply()) {
            return this.getValueDouble(5);
        }
        log.error("MeterReply Parser called on non-MeterReply message type '{}' message '{}'", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this.toString());
        return 0.0;
    }

    public double getMeterMaxValue() {
        if (this.isMeterReply()) {
            return this.getValueDouble(6);
        }
        log.error("MeterReply Parser called on non-MeterReply message type '{}' message '{}'", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this.toString());
        return 0.0;
    }

    public double getMeterResolution() {
        if (this.isMeterReply()) {
            return this.getValueDouble(7);
        }
        log.error("MeterReply Parser called on non-MeterReply message type '{}' message '{}'", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this.toString());
        return 0.0;
    }

    public double getMeterWarnValue() {
        if (this.isMeterReply()) {
            return this.getValueDouble(8);
        }
        log.error("MeterReply Parser called on non-MeterReply message type '{}' message '{}'", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this.toString());
        return 0.0;
    }

    public boolean isMeterTypeVolt() {
        if (this.isMeterReply()) {
            return this.getMeterType().equals("V");
        }
        log.error("MeterReply Parser called on non-MeterReply message type '{}' message '{}'", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this.toString());
        return false;
    }

    public boolean isMeterTypeCurrent() {
        if (this.isMeterReply()) {
            return this.getMeterType().equals("C");
        }
        log.error("MeterReply Parser called on non-MeterReply message type '{}' message '{}'", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this.toString());
        return false;
    }

    public boolean getPowerBool() {
        if (this.isPowerReply()) {
            return this.getValueString(1).equals("1");
        }
        log.error("PowerReply Parser called on non-PowerReply message type {} message {}", (Object)Character.valueOf(this.getOpCodeChar()), (Object)this.toString());
        return false;
    }

    public String getTurnoutDefNumString() {
        if (this.isTurnoutDefReply() || this.isTurnoutDefDCCReply()) {
            return this.getValueString(1);
        }
        log.error("TurnoutDefReply Parser called on non-TurnoutDefReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getTurnoutDefNumInt() {
        return Integer.parseInt(this.getTurnoutDefNumString());
    }

    public String getTurnoutDefAddrString() {
        if (this.isTurnoutDefReply() || this.isTurnoutDefDCCReply()) {
            return this.getValueString(2);
        }
        log.error("TurnoutDefReply Parser called on non-TurnoutDefReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getTurnoutDefAddrInt() {
        return Integer.parseInt(this.getTurnoutDefAddrString());
    }

    public String getTurnoutDefSubAddrString() {
        if (this.isTurnoutDefReply() || this.isTurnoutDefDCCReply()) {
            return this.getValueString(3);
        }
        log.error("TurnoutDefReply Parser called on non-TurnoutDefReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getTurnoutDefSubAddrInt() {
        return Integer.parseInt(this.getTurnoutDefSubAddrString());
    }

    public String getOutputNumString() {
        if (this.isOutputDefReply() || this.isOutputCmdReply()) {
            return this.getValueString(1);
        }
        log.error("OutputAddReply Parser called on non-OutputAddReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getOutputNumInt() {
        return Integer.parseInt(this.getOutputNumString());
    }

    public String getOutputListPinString() {
        if (this.isOutputDefReply()) {
            return this.getValueString(2);
        }
        log.error("OutputAddReply Parser called on non-OutputAddReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getOutputListPinInt() {
        return Integer.parseInt(this.getOutputListPinString());
    }

    public String getOutputListIFlagString() {
        if (this.isOutputDefReply()) {
            return this.getValueString(3);
        }
        log.error("OutputListReply Parser called on non-OutputListReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getOutputListIFlagInt() {
        return Integer.parseInt(this.getOutputListIFlagString());
    }

    public String getOutputListStateString() {
        if (this.isOutputDefReply()) {
            return this.getValueString(4);
        }
        log.error("OutputListReply Parser called on non-OutputListReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getOutputListStateInt() {
        return Integer.parseInt(this.getOutputListStateString());
    }

    public boolean getOutputCmdStateBool() {
        if (this.isOutputCmdReply()) {
            return this.getValueBool(2);
        }
        log.error("OutputCmdReply Parser called on non-OutputCmdReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return false;
    }

    public String getOutputCmdStateString() {
        if (this.isOutputCmdReply()) {
            return this.getValueBool(2) ? "HIGH" : "LOW";
        }
        log.error("OutputCmdReply Parser called on non-OutputCmdReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getOutputCmdStateInt() {
        return this.getOutputCmdStateBool() ? 1 : 0;
    }

    public boolean getOutputIsHigh() {
        return this.getOutputCmdStateBool();
    }

    public boolean getOutputIsLow() {
        return !this.getOutputCmdStateBool();
    }

    public String getSensorDefNumString() {
        if (this.isSensorDefReply()) {
            return this.getValueString(1);
        }
        log.error("SensorDefReply Parser called on non-SensorDefReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getSensorDefNumInt() {
        return Integer.parseInt(this.getSensorDefNumString());
    }

    public String getSensorDefPinString() {
        if (this.isSensorDefReply()) {
            return this.getValueString(2);
        }
        log.error("SensorDefReply Parser called on non-SensorDefReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getSensorDefPinInt() {
        return Integer.parseInt(this.getSensorDefPinString());
    }

    public String getSensorDefPullupString() {
        if (this.isSensorDefReply()) {
            return this.getSensorDefPullupBool() ? "Pullup" : "NoPullup";
        }
        log.error("SensorDefReply Parser called on non-SensorDefReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "Not a Sensor";
    }

    public int getSensorDefPullupInt() {
        if (this.isSensorDefReply()) {
            return this.getValueInt(3);
        }
        log.error("SensorDefReply Parser called on non-SensorDefReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public boolean getSensorDefPullupBool() {
        if (this.isSensorDefReply()) {
            return this.getValueBool(3);
        }
        log.error("SensorDefReply Parser called on non-SensorDefReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return false;
    }

    public String getSensorNumString() {
        if (this.isSensorReply()) {
            return this.getValueString(1);
        }
        log.error("SensorReply Parser called on non-SensorReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "0";
    }

    public int getSensorNumInt() {
        return Integer.parseInt(this.getSensorNumString());
    }

    public String getSensorStateString() {
        if (this.isSensorReply()) {
            return this.myRegex.equals("\\s*Q\\s*(\\d+)\\s*") ? "Active" : "Inactive";
        }
        log.error("SensorReply Parser called on non-SensorReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "Not a Sensor";
    }

    public int getSensorStateInt() {
        if (this.isSensorReply()) {
            return this.myRegex.equals("\\s*Q\\s*(\\d+)\\s*") ? 1 : 0;
        }
        log.error("SensorReply Parser called on non-SensorReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public boolean getSensorIsActive() {
        return this.myRegex.equals("\\s*Q\\s*(\\d+)\\s*");
    }

    public boolean getSensorIsInactive() {
        return this.myRegex.equals("\\s*q\\s*(\\d+)\\s*");
    }

    public int getCommTypeInt() {
        if (this.isCommTypeReply()) {
            return this.getValueInt(1);
        }
        log.error("CommTypeReply Parser called on non-CommTypeReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return 0;
    }

    public String getCommTypeValueString() {
        if (this.isCommTypeReply()) {
            return this.getValueString(2);
        }
        log.error("CommTypeReply Parser called on non-CommTypeReply message type {}", (Object)Character.valueOf(this.getOpCodeChar()));
        return "N/A";
    }

    public boolean isThrottleReply() {
        return this.getOpCodeChar() == 'T';
    }

    public boolean isTurnoutReply() {
        return this.getOpCodeChar() == 'H';
    }

    public boolean isTurnoutCmdReply() {
        return this.matches("\\s*H\\s*(\\d+)\\s+([1,0])\\s*");
    }

    public boolean isProgramReply() {
        return this.matches("\\s*r\\s*(\\d+)\\|(\\d+)\\|(\\d+)\\s+([-]*\\d+)\\s*");
    }

    public boolean isVerifyReply() {
        return this.matches("\\s*v\\s*(\\d+)\\s*([-]*\\d+)\\s*");
    }

    public boolean isProgramBitReply() {
        return this.matches("\\s*r\\s*(\\d+)\\|(\\d+)\\|(\\d+)\\s+(\\d+)\\s+(\\d+)\\s*");
    }

    public boolean isPowerReply() {
        return this.getOpCodeChar() == 'p';
    }

    public boolean isNamedPowerReply() {
        return this.matches("\\s*p\\s*(\\d+)\\s+(\\w+).*");
    }

    public boolean isMaxNumSlotsReply() {
        return this.matches("\\s*#\\s*(\\d+).*");
    }

    public boolean isDiagReply() {
        return this.matches("^\\*\\s*(.*)\\s+\\*$");
    }

    public boolean isCurrentReply() {
        return this.getOpCodeChar() == 'a';
    }

    public boolean isNamedCurrentReply() {
        return this.matches("\\s*a\\s*(\\w*?[a-zA-Z])\\s*(\\d+).*");
    }

    public boolean isMeterReply() {
        return this.matches(" *c *(.+) +([\\d\\.]+) +([A-Z]) +(\\w+) +([\\d\\.]+) +([\\d\\.]+) +([\\d\\.]+) +([\\d\\.]+).*");
    }

    public boolean isSensorReply() {
        return this.getOpCodeChar() == 'Q' || this.getOpCodeChar() == 'q' || this.getOpCodeChar() == 'Q';
    }

    public boolean isSensorDefReply() {
        return this.matches("\\s*Q\\s*(\\d+)\\s+(\\d+)\\s+([0|1]).*");
    }

    public boolean isTurnoutDefReply() {
        return this.matches("\\s*H\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+([0|1]).*");
    }

    public boolean isTurnoutDefDCCReply() {
        return this.matches("\\s*H\\s(\\d+)\\sDCC\\s(\\d+)\\s(\\d+)\\s+([0|1]).*");
    }

    public boolean isTurnoutDefServoReply() {
        return this.matches("\\s*H\\s(\\d+)\\sSERVO\\s(\\d+)\\s(\\d+)\\s(\\d+)\\s(\\d+)\\s+([0|1]).*");
    }

    public boolean isTurnoutDefVpinReply() {
        return this.matches("\\s*H\\s(\\d+)\\sVPIN\\s(\\d+)\\s+([0|1]).*");
    }

    public boolean isTurnoutDefLCNReply() {
        return this.matches("\\s*H\\s(\\d+)\\sLCN\\s+([0|1]).*");
    }

    public boolean isMADCFailReply() {
        return this.getOpCodeChar() == 'X';
    }

    public boolean isMADCSuccessReply() {
        return this.getOpCodeChar() == 'O';
    }

    public boolean isStatusReply() {
        return this.getOpCodeChar() == 'i';
    }

    public boolean isOutputReply() {
        return this.getOpCodeChar() == 'Y';
    }

    public boolean isOutputDefReply() {
        return this.matches("\\s*Y\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+).*");
    }

    public boolean isOutputCmdReply() {
        return this.matches("\\s*Y\\s*(\\d+)\\s+(\\d+)\\s*");
    }

    public boolean isCommTypeReply() {
        return this.matches("\\s*N\\s*(\\d+):\\s+((SERIAL)|(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})).*");
    }

    public boolean isWriteEepromReply() {
        return this.matches("\\s*e\\s*(\\d+)\\s+(\\d+)\\s+(\\d+).*");
    }

    public boolean isValidReplyFormat() {
        return this.matches("\\s*T\\s*(\\d+)\\s+([-]*\\d+)\\s+([1,0]).*") || this.matches("\\s*H\\s*(\\d+)\\s+([1,0])\\s*") || this.matches("\\s*r\\s*(\\d+)\\|(\\d+)\\|(\\d+)\\s+([-]*\\d+)\\s*") || this.matches("\\s*v\\s*(\\d+)\\s*([-]*\\d+)\\s*") || this.matches("\\s*p\\s*([0,1])\\s*") || this.matches("\\s*p\\s*(\\d+)\\s+(\\w+).*") || this.matches("\\s*a\\s*(\\d+).*") || this.matches("\\s*a\\s*(\\w*?[a-zA-Z])\\s*(\\d+).*") || this.matches(" *c *(.+) +([\\d\\.]+) +([A-Z]) +(\\w+) +([\\d\\.]+) +([\\d\\.]+) +([\\d\\.]+) +([\\d\\.]+).*") || this.matches("\\s*[Qq]\\s*(\\d+)\\s*") || this.matches("\\s*Q\\s*(\\d+)\\s+(\\d+)\\s+([0|1]).*") || this.matches("\\s*q\\s*(\\d+)\\s*") || this.matches("\\s*Q\\s*(\\d+)\\s*") || this.matches("\\s*Y\\s*(\\d+)\\s+(\\d+)\\s*") || this.matches("\\s*X.*") || this.matches("\\s*O.*") || this.matches("i(DCC\\+\\+[^:]*):(?:\\sBUILD)? (.*)") || this.matches("i(DCC\\+\\+.*): V-(.*)\\+\\s\\/\\s(.*)") || this.matches("iDCC\\+\\+.*ESP32.*: V-([\\d\\.]+)\\s+/\\s+(.*)") || this.matches("i(DCC-EX) V-([\\d\\.]*).*G-(.*)");
    }
}

