/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import jmri.jmrix.dccpp.DCCppRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppRegisterManager {
    protected int maxMainRegisters = 0;
    protected DCCppRegister[] registers;
    private static final Logger log = LoggerFactory.getLogger(DCCppRegisterManager.class);

    public DCCppRegisterManager(int maxMainRegisters) {
        log.debug("DCCppRegisterManager({}) called.", (Object)maxMainRegisters);
        this.maxMainRegisters = maxMainRegisters;
        this.registers = new DCCppRegister[maxMainRegisters];
        int i = 0;
        while (i < maxMainRegisters) {
            this.registers[i] = new DCCppRegister();
            ++i;
        }
    }

    public DCCppRegisterManager() {
        this(12);
    }

    public int requestRegister(int addr) {
        int free = -1;
        int i = 0;
        while (i < this.maxMainRegisters) {
            if (this.registers[i].getAddress() == addr) {
                this.registers[i].allocate();
                log.debug("requestRegister({}) returns {}", (Object)addr, (Object)i);
                return i;
            }
            if (free == -1 && this.registers[i].isFree()) {
                free = i;
            }
            ++i;
        }
        if (free != -1) {
            this.registers[free].allocate();
            this.registers[free].setAddress(addr);
        }
        log.debug("requestRegister({}) returns {}", (Object)addr, (Object)free);
        return free;
    }

    public void releaseRegister(int addr) {
        int i = 0;
        while (i < this.maxMainRegisters) {
            if (this.registers[i].getAddress() == addr) {
                this.registers[i].release();
            }
            ++i;
        }
    }

    public int getRegisterNum(int addr) {
        int i = 0;
        while (i < this.maxMainRegisters) {
            if (this.registers[i].getAddress() == addr) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    public int getRegisterAddress(int num) {
        return this.registers[num - 1].getAddress();
    }
}

