/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.AbstractProgrammer;
import jmri.jmrix.dccpp.DCCppListener;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppReply;
import jmri.jmrix.dccpp.DCCppTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppProgrammer
extends AbstractProgrammer
implements DCCppListener {
    protected static final int DCCppProgrammerTimeout = 90000;
    protected boolean _service_mode = false;
    protected int progState = 0;
    protected static final int NOTPROGRAMMING = 0;
    protected static final int REQUESTSENT = 1;
    protected static final int INQUIRESENT = 2;
    protected boolean _progRead = false;
    protected int _val;
    protected int _cv;
    private ProgListener _usingProgrammer = null;
    DCCppTrafficController _controller;
    private static final Logger log = LoggerFactory.getLogger(DCCppProgrammer.class);

    public DCCppProgrammer(DCCppTrafficController tc) {
        this._controller = tc;
        this.controller().addDCCppListener(67, this);
        this.setMode(ProgrammingMode.DIRECTBYTEMODE);
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(ProgrammingMode.DIRECTBYTEMODE);
        return ret;
    }

    @Override
    public boolean getCanRead(String addr) {
        if (log.isDebugEnabled()) {
            log.debug("check mode {} CV {}", (Object)this.getMode(), (Object)addr);
        }
        if (!this.getCanRead()) {
            return false;
        }
        if (this.getMode().equals(ProgrammingMode.DIRECTBYTEMODE)) {
            return Integer.parseInt(addr) <= 1024;
        }
        return Integer.parseInt(addr) <= 256;
    }

    @Override
    public boolean getCanWrite(String addr) {
        if (log.isDebugEnabled()) {
            log.debug("check CV {}", (Object)addr);
        }
        log.debug("cs Type: {} CS Build: {}", (Object)this.controller().getCommandStation().getStationType(), (Object)this.controller().getCommandStation().getBuild());
        if (!this.getCanWrite()) {
            return false;
        }
        if (this.getMode().equals(ProgrammingMode.DIRECTBYTEMODE)) {
            return Integer.parseInt(addr) <= 1024;
        }
        return Integer.parseInt(addr) <= 256;
    }

    @Override
    @Nonnull
    public Programmer.WriteConfirmMode getWriteConfirmMode(String addr) {
        return Programmer.WriteConfirmMode.DecoderReply;
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        if (log.isDebugEnabled()) {
            log.debug("writeCV {} listens {}", (Object)CV, (Object)p);
        }
        this.useProgrammer(p);
        this._progRead = false;
        this.progState = 1;
        this._val = val;
        this._cv = 0xFFFF & CV;
        this.restartTimer(90000);
        if (this.getMode().equals(ProgrammingMode.DIRECTBYTEMODE)) {
            DCCppMessage msg = DCCppMessage.makeWriteDirectCVMsg(CV, val);
            this.controller().sendDCCppMessage(msg, this);
        }
    }

    @Override
    public synchronized void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        this.readCV(CV, p, val);
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        this.readCV(CVname, p, 0);
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p, int startVal) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.debug("readCV {}, startVal {}", (Object)CV, (Object)startVal);
        if (!this.getCanRead()) {
            this.notifyProgListenerEnd(p, CV, 8);
            return;
        }
        this.useProgrammer(p);
        this._cv = 0xFFFF & CV;
        this._progRead = true;
        this.progState = 1;
        this.restartTimer(90000);
        if (this.getMode().equals(ProgrammingMode.DIRECTBYTEMODE)) {
            if (this.controller().getCommandStation().isReadStartValSupported()) {
                DCCppMessage msg = DCCppMessage.makeVerifyCVMsg(CV, startVal);
                this.controller().sendDCCppMessage(msg, this);
            } else {
                DCCppMessage msg = DCCppMessage.makeReadDirectCVMsg(CV);
                this.controller().sendDCCppMessage(msg, this);
            }
        }
    }

    protected void useProgrammer(ProgListener p) throws ProgrammerException {
        if (this._usingProgrammer != null && this._usingProgrammer != p) {
            if (log.isInfoEnabled()) {
                log.info("programmer already in use by {}", (Object)this._usingProgrammer);
            }
            throw new ProgrammerException("programmer in use");
        }
        this._usingProgrammer = p;
    }

    @Override
    public synchronized void message(DCCppReply m) {
        if (this.progState == 0) {
            return;
        }
        if (m.getElement(0) == 114 || m.getElement(0) == 118) {
            if (log.isDebugEnabled()) {
                log.debug("reply in REQUESTSENT state");
                log.debug("DCC++ Program or Verify Reply value = {}", (Object)m.getCVString());
            }
            this._val = m.getReadValueInt();
            this.progState = 0;
            if (this._val == -1) {
                log.debug("Reporting NoAck");
                this.notifyProgListenerEnd(this._val, 32);
            } else {
                log.debug("Reporting OK");
                this.notifyProgListenerEnd(this._val, 0);
            }
        }
    }

    @Override
    public synchronized void message(DCCppMessage l) {
    }

    @Override
    public void notifyTimeout(DCCppMessage msg) {
        log.debug("Notified of timeout on message '{}'", (Object)msg);
    }

    public synchronized boolean programmerBusy() {
        return this.progState != 0;
    }

    @Override
    protected synchronized void timeout() {
        if (this.progState != 0) {
            if (log.isDebugEnabled()) {
                log.debug("timeout!");
            }
            this.progState = 0;
            if (this.getCanRead()) {
                this.notifyProgListenerEnd(this._val, 128);
            } else {
                this.notifyProgListenerEnd(this._val, 0);
            }
        }
    }

    protected void notifyProgListenerEnd(int value, int status) {
        if (log.isDebugEnabled()) {
            log.debug("notifyProgListenerEnd value {} status {}", (Object)value, (Object)status);
        }
        ProgListener temp = this._usingProgrammer;
        this._usingProgrammer = null;
        this.notifyProgListenerEnd(temp, value, status);
    }

    protected DCCppTrafficController controller() {
        return this._controller;
    }
}

