/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.dccpp.DCCppCommandStation;
import jmri.jmrix.dccpp.DCCppListener;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppPortController;
import jmri.jmrix.dccpp.DCCppReply;
import jmri.jmrix.dccpp.DCCppTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppPacketizer
extends DCCppTrafficController {
    private static final Logger log = LoggerFactory.getLogger(DCCppPacketizer.class);

    public DCCppPacketizer(DCCppCommandStation pCommandStation) {
        super(pCommandStation);
        log.debug("DCCppPacketizer created");
    }

    @Override
    public void sendDCCppMessage(DCCppMessage m, DCCppListener reply) {
        if (m.length() != 0) {
            log.debug("Adding '{}' to send queue", (Object)m);
            this.sendMessage(m, reply);
            Thread.yield();
        }
    }

    @Override
    protected int addHeaderToOutput(byte[] msg, AbstractMRMessage m) {
        if (log.isTraceEnabled()) {
            log.trace("Appending '<' to start of outgoing message. msg length = {}", (Object)msg.length);
        }
        msg[0] = 60;
        return 1;
    }

    @Override
    protected void addTrailerToOutput(byte[] msg, int offset, AbstractMRMessage m) {
        if (log.isTraceEnabled()) {
            log.trace("aTTO offset = {} message = {} msg length = {}", new Object[]{offset, m, msg.length});
        }
        if (m.getNumDataElements() == 0) {
            return;
        }
        msg[offset] = 62;
        if (log.isTraceEnabled()) {
            log.trace("finished string = {}", (Object)new String(msg, StandardCharsets.UTF_8));
        }
    }

    @Override
    public boolean portReadyToSend(AbstractPortController p) {
        if (p instanceof DCCppPortController && ((DCCppPortController)((Object)p)).okToSend()) {
            ((DCCppPortController)((Object)p)).setOutputBufferEmpty(false);
            return true;
        }
        log.warn("DCC++ port not ready to send");
        return false;
    }

    @Override
    protected void loadChars(AbstractMRReply msg, DataInputStream istream) throws IOException {
        StringBuilder m = new StringBuilder();
        log.trace("loading characters from port");
        if (!(msg instanceof DCCppReply)) {
            log.error("SerialDCCppPacketizer.loadChars called on non-DCCppReply msg!");
            return;
        }
        byte char1 = this.readByteProtected(istream);
        while (char1 != 60) {
            char1 = this.readByteProtected(istream);
        }
        log.trace("Serial: Message started...");
        int i = 0;
        while (i < msg.maxSize()) {
            char1 = this.readByteProtected(istream);
            if (char1 == 62) {
                log.debug("Received: '{}'", (Object)m);
                ((DCCppReply)msg).parseReply(m.toString());
                break;
            }
            m.append((char)char1);
            log.trace("msg char[{}]: {} ({})", new Object[]{i, char1, Character.valueOf((char)char1)});
            ++i;
        }
    }
}

