/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammer;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.AbstractProgrammer;
import jmri.jmrix.dccpp.DCCppCommandStation;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppOpsModeProgrammer
extends AbstractProgrammer
implements AddressedProgrammer {
    int mAddressHigh;
    int mAddressLow;
    int mAddress;
    int progState = 0;
    int value;
    ProgListener progListener = null;
    protected DCCppTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(DCCppOpsModeProgrammer.class);

    public DCCppOpsModeProgrammer(int pAddress, DCCppTrafficController controller) {
        this.tc = controller;
        if (log.isDebugEnabled()) {
            log.debug("Creating Ops Mode Programmer for Address {}", (Object)pAddress);
        }
        this.mAddressLow = DCCppCommandStation.getDCCAddressLow(pAddress);
        this.mAddressHigh = DCCppCommandStation.getDCCAddressHigh(pAddress);
        this.mAddress = pAddress;
        if (log.isDebugEnabled()) {
            log.debug("High Address: {} Low Address: {}", (Object)this.mAddressHigh, (Object)this.mAddressLow);
        }
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        DCCppMessage msg = DCCppMessage.makeWriteOpsModeCVMsg(this.mAddress, CV, val);
        this.tc.sendDCCppMessage(msg, null);
        this.progListener = p;
        this.value = val;
        this.progState = 1;
        assert (msg != null);
        this.restartTimer(msg.getTimeout());
        try {
            this.wait(250L);
        }
        catch (InterruptedException interruptedException) {
            log.debug("Interrupted During Delay");
        }
        this.progState = 0;
        this.stopTimer();
        this.notifyProgListenerEnd(this.progListener, this.value, 0);
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        this.notifyProgListenerEnd(p, Integer.parseInt(CVname), 8);
    }

    @Override
    public void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        this.notifyProgListenerEnd(p, val, 8);
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(ProgrammingMode.OPSBYTEMODE);
        ret.add(ProgrammingMode.OPSBITMODE);
        return ret;
    }

    @Override
    public boolean getLongAddress() {
        return true;
    }

    @Override
    public int getAddressNumber() {
        return this.mAddress;
    }

    @Override
    public String getAddress() {
        return this.getAddressNumber() + " " + this.getLongAddress();
    }

    @Override
    protected synchronized void timeout() {
        this.progState = 0;
        this.stopTimer();
        this.notifyProgListenerEnd(this.progListener, this.value, 128);
    }
}

